/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.spring.data;

import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import lombok.Generated;
import org.modelmapper.spring.data.AggregateIdentifierProcessor;
import org.springframework.util.Assert;
import org.springframework.web.util.UriTemplate;

public class UriTemplateIdentifierProcessor
implements AggregateIdentifierProcessor {
    private final Map<Class<?>, ExtractionConfiguration> configuration = new HashMap();
    private boolean onlyApplyToUri;

    public UriTemplateIdentifierProcessor register(Class<?> type, String uriTemplate) {
        Assert.notNull(type, (String)"Aggreate type must not be null!");
        Assert.hasText((String)uriTemplate, (String)"UriTemplate must not be null or empty!");
        return this.register(type, new UriTemplate(uriTemplate));
    }

    public UriTemplateIdentifierProcessor register(Class<?> type, UriTemplate template) {
        Assert.notNull(type, (String)"Aggreate type must not be null!");
        Assert.notNull((Object)template, (String)"UriTemplate must not be null!");
        List variableNames = template.getVariableNames();
        Assert.isTrue((variableNames.size() == 1 ? 1 : 0) != 0, (String)"Template must contain a single template variable.");
        return this.register(type, template, (String)variableNames.get(0));
    }

    public UriTemplateIdentifierProcessor register(Class<?> type, UriTemplate template, String variableName) {
        Assert.notNull(type, (String)"Aggregate type must not be null!");
        Assert.notNull((Object)template, (String)"UriTemplate must not be null!");
        Assert.hasText((String)variableName, (String)"Variable name must not be null or empty!");
        Function<Object, Object> uriCreator = it -> {
            HashMap<String, Object> parameters = new HashMap<String, Object>();
            parameters.put(variableName, it);
            return template.expand(parameters);
        };
        return this.register(type, template, variableName, uriCreator);
    }

    @Override
    public Object preProcessIdentifier(Object identifier, Class<?> targetType) {
        if (this.onlyApplyToUri && !URI.class.isInstance(identifier)) {
            return identifier;
        }
        ExtractionConfiguration configuration = this.configuration.get(targetType);
        if (configuration == null) {
            return identifier;
        }
        Map variables = configuration.template.match(identifier.toString());
        return variables.get(configuration.variableName);
    }

    @Override
    public Object postProcessIdentifier(Object identifier, Class<?> sourceType, Class<?> targetType) {
        if (this.onlyApplyToUri && !URI.class.isAssignableFrom(targetType)) {
            return identifier;
        }
        ExtractionConfiguration configuration = this.configuration.get(sourceType);
        return configuration == null ? identifier : configuration.uriCreator.apply(identifier);
    }

    @Override
    public Collection<Class<?>> getAdditionalIdentifierTypes() {
        return Arrays.asList(URI.class);
    }

    public boolean supports(Class<?> delimiter) {
        return this.configuration.keySet().stream().anyMatch(delimiter::isAssignableFrom);
    }

    private <T> UriTemplateIdentifierProcessor register(Class<?> type, UriTemplate template, String variableName, Function<T, Object> uriCreator) {
        Assert.notNull(type, (String)"Aggregate type must not be null!");
        Assert.notNull((Object)template, (String)"UriTemplate must not be null!");
        Assert.hasText((String)variableName, (String)"Variable name must not be null or empty!");
        this.configuration.put(type, ExtractionConfiguration.of(template, variableName, uriCreator));
        return this;
    }

    @Generated
    public UriTemplateIdentifierProcessor setOnlyApplyToUri(boolean onlyApplyToUri) {
        this.onlyApplyToUri = onlyApplyToUri;
        return this;
    }

    private static final class ExtractionConfiguration {
        private final UriTemplate template;
        private final String variableName;
        private final Function<Object, Object> uriCreator;

        @Generated
        private ExtractionConfiguration(UriTemplate template, String variableName, Function<Object, Object> uriCreator) {
            this.template = template;
            this.variableName = variableName;
            this.uriCreator = uriCreator;
        }

        @Generated
        public static ExtractionConfiguration of(UriTemplate template, String variableName, Function<Object, Object> uriCreator) {
            return new ExtractionConfiguration(template, variableName, uriCreator);
        }

        @Generated
        public UriTemplate getTemplate() {
            return this.template;
        }

        @Generated
        public String getVariableName() {
            return this.variableName;
        }

        @Generated
        public Function<Object, Object> getUriCreator() {
            return this.uriCreator;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ExtractionConfiguration)) {
                return false;
            }
            ExtractionConfiguration other = (ExtractionConfiguration)o;
            UriTemplate this$template = this.getTemplate();
            UriTemplate other$template = other.getTemplate();
            if (this$template == null ? other$template != null : !this$template.equals(other$template)) {
                return false;
            }
            String this$variableName = this.getVariableName();
            String other$variableName = other.getVariableName();
            if (this$variableName == null ? other$variableName != null : !this$variableName.equals(other$variableName)) {
                return false;
            }
            Function<Object, Object> this$uriCreator = this.getUriCreator();
            Function<Object, Object> other$uriCreator = other.getUriCreator();
            return !(this$uriCreator == null ? other$uriCreator != null : !this$uriCreator.equals(other$uriCreator));
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UriTemplate $template = this.getTemplate();
            result = result * 59 + ($template == null ? 43 : $template.hashCode());
            String $variableName = this.getVariableName();
            result = result * 59 + ($variableName == null ? 43 : $variableName.hashCode());
            Function<Object, Object> $uriCreator = this.getUriCreator();
            result = result * 59 + ($uriCreator == null ? 43 : $uriCreator.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "UriTemplateIdentifierProcessor.ExtractionConfiguration(template=" + this.getTemplate() + ", variableName=" + this.getVariableName() + ", uriCreator=" + this.getUriCreator() + ")";
        }
    }
}

