/*
 * Decompiled with CFR 0.152.
 */
package org.modelmapper.spring.autoconfigure;

import java.util.List;
import org.modelmapper.ModelMapper;
import org.modelmapper.spring.autoconfigure.ModelMapperAutoConfiguration;
import org.modelmapper.spring.data.AggregateIdentifierProcessor;
import org.modelmapper.spring.data.AggregateMappingConfigurer;
import org.modelmapper.spring.data.AggregateMappingModule;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureBefore;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.convert.ConversionService;
import org.springframework.data.repository.Repository;
import org.springframework.data.repository.support.Repositories;

@ConditionalOnClass(value={ModelMapper.class, Repository.class})
@AutoConfigureBefore(value={ModelMapperAutoConfiguration.class})
class AggregateMappingModuleAutoConfiguration {
    AggregateMappingModuleAutoConfiguration() {
    }

    @Bean
    @ConditionalOnMissingBean
    AggregateMappingModule repositoryMappingModule(ApplicationContext context, ObjectProvider<ConversionService> conversionService, List<AggregateIdentifierProcessor> processors, List<AggregateMappingConfigurer> configurers) {
        Repositories repositories = new Repositories((ListableBeanFactory)context);
        AggregateMappingModule module = new AggregateMappingModule(repositories, (ConversionService)conversionService.getIfUnique(() -> (ConversionService)context.getBean("mvcConversionService", ConversionService.class)));
        processors.forEach(module::register);
        configurers.forEach(it -> it.configure(module));
        return module;
    }
}

