/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.hotwire.webmvc.autoconfigure;

import de.odrotbohm.spring.hotwire.webmvc.Hotwire;
import de.odrotbohm.spring.hotwire.webmvc.HotwireEvents;
import de.odrotbohm.spring.hotwire.webmvc.WebMvcHotwire;
import de.odrotbohm.spring.hotwire.webmvc.autoconfigure.HotwireArgumentResolver;
import de.odrotbohm.spring.hotwire.webmvc.autoconfigure.HotwireViewHandlerInterceptor;
import java.util.List;
import lombok.NonNull;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;

@Configuration(proxyBeanMethods=false)
@ConditionalOnWebApplication(type=ConditionalOnWebApplication.Type.SERVLET)
class HotwireWebMvcAutoConfiguration
implements WebMvcConfigurer {
    @NonNull
    private final ThymeleafViewResolver resolver;
    @NonNull
    private final SpringTemplateEngine engine;
    @NonNull
    private final ObjectFactory<LocaleResolver> locales;

    @Bean
    Hotwire hotwire() {
        return new WebMvcHotwire(this.resolver, this.engine, (LocaleResolver)this.locales.getObject());
    }

    @Bean
    HotwireEvents hotwireEvents(Hotwire hotwire) {
        return new HotwireEvents(hotwire);
    }

    public void addArgumentResolvers(List<HandlerMethodArgumentResolver> resolvers) {
        resolvers.add(new HotwireArgumentResolver(this.resolver, this.engine, (LocaleResolver)this.locales.getObject()));
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new HotwireViewHandlerInterceptor(this.resolver, this.engine, (LocaleResolver)this.locales.getObject()));
    }

    public HotwireWebMvcAutoConfiguration(@NonNull ThymeleafViewResolver resolver, @NonNull SpringTemplateEngine engine, @NonNull ObjectFactory<LocaleResolver> locales) {
        if (resolver == null) {
            throw new NullPointerException("resolver is marked non-null but is null");
        }
        if (engine == null) {
            throw new NullPointerException("engine is marked non-null but is null");
        }
        if (locales == null) {
            throw new NullPointerException("locales is marked non-null but is null");
        }
        this.resolver = resolver;
        this.engine = engine;
        this.locales = locales;
    }
}

