/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.hotwire.webmvc.autoconfigure;

import de.odrotbohm.spring.hotwire.webmvc.TurboStreams;
import de.odrotbohm.spring.hotwire.webmvc.WebMvcHotwire;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;

class HotwireViewHandlerInterceptor
implements HandlerInterceptor {
    private final WebMvcHotwire hotwire;

    public HotwireViewHandlerInterceptor(ThymeleafViewResolver views, SpringTemplateEngine engine, LocaleResolver locales) {
        this.hotwire = new WebMvcHotwire(views, engine, locales);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (modelAndView == null || !HandlerMethod.class.isInstance(handler)) {
            return;
        }
        HandlerMethod method = (HandlerMethod)handler;
        if (!method.getReturnType().getParameterType().equals(TurboStreams.class)) {
            return;
        }
        Object attribute = modelAndView.getModel().get("turboStreams");
        if (!TurboStreams.class.isInstance(attribute)) {
            return;
        }
        TurboStreams streams = (TurboStreams)attribute;
        modelAndView.setView(this.hotwire.toView(streams));
    }

    public HotwireViewHandlerInterceptor(WebMvcHotwire hotwire) {
        this.hotwire = hotwire;
    }
}

