/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.hotwire.webmvc.autoconfigure;

import de.odrotbohm.spring.hotwire.webmvc.Hotwire;
import de.odrotbohm.spring.hotwire.webmvc.WebMvcHotwire;
import lombok.NonNull;
import org.springframework.core.MethodParameter;
import org.springframework.web.bind.support.WebDataBinderFactory;
import org.springframework.web.context.request.NativeWebRequest;
import org.springframework.web.method.support.HandlerMethodArgumentResolver;
import org.springframework.web.method.support.ModelAndViewContainer;
import org.springframework.web.servlet.LocaleResolver;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;

class HotwireArgumentResolver
implements HandlerMethodArgumentResolver {
    @NonNull
    private final ThymeleafViewResolver views;
    @NonNull
    private final SpringTemplateEngine engine;
    @NonNull
    private final LocaleResolver locales;

    public boolean supportsParameter(MethodParameter parameter) {
        return Hotwire.class.isAssignableFrom(parameter.getParameterType());
    }

    public Object resolveArgument(MethodParameter parameter, ModelAndViewContainer mavContainer, NativeWebRequest webRequest, WebDataBinderFactory binderFactory) throws Exception {
        return new WebMvcHotwire(this.views, this.engine, this.locales);
    }

    public HotwireArgumentResolver(@NonNull ThymeleafViewResolver views, @NonNull SpringTemplateEngine engine, @NonNull LocaleResolver locales) {
        if (views == null) {
            throw new NullPointerException("views is marked non-null but is null");
        }
        if (engine == null) {
            throw new NullPointerException("engine is marked non-null but is null");
        }
        if (locales == null) {
            throw new NullPointerException("locales is marked non-null but is null");
        }
        this.views = views;
        this.engine = engine;
        this.locales = locales;
    }
}

