/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.hotwire.webmvc;

import de.odrotbohm.spring.hotwire.webmvc.Hotwire;
import de.odrotbohm.spring.hotwire.webmvc.TurboStreams;
import java.io.PrintWriter;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import lombok.NonNull;
import org.springframework.util.Assert;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.thymeleaf.TemplateSpec;
import org.thymeleaf.context.Context;
import org.thymeleaf.context.IContext;
import org.thymeleaf.spring5.SpringTemplateEngine;
import org.thymeleaf.spring5.view.ThymeleafView;
import org.thymeleaf.spring5.view.ThymeleafViewResolver;
import org.thymeleaf.templatemode.TemplateMode;

public class WebMvcHotwire
implements Hotwire {
    @NonNull
    private final ThymeleafViewResolver views;
    @NonNull
    private final SpringTemplateEngine engine;
    @NonNull
    private final LocaleResolver locales;

    @Override
    public TurboStreams stream() {
        return new TurboStreams();
    }

    @Override
    public View toView(TurboStreams streams) {
        Assert.notNull((Object)streams, (String)"TurboStreams must not be null!");
        return (model, request, response) -> {
            Locale locale = this.locales.resolveLocale(request);
            PrintWriter writer = response.getWriter();
            for (TurboStreams.TurboStream it : streams.toIterable()) {
                writer.write(it.openStream());
                if (!it.isRemove()) {
                    writer.write(it.openTemplateFormatted());
                    ThymeleafView delegate = (ThymeleafView)this.views.resolveViewName(it.getTemplate(), locale);
                    delegate.setContentType("text/vnd.turbo-stream.html");
                    delegate.render(model, request, response);
                    writer.write(it.closeTemplateFormatted());
                }
                writer.write(it.closeStream());
            }
        };
    }

    @Override
    public String toSsePayload(TurboStreams streams, Map<String, Object> model) {
        Assert.notNull((Object)streams, (String)"TurboStreams must not be null!");
        Assert.notNull(model, (String)"Model must not be null!");
        StringBuilder builder = new StringBuilder();
        for (TurboStreams.TurboStream it : streams.toIterable()) {
            builder.append(it.openStream());
            if (!it.isRemove()) {
                Context context = new Context();
                context.setVariables(model);
                String[] parts = it.getTemplate().split("::");
                Set fragments = parts.length > 1 ? Collections.singleton(parts[1].trim()) : Collections.emptySet();
                TemplateSpec spec = new TemplateSpec(parts[0].trim(), fragments, TemplateMode.HTML, null);
                builder.append(it.openTemplate());
                builder.append(this.engine.process(spec, (IContext)context).replaceAll("\n", ""));
                builder.append(it.closeTemplate());
            }
            builder.append(it.closeStream());
        }
        return builder.toString();
    }

    public WebMvcHotwire(@NonNull ThymeleafViewResolver views, @NonNull SpringTemplateEngine engine, @NonNull LocaleResolver locales) {
        if (views == null) {
            throw new NullPointerException("views is marked non-null but is null");
        }
        if (engine == null) {
            throw new NullPointerException("engine is marked non-null but is null");
        }
        if (locales == null) {
            throw new NullPointerException("locales is marked non-null but is null");
        }
        this.views = views;
        this.engine = engine;
        this.locales = locales;
    }
}

