/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.hotwire.webmvc;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import org.springframework.util.Assert;

public class TurboStreams {
    private final Collection<TurboStream> streams;

    public TurboStreams() {
        this.streams = new ArrayList<TurboStream>();
    }

    public TurboStreamBuilder append(String target) {
        return new TurboStreamBuilder(this.streams, target, Action.APPEND);
    }

    public TurboStreamBuilder prepend(String target) {
        return new TurboStreamBuilder(this.streams, target, Action.PREPEND);
    }

    public TurboStreams remove(String target) {
        return new TurboStreamBuilder(this.streams, target, Action.REMOVE).with("\u00af\\_(\u30c4)_/\u00af");
    }

    public TurboStreamBuilder replace(String target) {
        return new TurboStreamBuilder(this.streams, target, Action.REPLACE);
    }

    public TurboStreamBuilder update(String target) {
        return new TurboStreamBuilder(this.streams, target, Action.UPDATE);
    }

    Iterable<TurboStream> toIterable() {
        return () -> this.streams.iterator();
    }

    TurboStreams(Collection<TurboStream> streams) {
        this.streams = streams;
    }

    public static final class TurboStreamBuilder {
        private final Collection<TurboStream> streams;
        private final String target;
        private final Action action;

        public TurboStreams with(String templateOrFragment) {
            return this.and(new TurboStream(this.action, this.target, templateOrFragment));
        }

        public TurboStreams withinTemplate(String template) {
            Assert.hasText((String)template, (String)"Template name must not be null or empty!");
            return this.and(new TurboStream(this.action, this.target, template.concat(" :: ".concat(this.target))));
        }

        public TurboStreams withFragment(String fragment) {
            Assert.hasText((String)fragment, (String)"Fragment must not be null or empty!");
            Assert.isTrue((boolean)fragment.contains("::"), () -> "Invalid fragment identifier " + fragment + "!");
            return this.and(new TurboStream(this.action, this.target, fragment));
        }

        private TurboStreams and(TurboStream stream) {
            ArrayList<TurboStream> list = new ArrayList<TurboStream>(this.streams);
            list.add(stream);
            return new TurboStreams(list);
        }

        public Collection<TurboStream> getStreams() {
            return this.streams;
        }

        public String getTarget() {
            return this.target;
        }

        public Action getAction() {
            return this.action;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TurboStreamBuilder)) {
                return false;
            }
            TurboStreamBuilder other = (TurboStreamBuilder)o;
            Collection<TurboStream> this$streams = this.getStreams();
            Collection<TurboStream> other$streams = other.getStreams();
            if (this$streams == null ? other$streams != null : !((Object)this$streams).equals(other$streams)) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            Action this$action = this.getAction();
            Action other$action = other.getAction();
            return !(this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Collection<TurboStream> $streams = this.getStreams();
            result = result * 59 + ($streams == null ? 43 : ((Object)$streams).hashCode());
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            Action $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            return result;
        }

        public String toString() {
            return "TurboStreams.TurboStreamBuilder(streams=" + this.getStreams() + ", target=" + this.getTarget() + ", action=" + (Object)((Object)this.getAction()) + ")";
        }

        TurboStreamBuilder(Collection<TurboStream> streams, String target, Action action) {
            this.streams = streams;
            this.target = target;
            this.action = action;
        }
    }

    public static enum Action {
        APPEND,
        PREPEND,
        REPLACE,
        UPDATE,
        REMOVE;


        String toAttribute() {
            return this.name().toLowerCase(Locale.ENGLISH);
        }
    }

    static final class TurboStream {
        private final Action action;
        private final String target;
        private final String template;

        String openStream() {
            return String.format("<turbo-stream action=\"%s\" target=\"%s\">", this.action.toAttribute(), this.target);
        }

        String closeStream() {
            return "</turbo-stream>\n";
        }

        String openTemplate() {
            return "<template>";
        }

        String openTemplateFormatted() {
            return String.format("\n\t%s\n\t\t", this.openTemplate());
        }

        String closeTemplate() {
            return "</template>";
        }

        String closeTemplateFormatted() {
            return String.format("\n\t%s\n", this.closeTemplate());
        }

        boolean isRemove() {
            return Action.REMOVE.equals((Object)this.action);
        }

        public TurboStream(Action action, String target, String template) {
            this.action = action;
            this.target = target;
            this.template = template;
        }

        public Action getAction() {
            return this.action;
        }

        public String getTarget() {
            return this.target;
        }

        public String getTemplate() {
            return this.template;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TurboStream)) {
                return false;
            }
            TurboStream other = (TurboStream)o;
            Action this$action = this.getAction();
            Action other$action = other.getAction();
            if (this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action)) {
                return false;
            }
            String this$target = this.getTarget();
            String other$target = other.getTarget();
            if (this$target == null ? other$target != null : !this$target.equals(other$target)) {
                return false;
            }
            String this$template = this.getTemplate();
            String other$template = other.getTemplate();
            return !(this$template == null ? other$template != null : !this$template.equals(other$template));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Action $action = this.getAction();
            result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
            String $target = this.getTarget();
            result = result * 59 + ($target == null ? 43 : $target.hashCode());
            String $template = this.getTemplate();
            result = result * 59 + ($template == null ? 43 : $template.hashCode());
            return result;
        }

        public String toString() {
            return "TurboStreams.TurboStream(action=" + (Object)((Object)this.getAction()) + ", target=" + this.getTarget() + ", template=" + this.getTemplate() + ")";
        }
    }
}

