/*
 * Decompiled with CFR 0.152.
 */
package de.odrotbohm.spring.hotwire.webmvc;

import de.odrotbohm.spring.hotwire.webmvc.Hotwire;
import de.odrotbohm.spring.hotwire.webmvc.TurboStreams;
import java.io.IOException;
import java.time.Duration;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.context.annotation.Scope;
import org.springframework.lang.Nullable;
import org.springframework.web.servlet.mvc.method.annotation.SseEmitter;

@Scope(value="prototype")
public class HotwireEvents {
    private static final String DEFAULT_STREAM_NAME = "\u00af\\_(\u30c4)_/\u00af";
    private final Map<String, SseEmitter> streams = new ConcurrentHashMap<String, SseEmitter>();
    private final Hotwire delegate;

    public SseEmitter initStream() {
        return this.initStream(DEFAULT_STREAM_NAME);
    }

    public SseEmitter initStream(String name) {
        return this.initStreamInternal(name, null);
    }

    public SseEmitter initStream(String name, Duration duration) {
        return this.initStreamInternal(name, duration);
    }

    public void push(TurboStreams streams, Map<String, Object> model) throws IOException {
        this.push(streams, model, DEFAULT_STREAM_NAME);
    }

    public void push(TurboStreams streams, Map<String, Object> model, String stream) throws IOException {
        this.push(stream, this.delegate.toSsePayload(streams, model));
    }

    private SseEmitter initStreamInternal(String name, @Nullable Duration duration) {
        SseEmitter emitter = duration == null ? new SseEmitter() : new SseEmitter(Long.valueOf(duration.toMillis()));
        emitter.onCompletion(() -> this.streams.remove(name));
        emitter.onError(it -> this.streams.remove(name));
        emitter.onTimeout(() -> this.streams.remove(name));
        this.streams.put(name, emitter);
        return emitter;
    }

    private void push(String stream, Object payload) throws IOException {
        SseEmitter emitter = this.streams.get(stream);
        if (emitter == null) {
            return;
        }
        emitter.send(payload);
    }

    public HotwireEvents(Hotwire delegate) {
        this.delegate = delegate;
    }
}

