/*
 * Decompiled with CFR 0.152.
 */
package de.ocarthon.libArcus;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import java.util.HashMap;
import java.util.Map;

class MessageTypeStore {
    private Map<Integer, Parser> parserMap = new HashMap<Integer, Parser>();

    MessageTypeStore() {
    }

    private int hash(String in) {
        int hash = -2128831035;
        for (int i = 0; i < in.length(); ++i) {
            hash ^= in.charAt(i) & 0xFF;
            hash *= 16777619;
        }
        return hash;
    }

    public int getMessageTypeId(String messageTypeName) {
        return this.hash(messageTypeName);
    }

    public int getMessageTypeId(Message message) {
        return this.hash(message.getDescriptorForType().getFullName());
    }

    public boolean hasType(int hash) {
        return this.parserMap.containsKey(hash);
    }

    public boolean hasType(String typeName) {
        return this.parserMap.containsKey(this.hash(typeName));
    }

    public boolean registerType(Message message) {
        int hash = this.getMessageTypeId(message);
        if (!this.parserMap.containsKey(hash)) {
            this.parserMap.put(hash, message.getParserForType());
            return true;
        }
        return false;
    }

    public Message parse(int hash, byte[] data) throws InvalidProtocolBufferException {
        Parser parser = this.parserMap.get(hash);
        if (parser == null) {
            throw new IllegalArgumentException("Unregistered type");
        }
        return (Message)this.parserMap.get(hash).parseFrom(data);
    }
}

