/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.wsc.server;

import de.objektkontor.config.Backend;
import de.objektkontor.config.ConfigLoader;
import de.objektkontor.config.Configuration;
import de.objektkontor.wsc.server.Activator;
import de.objektkontor.wsc.server.Logger;
import de.objektkontor.wsc.server.ServerConfig;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.apache.felix.framework.Felix;
import org.slf4j.LoggerFactory;

public class Server {
    private static final org.slf4j.Logger log = LoggerFactory.getLogger(Server.class);
    private static final Attributes.Name EXPORT_PACKAGE = new Attributes.Name("Export-Package");

    private static Map<Object, Object> createFelixConfig(Activator activator, ServerConfig config) throws IOException {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        LinkedList<Activator> activators = new LinkedList<Activator>();
        activators.add(activator);
        result.put("org.osgi.framework.storage", config.getBundleCacheDir());
        result.put("org.osgi.framework.system.packages.extra", Server.getSystemPackages(config));
        result.put("felix.systembundle.activators", activators);
        result.put("felix.log.logger", (Object)new Logger(log));
        result.put("felix.log.level", "4");
        return result;
    }

    private static String getSystemPackages(ServerConfig config) throws IOException {
        String packages = config.getSystemPackages();
        Throwable throwable = null;
        Object var3_4 = null;
        try (InputStream in = Server.class.getClassLoader().getResourceAsStream("META-INF/MANIFEST.MF");){
            Manifest manifest = new Manifest(in);
            String exports = manifest.getMainAttributes().getValue(EXPORT_PACKAGE);
            packages = packages == null || packages.length() == 0 ? exports : String.valueOf(exports) + "," + packages;
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return packages;
    }

    public static void main(String ... args) throws Exception {
        System.getProperties().setProperty("java.protocol.handler.pkgs", "org.ops4j.pax.url");
        ConfigLoader configLoader = new ConfigLoader((Backend)new Configuration(), "wsc");
        ServerConfig config = (ServerConfig)configLoader.loadConfig((Object)new ServerConfig());
        Activator activator = new Activator(config);
        final Felix felix = new Felix(Server.createFelixConfig(activator, config));
        Runtime.getRuntime().addShutdownHook(new Thread("Felix Shutdown Hook"){

            @Override
            public void run() {
                try {
                    log.info("Stopping embedded osgi container");
                    felix.stop();
                    felix.waitForStop(0L);
                }
                catch (Exception e) {
                    log.error("Error stopping osgi container: " + e);
                }
            }
        });
        log.info("Initializing embedded osgi container");
        felix.init();
        log.info("Starting embedded osgi container");
        felix.start();
        felix.waitForStop(0L);
    }
}

