/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.wsc.server;

import de.objektkontor.wsc.server.ServerConfig;
import de.objektkontor.wsc.server.bundle.BundleConfig;
import de.objektkontor.wsc.server.bundle.BundleKey;
import de.objektkontor.wsc.server.bundle.BundleLocator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Activator
implements BundleActivator {
    private static final Logger log = LoggerFactory.getLogger(Activator.class);
    private static final Attributes.Name BUNDLE_SYMBOLIC_NAME = new Attributes.Name("Bundle-SymbolicName");
    private static final Attributes.Name BUNDLE_VERSION = new Attributes.Name("Bundle-Version");
    private final Map<BundleKey, Bundle> bundles = new HashMap<BundleKey, Bundle>();
    private final Map<String, BundleKey> locations = new HashMap<String, BundleKey>();
    private final ServerConfig config;
    private BundleContext context;

    public Activator(ServerConfig config) {
        this.config = config;
    }

    public void start(BundleContext context) throws Exception {
        this.context = context;
        this.initBundles();
    }

    public void stop(BundleContext context) throws Exception {
        this.context = null;
        this.bundles.clear();
        this.locations.clear();
    }

    public BundleContext context() {
        return this.context;
    }

    private List<BundleLocator> getBundles(File bundleDir) throws IOException {
        if (!bundleDir.exists()) {
            throw new IOException("Bundle dir not found: " + bundleDir);
        }
        File[] bundleFiles = bundleDir.listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.isFile() && file.getName().endsWith(".jar");
            }
        });
        ArrayList<BundleLocator> result = new ArrayList<BundleLocator>(bundleFiles.length);
        File[] fileArray = bundleFiles;
        int n = bundleFiles.length;
        int n2 = 0;
        while (n2 < n) {
            File bundleFile = fileArray[n2];
            Throwable throwable = null;
            Object var9_10 = null;
            try (JarFile jarFile = new JarFile(bundleFile);){
                Manifest manifest = jarFile.getManifest();
                String name = manifest.getMainAttributes().getValue(BUNDLE_SYMBOLIC_NAME);
                String version = manifest.getMainAttributes().getValue(BUNDLE_VERSION);
                if (name != null && version != null) {
                    BundleKey key = new BundleKey(name, new Version(version));
                    BundleLocator locator = new BundleLocator(key, "file:" + bundleFile.getAbsolutePath());
                    result.add(locator);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            ++n2;
        }
        return result;
    }

    private BundleLocator getBundle(BundleConfig bundleConfig) throws BundleException {
        BundleKey bundleKey = this.locations.get(bundleConfig.getLocation());
        if (bundleKey == null) {
            Bundle bundle = this.context.installBundle(bundleConfig.getLocation());
            return new BundleLocator(bundle);
        }
        return new BundleLocator(bundleKey, bundleConfig.getLocation());
    }

    private void initBundles() throws BundleException, IOException {
        Object[] objectArray = this.context.getBundles();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Bundle bundle = objectArray[n2];
            BundleKey bundleKey = new BundleKey(bundle);
            this.bundles.put(bundleKey, bundle);
            this.locations.put(bundle.getLocation(), bundleKey);
            ++n2;
        }
        objectArray = this.config.getBundles();
        n = objectArray.length;
        n2 = 0;
        while (n2 < n) {
            Bundle bundleConfig = objectArray[n2];
            if (bundleConfig.getDependenciesDir() != null) {
                File dependenciesDir = new File(bundleConfig.getDependenciesDir());
                for (BundleLocator bundleLocator : this.getBundles(dependenciesDir)) {
                    this.initBundle(bundleLocator);
                }
            }
            BundleLocator bundleLocator = this.getBundle((BundleConfig)bundleConfig);
            this.initBundle(bundleLocator);
            ++n2;
        }
    }

    private void initBundle(BundleLocator bundleLocator) throws BundleException {
        log.debug("Initializing bundle: " + bundleLocator.getKey());
        Bundle bundle = this.bundles.get(bundleLocator.getKey());
        if (bundle == null) {
            log.debug("--> installing new bundle");
            bundle = this.context.installBundle(bundleLocator.getLocation());
            this.bundles.put(bundleLocator.getKey(), bundle);
            this.locations.put(bundleLocator.getLocation(), bundleLocator.getKey());
        } else {
            log.debug("--> update existing bundle: ");
            bundle.update();
        }
        bundle.start();
    }
}

