/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.config.tomcatjdbc;

import de.objektkontor.config.annotation.ConfigParameter;
import de.objektkontor.config.common.DBConfig;
import java.time.Duration;
import org.apache.tomcat.jdbc.pool.DataSource;

public class TomcatJdbcPoolConfig {
    @ConfigParameter(description="The initial number of connections that are created when the pool is started")
    private int initialSize = 10;
    @ConfigParameter(description="The maximum number of active connections that can be allocated from this pool at the same time")
    private int maxActive = 100;
    @ConfigParameter(description="The minimum number of established connections that should be kept in the pool at all times")
    private int minIdle = 10;
    @ConfigParameter(description="The maximum number of connections that should be kept in the pool at all times")
    private int maxIdle = 100;
    @ConfigParameter(description="The maximum number of milliseconds that the pool will wait (when there are no available connections) for a connection to be returned before throwing an exception")
    private Duration maxWait = Duration.ofSeconds(30L);
    @ConfigParameter(description="Sets the maximum time in seconds that this data source will waie while attempting to connect to a database A value of zero specifies that the timeout is the default system timeout if there is one; otherwise, it specifies that there is no timeout")
    private Duration loginTimeout = Duration.ofSeconds(0L);
    @ConfigParameter(description="The indication of whether objects will be validated before being borrowed from the pool. If the object fails to validate, it will be dropped from the pool, and we will attempt to borrow another")
    private boolean testOnBorrow = false;
    @ConfigParameter(description="The indication of whether objects will be validated when a connection is first created. If an object fails to validate, it will be throw SQLException")
    private boolean testOnConnect = false;
    @ConfigParameter(description="The indication of whether objects will be validated before being returned to the pool")
    private boolean testOnReturn = false;
    @ConfigParameter(description="The indication of whether objects will be validated by the idle object evictor (if any). If an object fails to validate, it will be dropped from the pool")
    private boolean testWhileIdle;
    @ConfigParameter(description="Register the pool with JMX or not")
    private boolean jmxEnabled = true;
    @ConfigParameter(description="Set to true if you wish that calls to getConnection should be treated fairly in a true FIFO fashion. This uses the org.apache.tomcat.jdbc.pool.FairBlockingQueue implementation for the list of the idle connections. This flag is required when you want to use asynchronous connection retrieval. Setting this flag ensures that threads receive connections in the order they arrive")
    private boolean fairQueue = true;
    @ConfigParameter(description="The connection properties that will be sent to our JDBC driver when establishing new connections. Format of the string must be [propertyName=property;]")
    private String connectionProperties;
    @ConfigParameter(description="A custom query to be run when a connection is first created")
    private String initSQL;
    @ConfigParameter(description="The default auto-commit state of connections created by this pool. If not set, default is JDBC driver default (the setAutoCommit method will not be called)")
    private Boolean defaultAutoCommit;
    @ConfigParameter(description="The default read-only state of connections created by this pool. If not set then the setReadOnly method will not be called")
    private Boolean defaultReadOnly;
    @ConfigParameter(description="The default TransactionIsolation state of connections created by this pool. If not set, the method will not be called and it defaults to the JDBC driver")
    private TransactionIsolation defaultTransactionIsolation;
    @ConfigParameter(description="The default catalog of connections created by this pool")
    private String defaultCatalog;
    @ConfigParameter(description="If autoCommit==false then the pool can terminate the transaction by calling rollback on the connection as it is returned to the pool")
    private boolean rollbackOnReturn;
    @ConfigParameter(description="If autoCommit==false then the pool can complete the transaction by calling commit on the connection as it is returned to the pool. If rollbackOnReturn==true then this attribute is ignored")
    private boolean commitOnReturn;
    @ConfigParameter(description="The SQL query that will be used to validate connections from this pool before returning them to the caller")
    private String validationQuery;
    @ConfigParameter(description="Avoid excess validation, only run validation at most at this frequency. If a connection is due for validation, but has been validated previously within this interval, it will not be validated again")
    private Duration validationInterval = Duration.ofSeconds(30L);
    @ConfigParameter(description="The timeout before a connection validation queries fail")
    private Duration validationQueryTimeout = Duration.ofSeconds(-1L);
    @ConfigParameter(description="Set this to true to log errors during the validation phase to the log file")
    private boolean logValidationErrors = false;
    @ConfigParameter(description="Time to keep the connection. When a connection is returned to the pool, the pool will check to see if the now - time-when-connected > maxAge has been reached, and if so, it closes the connection rather than returning it to the pool. 0 means that connections will be left open and no age check will be done upon returning the connection to the pool")
    private Duration maxAge = Duration.ofSeconds(0L);
    @ConfigParameter(description="Time to sleep between runs of the idle connection validation/cleaner thread. This value should not be set under 1 second. It dictates how often we check for idle, abandoned connections, and how often we validate idle connections")
    private Duration timeBetweenEvictionRuns = Duration.ofSeconds(5L);
    @ConfigParameter(description="The minimum amount of time an object may sit idle in the pool before it is eligible for eviction")
    private Duration minEvictableIdleTime = Duration.ofSeconds(60L);
    @ConfigParameter(description="Flag to log stack traces for application code which abandoned a Connection. Logging of abandoned Connections adds overhead for every Connection borrow because a stack trace has to be generated")
    private boolean logAbandoned = false;
    @ConfigParameter(description="Flag to remove abandoned connections if they exceed the removeAbandonedTimeout. If set to true a connection is considered abandoned and eligible for removal if it has been in use longer than the removeAbandonedTimeout. Setting this to true can recover db connections from applications that fail to close a connection")
    private boolean removeAbandoned = false;
    @ConfigParameter(description="Timeout before an abandoned(in use) connection can be removed. The value should be set to the longest running query your applications might have")
    private Duration removeAbandonedTimeout = Duration.ofSeconds(60L);
    @ConfigParameter(description="Connections that have been abandoned (timed out) wont get closed and reported up unless the number of connections in use are above the percentage defined by abandonWhenPercentageFull. The value should be between 0-100. 0 means that connections are eligible for closure as soon as removeAbandonedTimeout has been reached")
    private int abandonWhenPercentageFull = 0;
    @ConfigParameter(description="Timeout Similar to to the removeAbandonedTimeout value but instead of treating the connection as abandoned, this simply logs the warning if logAbandoned is set to true. If this value is equal or less than 0, no suspect checking will be performed. Suspect checking only takes place if the timeout value is larger than 0 and the connection was not abandoned or if abandon check is disabled. If a connection is suspect a WARN message gets logged and a JMX notification gets sent once")
    private Duration suspectTimeout = Duration.ofSeconds(0L);

    public void applyTo(DataSource dataSource) {
        dataSource.setInitialSize(this.initialSize);
        dataSource.setMaxActive(this.maxActive);
        dataSource.setMinIdle(this.minIdle);
        dataSource.setMaxIdle(this.maxIdle);
        dataSource.setMaxWait((int)this.maxWait.toMillis());
        dataSource.setLoginTimeout((int)this.loginTimeout.getSeconds());
        dataSource.setTestOnBorrow(this.testOnBorrow);
        dataSource.setTestOnConnect(this.testOnConnect);
        dataSource.setTestOnReturn(this.testOnReturn);
        dataSource.setTestWhileIdle(this.testWhileIdle);
        dataSource.setJmxEnabled(this.jmxEnabled);
        dataSource.setFairQueue(this.fairQueue);
        if (this.connectionProperties != null) {
            dataSource.setConnectionProperties(this.connectionProperties);
        }
        if (this.initSQL != null) {
            dataSource.setInitSQL(this.initSQL);
        }
        if (this.defaultAutoCommit != null) {
            dataSource.setDefaultAutoCommit(this.defaultAutoCommit);
        }
        if (this.defaultReadOnly != null) {
            dataSource.setDefaultReadOnly(this.defaultReadOnly);
        }
        if (this.defaultTransactionIsolation != null) {
            dataSource.setDefaultTransactionIsolation(this.defaultTransactionIsolation.getConstantValue());
        }
        if (this.defaultCatalog != null) {
            dataSource.setDefaultCatalog(this.defaultCatalog);
        }
        dataSource.setRollbackOnReturn(this.rollbackOnReturn);
        dataSource.setCommitOnReturn(this.commitOnReturn);
        if (this.validationQuery != null) {
            dataSource.setValidationQuery(this.validationQuery);
        }
        dataSource.setValidationInterval(this.validationInterval.toMillis());
        dataSource.setValidationQueryTimeout((int)this.validationQueryTimeout.getSeconds());
        dataSource.setLogValidationErrors(this.logValidationErrors);
        dataSource.setMaxAge(this.maxAge.toMillis());
        dataSource.setTimeBetweenEvictionRunsMillis((int)this.timeBetweenEvictionRuns.toMillis());
        dataSource.setMinEvictableIdleTimeMillis((int)this.minEvictableIdleTime.toMillis());
        dataSource.setLogAbandoned(this.logAbandoned);
        dataSource.setRemoveAbandoned(this.removeAbandoned);
        dataSource.setRemoveAbandonedTimeout((int)this.removeAbandonedTimeout.getSeconds());
        dataSource.setAbandonWhenPercentageFull(this.abandonWhenPercentageFull);
        dataSource.setSuspectTimeout((int)this.suspectTimeout.getSeconds());
    }

    public static void applyJdbcConfig(DBConfig dbConfig, DataSource dataSource) {
        dataSource.setDriverClassName(dbConfig.getDriver());
        dataSource.setUrl(dbConfig.getUrl());
        dataSource.setUsername(dbConfig.getUser());
        dataSource.setPassword(dbConfig.getPassword());
    }

    public int getInitialSize() {
        return this.initialSize;
    }

    public void setInitialSize(int initialSize) {
        this.initialSize = initialSize;
    }

    public int getMaxActive() {
        return this.maxActive;
    }

    public void setMaxActive(int maxActive) {
        this.maxActive = maxActive;
    }

    public int getMinIdle() {
        return this.minIdle;
    }

    public void setMinIdle(int minIdle) {
        this.minIdle = minIdle;
    }

    public int getMaxIdle() {
        return this.maxIdle;
    }

    public void setMaxIdle(int maxIdle) {
        this.maxIdle = maxIdle;
    }

    public Duration getMaxWait() {
        return this.maxWait;
    }

    public void setMaxWait(Duration maxWait) {
        this.maxWait = maxWait;
    }

    public Duration getLoginTimeout() {
        return this.loginTimeout;
    }

    public void setLoginTimeout(Duration loginTimeout) {
        this.loginTimeout = loginTimeout;
    }

    public boolean isTestOnBorrow() {
        return this.testOnBorrow;
    }

    public void setTestOnBorrow(boolean testOnBorrow) {
        this.testOnBorrow = testOnBorrow;
    }

    public boolean isTestOnConnect() {
        return this.testOnConnect;
    }

    public void setTestOnConnect(boolean testOnConnect) {
        this.testOnConnect = testOnConnect;
    }

    public boolean isTestOnReturn() {
        return this.testOnReturn;
    }

    public void setTestOnReturn(boolean testOnReturn) {
        this.testOnReturn = testOnReturn;
    }

    public boolean isTestWhileIdle() {
        return this.testWhileIdle;
    }

    public void setTestWhileIdle(boolean testWhileIdle) {
        this.testWhileIdle = testWhileIdle;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public void setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
    }

    public boolean isFairQueue() {
        return this.fairQueue;
    }

    public void setFairQueue(boolean fairQueue) {
        this.fairQueue = fairQueue;
    }

    public String getConnectionProperties() {
        return this.connectionProperties;
    }

    public void setConnectionProperties(String connectionProperties) {
        this.connectionProperties = connectionProperties;
    }

    public String getInitSQL() {
        return this.initSQL;
    }

    public void setInitSQL(String initSQL) {
        this.initSQL = initSQL;
    }

    public Boolean getDefaultAutoCommit() {
        return this.defaultAutoCommit;
    }

    public void setDefaultAutoCommit(Boolean defaultAutoCommit) {
        this.defaultAutoCommit = defaultAutoCommit;
    }

    public Boolean getDefaultReadOnly() {
        return this.defaultReadOnly;
    }

    public void setDefaultReadOnly(Boolean defaultReadOnly) {
        this.defaultReadOnly = defaultReadOnly;
    }

    public TransactionIsolation getDefaultTransactionIsolation() {
        return this.defaultTransactionIsolation;
    }

    public void setDefaultTransactionIsolation(TransactionIsolation defaultTransactionIsolation) {
        this.defaultTransactionIsolation = defaultTransactionIsolation;
    }

    public String getDefaultCatalog() {
        return this.defaultCatalog;
    }

    public void setDefaultCatalog(String defaultCatalog) {
        this.defaultCatalog = defaultCatalog;
    }

    public boolean isRollbackOnReturn() {
        return this.rollbackOnReturn;
    }

    public void setRollbackOnReturn(boolean rollbackOnReturn) {
        this.rollbackOnReturn = rollbackOnReturn;
    }

    public boolean isCommitOnReturn() {
        return this.commitOnReturn;
    }

    public void setCommitOnReturn(boolean commitOnReturn) {
        this.commitOnReturn = commitOnReturn;
    }

    public String getValidationQuery() {
        return this.validationQuery;
    }

    public void setValidationQuery(String validationQuery) {
        this.validationQuery = validationQuery;
    }

    public Duration getValidationInterval() {
        return this.validationInterval;
    }

    public void setValidationInterval(Duration validationInterval) {
        this.validationInterval = validationInterval;
    }

    public Duration getValidationQueryTimeout() {
        return this.validationQueryTimeout;
    }

    public void setValidationQueryTimeout(Duration validationQueryTimeout) {
        this.validationQueryTimeout = validationQueryTimeout;
    }

    public boolean isLogValidationErrors() {
        return this.logValidationErrors;
    }

    public void setLogValidationErrors(boolean logValidationErrors) {
        this.logValidationErrors = logValidationErrors;
    }

    public Duration getMaxAge() {
        return this.maxAge;
    }

    public void setMaxAge(Duration maxAge) {
        this.maxAge = maxAge;
    }

    public Duration getTimeBetweenEvictionRuns() {
        return this.timeBetweenEvictionRuns;
    }

    public void setTimeBetweenEvictionRuns(Duration timeBetweenEvictionRuns) {
        this.timeBetweenEvictionRuns = timeBetweenEvictionRuns;
    }

    public Duration getMinEvictableIdleTime() {
        return this.minEvictableIdleTime;
    }

    public void setMinEvictableIdleTime(Duration minEvictableIdleTime) {
        this.minEvictableIdleTime = minEvictableIdleTime;
    }

    public boolean isLogAbandoned() {
        return this.logAbandoned;
    }

    public void setLogAbandoned(boolean logAbandoned) {
        this.logAbandoned = logAbandoned;
    }

    public boolean isRemoveAbandoned() {
        return this.removeAbandoned;
    }

    public void setRemoveAbandoned(boolean removeAbandoned) {
        this.removeAbandoned = removeAbandoned;
    }

    public Duration getRemoveAbandonedTimeout() {
        return this.removeAbandonedTimeout;
    }

    public void setRemoveAbandonedTimeout(Duration removeAbandonedTimeout) {
        this.removeAbandonedTimeout = removeAbandonedTimeout;
    }

    public int getAbandonWhenPercentageFull() {
        return this.abandonWhenPercentageFull;
    }

    public void setAbandonWhenPercentageFull(int abandonWhenPercentageFull) {
        this.abandonWhenPercentageFull = abandonWhenPercentageFull;
    }

    public Duration getSuspectTimeout() {
        return this.suspectTimeout;
    }

    public void setSuspectTimeout(Duration suspectTimeout) {
        this.suspectTimeout = suspectTimeout;
    }

    public static enum TransactionIsolation {
        NONE(0),
        READ_UNCOMMITTED(1),
        REPEATABLE_READ(4),
        READ_COMMITTED(2),
        SERIALIZABLE(8);

        private final int constantValue;

        private TransactionIsolation(int constantValue) {
            this.constantValue = constantValue;
        }

        public int getConstantValue() {
            return this.constantValue;
        }
    }
}

