/*
 * Decompiled with CFR 0.152.
 */
package de.objektkontor.clp;

import de.objektkontor.clp.InvalidParameterException;
import de.objektkontor.clp.ParameterConverter;
import de.objektkontor.clp.ParameterValidator;
import de.objektkontor.clp.annotation.CommandLineParameter;
import de.objektkontor.clp.annotation.CommandLineValidator;
import de.objektkontor.clp.converter.ByteConverter;
import de.objektkontor.clp.converter.CharacterConverter;
import de.objektkontor.clp.converter.EnumConverter;
import de.objektkontor.clp.converter.IntegerConverter;
import de.objektkontor.clp.converter.LongConverter;
import de.objektkontor.clp.converter.ShortConverter;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Parser<V> {
    private final String cmdLineSyntax;
    private final Map<Field, Parameter> parametersMap = new LinkedHashMap<Field, Parameter>();
    private final Options options;
    private final boolean hasHelp;
    private ParameterValidator<V> parameterValidator;
    private static final EnumConverter enumConverter = new EnumConverter();
    private static final Map<Class<?>, ParameterConverter<?>> defaultConverters = new HashMap();

    public Parser(String cmdLineSyntax, Class<V> type) {
        this(cmdLineSyntax, type, true);
    }

    public Parser(String cmdLineSyntax, Class<V> type, boolean addHelpOption) {
        this.cmdLineSyntax = cmdLineSyntax;
        this.buildParameters(type);
        this.options = new Options();
        for (Parameter parameter : this.parametersMap.values()) {
            this.options.addOption(parameter.option);
        }
        this.hasHelp = addHelpOption;
        if (this.hasHelp) {
            this.options.addOption(Option.builder((String)"h").longOpt("help").desc("Show help").build());
        }
    }

    public Options getOptions() {
        return this.options;
    }

    public void printUsage() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(this.cmdLineSyntax, this.options, true);
    }

    public V parse(V value, String ... args) throws InvalidParameterException {
        try {
            DefaultParser parser = new DefaultParser();
            CommandLine commandLine = parser.parse(this.options, args);
            if (this.hasHelp && commandLine.hasOption("h")) {
                this.printUsage();
                return null;
            }
            this.applyValues(commandLine, value);
            this.validateParameters(value);
            return value;
        }
        catch (ParseException e) {
            throw new InvalidParameterException(e.getMessage());
        }
    }

    public String dumpParameters(V value) {
        LinkedList table = new LinkedList();
        int nameMaxLength = 0;
        for (Map.Entry<Field, Parameter> entry : this.parametersMap.entrySet()) {
            Field field = entry.getKey();
            Parameter parameter = entry.getValue();
            LinkedList<String> row = new LinkedList<String>();
            String parameterName = "( -" + parameter.option.getOpt() + " ) " + field.getName();
            row.add(parameterName);
            nameMaxLength = nameMaxLength < parameterName.length() ? parameterName.length() : nameMaxLength;
            try {
                field.setAccessible(true);
                Object parameterValue = field.get(value);
                row.add(this.dumpValue(parameterValue));
            }
            catch (Exception e) {
                row.add(e.getMessage());
            }
            table.add(row);
        }
        StringBuilder buffer = new StringBuilder();
        for (List list : table) {
            buffer.append(String.format("  %-" + nameMaxLength + "s : %s\n", list.get(0), list.get(1)));
        }
        return buffer.toString();
    }

    private String dumpValue(Object value) {
        if (value == null) {
            return "";
        }
        Class<?> type = value.getClass();
        if (type.isArray()) {
            if (type.getComponentType().isPrimitive()) {
                int length = Array.getLength(value);
                Object[] boxed = (Object[])Array.newInstance(Object.class, length);
                for (int i = 0; i < length; ++i) {
                    boxed[i] = Array.get(value, i);
                }
                return Arrays.toString(boxed);
            }
            return Arrays.toString((Object[])value);
        }
        return String.valueOf(value);
    }

    private void buildParameters(Class<?> type) {
        for (Class<?> currentType = type; currentType != Object.class; currentType = currentType.getSuperclass()) {
            for (Field field : currentType.getDeclaredFields()) {
                CommandLineParameter[] annotations = (CommandLineParameter[])field.getAnnotationsByType(CommandLineParameter.class);
                if (annotations.length <= 0) continue;
                CommandLineParameter parameter = annotations[0];
                try {
                    Option option = this.buildOption(parameter, field);
                    ParameterConverter<?> converter = this.buildConverter(parameter, field);
                    ParameterValidator<?> validator = this.buildValidator(parameter);
                    this.parametersMap.put(field, new Parameter(option, converter, validator));
                }
                catch (Exception e) {
                    throw new IllegalStateException("Error initializing parameter field: " + field, e);
                }
            }
        }
        CommandLineValidator[] validators = (CommandLineValidator[])type.getAnnotationsByType(CommandLineValidator.class);
        if (validators.length > 0) {
            Class<ParameterValidator<?>> validatorType = validators[0].value();
            try {
                ParameterValidator<?> parameterValidator = validatorType.newInstance();
                this.parameterValidator = parameterValidator;
            }
            catch (Exception e) {
                throw new IllegalStateException("Error initializing validator class: " + validatorType, e);
            }
        }
    }

    private Option buildOption(CommandLineParameter parameter, Field field) {
        Class<?> parameterType = field.getType();
        boolean booleanParameter = parameterType == Boolean.class || parameterType == Boolean.TYPE;
        boolean hasLongName = !"<null>".equals(parameter.longName());
        boolean hasArgName = !"<null>".equals(parameter.argName());
        boolean hasNumberOfArgs = parameter.numberOfArgs() != -1;
        boolean hasDescription = !"<null>".equals(parameter.description());
        Option.Builder builder = Option.builder((String)parameter.value());
        builder.required(parameter.required());
        if (hasLongName) {
            builder.longOpt(parameter.longName());
        } else {
            builder.longOpt(field.getName());
        }
        if (hasArgName || !booleanParameter) {
            builder.hasArg(true);
            builder.argName(hasArgName ? parameter.argName() : "value");
            builder.type(parameterType);
            if (parameterType.isArray()) {
                if (hasNumberOfArgs) {
                    builder.numberOfArgs(parameter.numberOfArgs());
                } else {
                    builder.numberOfArgs(-2);
                }
            }
        } else if (!booleanParameter) {
            throw new IllegalStateException("Only boolean type is allowed for field: " + field);
        }
        if (hasDescription) {
            builder.desc(parameter.description());
        }
        return builder.build();
    }

    private ParameterConverter<?> buildConverter(CommandLineParameter parameter, Field field) throws Exception {
        Class<?> parameterType;
        Class<?> clazz = parameterType = field.getType().isArray() ? field.getType().getComponentType() : field.getType();
        if (parameterType == Boolean.TYPE || parameterType == Boolean.class || parameterType == String.class || Enum.class.isAssignableFrom(parameterType)) {
            return null;
        }
        Class<ParameterConverter<?>> type = parameter.converter();
        if (type == CommandLineParameter.DefaultConverter.class) {
            return Parser.getDefaultConverter(parameterType);
        }
        return type.newInstance();
    }

    private ParameterValidator<?> buildValidator(CommandLineParameter parameter) throws Exception {
        Class<ParameterValidator<?>> type = parameter.validator();
        if (type == CommandLineParameter.DefaultValidator.class) {
            return null;
        }
        return type.newInstance();
    }

    private void applyValues(CommandLine commandLine, V value) throws InvalidParameterException {
        for (Map.Entry<Field, Parameter> entry : this.parametersMap.entrySet()) {
            Object parameterValue;
            Field field = entry.getKey();
            Parameter parameter = entry.getValue();
            try {
                parameterValue = parameter.getValue(commandLine, field.getType());
                field.setAccessible(true);
                field.set(value, parameterValue);
            }
            catch (Exception e) {
                throw new InvalidParameterException(parameter.option, "Error setting parameter value: " + e.getMessage());
            }
            parameter.validate(parameterValue);
        }
    }

    private void validateParameters(V value) throws InvalidParameterException {
        if (this.parameterValidator != null) {
            String error;
            try {
                error = this.parameterValidator.validate(value);
            }
            catch (ClassCastException e) {
                throw new IllegalStateException("Error calling parameters validator. Check value type", e);
            }
            catch (Exception e) {
                throw new InvalidParameterException("Error validating parameters: " + e.getMessage());
            }
            if (error != null) {
                throw new InvalidParameterException("Error validating parameters: " + error);
            }
        }
    }

    private static ParameterConverter<?> getDefaultConverter(Class<?> type) throws Exception {
        ParameterConverter<?> converter = defaultConverters.get(type);
        if (converter == null) {
            throw new IllegalArgumentException("No default converter exists for parameter type: " + type);
        }
        return converter;
    }

    static {
        ByteConverter byteConverter = new ByteConverter();
        defaultConverters.put(Byte.TYPE, byteConverter);
        defaultConverters.put(Byte.class, byteConverter);
        CharacterConverter characterConverter = new CharacterConverter();
        defaultConverters.put(Character.TYPE, characterConverter);
        defaultConverters.put(Character.class, characterConverter);
        ShortConverter shortConverter = new ShortConverter();
        defaultConverters.put(Short.TYPE, shortConverter);
        defaultConverters.put(Short.class, shortConverter);
        IntegerConverter integerConverter = new IntegerConverter();
        defaultConverters.put(Integer.TYPE, integerConverter);
        defaultConverters.put(Integer.class, integerConverter);
        LongConverter longConverter = new LongConverter();
        defaultConverters.put(Long.TYPE, longConverter);
        defaultConverters.put(Long.class, longConverter);
    }

    private static class Parameter {
        private final Option option;
        private final ParameterConverter<?> converter;
        private final ParameterValidator<?> validator;

        public Parameter(Option option, ParameterConverter<?> converter, ParameterValidator<?> validator) {
            this.option = option;
            this.converter = converter;
            this.validator = validator;
        }

        public Object getValue(CommandLine commandLine, Class<?> type) throws Exception {
            if (type.isArray()) {
                return this.getArrayValue(commandLine, type.getComponentType());
            }
            return this.getObjectValue(commandLine, type);
        }

        public void validate(Object value) throws InvalidParameterException {
            String error;
            if (this.validator != null && (error = this.validator.validate(value)) != null) {
                throw new InvalidParameterException(this.option, error);
            }
        }

        private Object getObjectValue(CommandLine commandLine, Class<?> type) throws Exception {
            if (type == Boolean.TYPE || type == Boolean.class) {
                return commandLine.hasOption(this.option.getOpt());
            }
            String value = commandLine.getOptionValue(this.option.getOpt());
            return this.convertValue(value, type);
        }

        private Object getArrayValue(CommandLine commandLine, Class<?> type) throws Exception {
            String[] values = commandLine.getOptionValues(this.option.getOpt());
            Object result = Array.newInstance(type, values.length);
            for (int i = 0; i < values.length; ++i) {
                Object value = this.convertValue(values[i], type);
                Array.set(result, i, value);
            }
            return result;
        }

        private Object convertValue(String value, Class<?> type) throws Exception {
            if (type == String.class) {
                return value;
            }
            if (Enum.class.isAssignableFrom(type)) {
                return enumConverter.convert(value, type);
            }
            Object result = this.converter.convert(value);
            return result;
        }
    }
}

