/*
 * Decompiled with CFR 0.152.
 */
package de.oberdorf_itc.pushover;

import java.util.HashMap;
import java.util.Set;
import net.pushover.client.MessagePriority;
import net.pushover.client.PushOverSound;
import net.pushover.client.PushoverClient;
import net.pushover.client.PushoverException;
import net.pushover.client.PushoverMessage;
import net.pushover.client.PushoverRestClient;
import net.pushover.client.Status;

public class Client
implements Runnable {
    private PushoverClient POC = new PushoverRestClient();
    protected String apiToken = null;
    protected String userID = null;
    private MessagePriority messagePriority = MessagePriority.NORMAL;
    private String title = null;
    private String url = null;
    private String urlTitle = null;
    private String device = null;
    private String body = null;
    private String sound = null;
    private String requestID = null;
    private int status;
    private String status_text = null;

    public void setApiToken(String apiToken) {
        this.apiToken = apiToken;
    }

    public void setUserId(String userID) {
        this.userID = userID;
    }

    public void setMessagePriority(String priority) {
        switch (priority = priority.toUpperCase().trim()) {
            case "QUIET": {
                this.messagePriority = MessagePriority.QUIET;
                break;
            }
            case "HIGH": {
                this.messagePriority = MessagePriority.HIGH;
                break;
            }
            default: {
                this.messagePriority = MessagePriority.NORMAL;
            }
        }
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setURL(String url, String urlTitle) {
        this.url = url;
        this.urlTitle = urlTitle;
    }

    public void setDevice(String deviceName) {
        this.device = deviceName;
    }

    public void setBody(String body) {
        this.body = body;
    }

    public void setSound(String sound) {
        this.sound = sound;
    }

    public int pushMessage() {
        if (this.apiToken == null) {
            this.status = -1;
            this.status_text = "apiToken missing";
            return this.status;
        }
        if (this.userID == null) {
            this.status = -1;
            this.status_text = "userID missing";
            return this.status;
        }
        PushoverMessage.Builder data = PushoverMessage.builderWithApiToken((String)this.apiToken).setUserId(this.userID).setPriority(this.messagePriority);
        if (this.title != null) {
            data.setTitle(this.title);
        }
        if (this.body != null) {
            data.setMessage(this.body);
        }
        if (this.url != null) {
            data.setUrl(this.url);
        }
        if (this.urlTitle != null) {
            data.setTitleForURL(this.urlTitle);
        }
        if (this.sound != null) {
            data.setSound(this.sound);
        }
        if (this.device != null) {
            data.setDevice(this.device);
        }
        Status result = null;
        try {
            result = this.POC.pushMessage(data.build());
        }
        catch (PushoverException e) {
            this.status = -1;
            this.status_text = e.toString();
            return this.status;
        }
        this.status = result.getStatus();
        this.requestID = result.getRequestId();
        return this.status;
    }

    @Override
    public void run() {
        this.pushMessage();
    }

    public int getLastStatus() {
        return this.status;
    }

    public String getLastStatusText() {
        return this.status_text;
    }

    public String getLastRequestID() {
        return this.requestID;
    }

    public HashMap<String, String> getSoundList() {
        HashMap<String, String> soundList = new HashMap<String, String>();
        Set sounds = null;
        try {
            sounds = this.POC.getSounds();
        }
        catch (PushoverException e) {
            this.status = -1;
            this.status_text = e.toString();
            return soundList;
        }
        this.status = 0;
        this.status_text = "Successfully fetching sounds";
        for (PushOverSound sound : sounds) {
            soundList.put(sound.getId(), sound.getName());
        }
        return soundList;
    }
}

