/*
 * Decompiled with CFR 0.152.
 */
package de.oberdorf_itc.mqtt;

import java.io.IOException;
import org.eclipse.paho.client.mqttv3.MqttClient;
import org.eclipse.paho.client.mqttv3.MqttClientPersistence;
import org.eclipse.paho.client.mqttv3.MqttConnectOptions;
import org.eclipse.paho.client.mqttv3.MqttException;
import org.eclipse.paho.client.mqttv3.MqttMessage;
import org.eclipse.paho.client.mqttv3.persist.MemoryPersistence;

public class MQTTPublish
implements Runnable {
    private MqttClient mqttClient = null;
    private String mqttUser = null;
    protected char[] mqttPass = null;
    private int qos = 0;
    private boolean retained = false;
    private String topic = null;
    private String body = null;

    public MQTTPublish(String server) throws MqttException {
        MemoryPersistence persistence = new MemoryPersistence();
        String clientId = MqttClient.generateClientId();
        this.mqttClient = new MqttClient(server, clientId, (MqttClientPersistence)persistence);
    }

    public MQTTPublish(String server, String mqttUser, String mqttPass) throws MqttException {
        MemoryPersistence persistence = new MemoryPersistence();
        String clientId = MqttClient.generateClientId();
        this.mqttClient = new MqttClient(server, clientId, (MqttClientPersistence)persistence);
        this.mqttUser = mqttUser;
        this.mqttPass = mqttPass.toCharArray();
    }

    public MQTTPublish(String server, String clientId, String mqttUser, String mqttPass) throws MqttException {
        MemoryPersistence persistence = new MemoryPersistence();
        this.mqttClient = new MqttClient(server, clientId, (MqttClientPersistence)persistence);
        this.mqttUser = mqttUser;
        this.mqttPass = mqttPass.toCharArray();
    }

    public void setPublishMessage(String topic, String body) {
        this.topic = topic;
        this.body = body;
        this.qos = 0;
        this.retained = false;
    }

    public void setPublishMessage(String topic, String body, int qos) {
        this.topic = topic;
        this.body = body;
        this.qos = qos;
        this.retained = false;
    }

    public void setPublishMessage(String topic, String body, boolean retained) {
        this.topic = topic;
        this.body = body;
        this.qos = 0;
        this.retained = retained;
    }

    public void setPublishMessage(String topic, String body, int qos, boolean retained) {
        this.topic = topic;
        this.body = body;
        this.qos = qos;
        this.retained = retained;
    }

    @Override
    public void run() {
        try {
            if (this.mqttClient == null) {
                throw new IOException();
            }
            if (this.topic == null) {
                throw new IOException();
            }
            if (this.body == null) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            MqttConnectOptions connOpts = new MqttConnectOptions();
            if (this.mqttUser != null && this.mqttPass != null) {
                connOpts.setUserName(this.mqttUser);
                connOpts.setPassword(this.mqttPass);
            }
            connOpts.setCleanSession(true);
            this.mqttClient.connect(connOpts);
            MqttMessage message = new MqttMessage(this.body.getBytes());
            message.setQos(this.qos);
            message.setRetained(this.retained);
            this.mqttClient.publish(this.topic, message);
            this.mqttClient.disconnect();
        }
        catch (MqttException e) {
            e.printStackTrace();
        }
    }
}

