/*
 * Decompiled with CFR 0.152.
 */
package de.nycode.retrofit2.converter.kotlinx.serialization;

import java.lang.reflect.Type;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.serialization.BinaryFormat;
import kotlinx.serialization.DeserializationStrategy;
import kotlinx.serialization.KSerializer;
import kotlinx.serialization.SerialFormat;
import kotlinx.serialization.SerializationStrategy;
import kotlinx.serialization.SerializersKt;
import kotlinx.serialization.StringFormat;
import kotlinx.serialization.modules.SerializersModule;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u00002\u00020\u0001:\u0002\u001a\u001bB\u0007\b\u0004\u00a2\u0006\u0002\u0010\u0002J)\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u00020\fH&\u00a2\u0006\u0002\u0010\rJ\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u0011J1\u0010\u0012\u001a\u00020\u0013\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0014\u001a\u00020\u00152\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u0002H\b0\u00172\u0006\u0010\u0018\u001a\u0002H\bH&\u00a2\u0006\u0002\u0010\u0019R\u0012\u0010\u0003\u001a\u00020\u0004X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0006\u0082\u0001\u0002\u001c\u001d\u00a8\u0006\u001e"}, d2={"Lde/nycode/retrofit2/converter/kotlinx/serialization/Serializer;", "", "()V", "format", "Lkotlinx/serialization/SerialFormat;", "getFormat", "()Lkotlinx/serialization/SerialFormat;", "fromResponseBody", "T", "loader", "Lkotlinx/serialization/DeserializationStrategy;", "body", "Lokhttp3/ResponseBody;", "(Lkotlinx/serialization/DeserializationStrategy;Lokhttp3/ResponseBody;)Ljava/lang/Object;", "serializer", "Lkotlinx/serialization/KSerializer;", "type", "Ljava/lang/reflect/Type;", "toRequestBody", "Lokhttp3/RequestBody;", "contentType", "Lokhttp3/MediaType;", "saver", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lokhttp3/MediaType;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lokhttp3/RequestBody;", "FromBytes", "FromString", "Lde/nycode/retrofit2/converter/kotlinx/serialization/Serializer$FromString;", "Lde/nycode/retrofit2/converter/kotlinx/serialization/Serializer$FromBytes;", "retrofit2-kotlinx-serialization-converter"})
public abstract class Serializer {
    private Serializer() {
    }

    public abstract <T> T fromResponseBody(@NotNull DeserializationStrategy<T> var1, @NotNull ResponseBody var2);

    @NotNull
    public abstract <T> RequestBody toRequestBody(@NotNull MediaType var1, @NotNull SerializationStrategy<? super T> var2, T var3);

    @NotNull
    protected abstract SerialFormat getFormat();

    @NotNull
    public final KSerializer<Object> serializer(@NotNull Type type) {
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        return SerializersKt.serializer((SerializersModule)this.getFormat().getSerializersModule(), (Type)type);
    }

    public /* synthetic */ Serializer(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ1\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\b0\u00132\u0006\u0010\u0014\u001a\u0002H\bH\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lde/nycode/retrofit2/converter/kotlinx/serialization/Serializer$FromString;", "Lde/nycode/retrofit2/converter/kotlinx/serialization/Serializer;", "format", "Lkotlinx/serialization/StringFormat;", "(Lkotlinx/serialization/StringFormat;)V", "getFormat", "()Lkotlinx/serialization/StringFormat;", "fromResponseBody", "T", "loader", "Lkotlinx/serialization/DeserializationStrategy;", "body", "Lokhttp3/ResponseBody;", "(Lkotlinx/serialization/DeserializationStrategy;Lokhttp3/ResponseBody;)Ljava/lang/Object;", "toRequestBody", "Lokhttp3/RequestBody;", "contentType", "Lokhttp3/MediaType;", "saver", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lokhttp3/MediaType;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lokhttp3/RequestBody;", "retrofit2-kotlinx-serialization-converter"})
    public static final class FromString
    extends Serializer {
        @NotNull
        private final StringFormat format;

        public FromString(@NotNull StringFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            super(null);
            this.format = format;
        }

        @NotNull
        protected StringFormat getFormat() {
            return this.format;
        }

        @Override
        public <T> T fromResponseBody(@NotNull DeserializationStrategy<T> loader, @NotNull ResponseBody body) {
            Intrinsics.checkNotNullParameter(loader, (String)"loader");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            String string = body.string();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"body.string()");
            String string2 = string;
            return (T)this.getFormat().decodeFromString(loader, string2);
        }

        @Override
        @NotNull
        public <T> RequestBody toRequestBody(@NotNull MediaType contentType, @NotNull SerializationStrategy<? super T> saver, T value) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(saver, (String)"saver");
            String string = this.getFormat().encodeToString(saver, value);
            RequestBody requestBody = RequestBody.create((MediaType)contentType, (String)string);
            Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"create(contentType, string)");
            return requestBody;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J)\u0010\u0007\u001a\u0002H\b\"\u0004\b\u0000\u0010\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u0002H\b0\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a2\u0006\u0002\u0010\rJ1\u0010\u000e\u001a\u00020\u000f\"\u0004\b\u0000\u0010\b2\u0006\u0010\u0010\u001a\u00020\u00112\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u0002H\b0\u00132\u0006\u0010\u0014\u001a\u0002H\bH\u0016\u00a2\u0006\u0002\u0010\u0015R\u0014\u0010\u0002\u001a\u00020\u0003X\u0094\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0016"}, d2={"Lde/nycode/retrofit2/converter/kotlinx/serialization/Serializer$FromBytes;", "Lde/nycode/retrofit2/converter/kotlinx/serialization/Serializer;", "format", "Lkotlinx/serialization/BinaryFormat;", "(Lkotlinx/serialization/BinaryFormat;)V", "getFormat", "()Lkotlinx/serialization/BinaryFormat;", "fromResponseBody", "T", "loader", "Lkotlinx/serialization/DeserializationStrategy;", "body", "Lokhttp3/ResponseBody;", "(Lkotlinx/serialization/DeserializationStrategy;Lokhttp3/ResponseBody;)Ljava/lang/Object;", "toRequestBody", "Lokhttp3/RequestBody;", "contentType", "Lokhttp3/MediaType;", "saver", "Lkotlinx/serialization/SerializationStrategy;", "value", "(Lokhttp3/MediaType;Lkotlinx/serialization/SerializationStrategy;Ljava/lang/Object;)Lokhttp3/RequestBody;", "retrofit2-kotlinx-serialization-converter"})
    public static final class FromBytes
    extends Serializer {
        @NotNull
        private final BinaryFormat format;

        public FromBytes(@NotNull BinaryFormat format) {
            Intrinsics.checkNotNullParameter((Object)format, (String)"format");
            super(null);
            this.format = format;
        }

        @NotNull
        protected BinaryFormat getFormat() {
            return this.format;
        }

        @Override
        public <T> T fromResponseBody(@NotNull DeserializationStrategy<T> loader, @NotNull ResponseBody body) {
            Intrinsics.checkNotNullParameter(loader, (String)"loader");
            Intrinsics.checkNotNullParameter((Object)body, (String)"body");
            byte[] byArray = body.bytes();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"body.bytes()");
            byte[] bytes = byArray;
            return (T)this.getFormat().decodeFromByteArray(loader, bytes);
        }

        @Override
        @NotNull
        public <T> RequestBody toRequestBody(@NotNull MediaType contentType, @NotNull SerializationStrategy<? super T> saver, T value) {
            Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
            Intrinsics.checkNotNullParameter(saver, (String)"saver");
            byte[] bytes = this.getFormat().encodeToByteArray(saver, value);
            RequestBody requestBody = RequestBody.create((MediaType)contentType, (byte[])bytes);
            Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"create(contentType, bytes)");
            return requestBody;
        }
    }
}

