/*
 * Decompiled with CFR 0.152.
 */
package de.nycode.bcrypt;

import at.favre.lib.crypto.bcrypt.BCrypt;
import at.favre.lib.crypto.bcrypt.LongPasswordStrategies;
import at.favre.lib.crypto.bcrypt.LongPasswordStrategy;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\u001a\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0016\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u0006\"\u0016\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u0016\u0010\u0003\u001a\n \u0002*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0000"}, d2={"bcrypt", "Lat/favre/lib/crypto/bcrypt/BCrypt$Hasher;", "kotlin.jvm.PlatformType", "verifier", "Lat/favre/lib/crypto/bcrypt/BCrypt$Verifyer;", "hash", "", "input", "", "cost", "", "verify", "", "expected"})
public final class BCryptKt {
    private static final BCrypt.Hasher bcrypt = BCrypt.withDefaults();
    private static final BCrypt.Verifyer verifier = BCrypt.verifyer(null, (LongPasswordStrategy)LongPasswordStrategies.truncate((BCrypt.Version)BCrypt.Version.VERSION_2A));

    @NotNull
    public static final byte[] hash(@NotNull String input, int cost) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        String string = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = bcrypt.hash(cost, byArray);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"bcrypt.hash(cost, input.toByteArray())");
        return byArray2;
    }

    public static /* synthetic */ byte[] hash$default(String string, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 6;
        }
        return BCryptKt.hash(string, n);
    }

    public static final boolean verify(@NotNull String input, @NotNull byte[] expected) {
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        Intrinsics.checkNotNullParameter((Object)expected, (String)"expected");
        String string = input;
        Charset charset = Charsets.UTF_8;
        boolean bl = false;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        return BCryptKt.verifier.verify((byte[])byArray, (byte[])expected).verified;
    }
}

