(function (root, factory) {
  if (typeof define === 'function' && define.amd)
    define(['exports', 'kotlin', 'bcrypt', 'kotlinx-coroutines-core'], factory);
  else if (typeof exports === 'object')
    factory(module.exports, require('kotlin'), require('bcrypt'), require('kotlinx-coroutines-core'));
  else {
    if (typeof kotlin === 'undefined') {
      throw new Error("Error loading module 'bcrypt-js-legacy'. Its dependency 'kotlin' was not found. Please, check whether 'kotlin' is loaded prior to 'bcrypt-js-legacy'.");
    }if (typeof JsBcrypt === 'undefined') {
      throw new Error("Error loading module 'bcrypt-js-legacy'. Its dependency 'bcrypt' was not found. Please, check whether 'bcrypt' is loaded prior to 'bcrypt-js-legacy'.");
    }if (typeof this['kotlinx-coroutines-core'] === 'undefined') {
      throw new Error("Error loading module 'bcrypt-js-legacy'. Its dependency 'kotlinx-coroutines-core' was not found. Please, check whether 'kotlinx-coroutines-core' is loaded prior to 'bcrypt-js-legacy'.");
    }root['bcrypt-js-legacy'] = factory(typeof this['bcrypt-js-legacy'] === 'undefined' ? {} : this['bcrypt-js-legacy'], kotlin, JsBcrypt, this['kotlinx-coroutines-core']);
  }
}(this, function (_, Kotlin, $module$bcrypt, $module$kotlinx_coroutines_core) {
  'use strict';
  var encodeToByteArray = Kotlin.kotlin.text.encodeToByteArray_pdl1vz$;
  var COROUTINE_SUSPENDED = Kotlin.kotlin.coroutines.intrinsics.COROUTINE_SUSPENDED;
  var CoroutineImpl = Kotlin.kotlin.coroutines.CoroutineImpl;
  var await_0 = $module$kotlinx_coroutines_core.kotlinx.coroutines.await_t11jrl$;
  var decodeToString = Kotlin.kotlin.text.decodeToString_964n91$;
  function hash(input, cost) {
    if (cost === void 0)
      cost = 6;
    return encodeToByteArray($module$bcrypt.hashSync(input, cost));
  }
  function Coroutine$hashAsync(input_0, cost_0, continuation_0) {
    CoroutineImpl.call(this, continuation_0);
    this.exceptionState_0 = 1;
    this.local$input = input_0;
    this.local$cost = cost_0;
  }
  Coroutine$hashAsync.$metadata$ = {
    kind: Kotlin.Kind.CLASS,
    simpleName: null,
    interfaces: [CoroutineImpl]
  };
  Coroutine$hashAsync.prototype = Object.create(CoroutineImpl.prototype);
  Coroutine$hashAsync.prototype.constructor = Coroutine$hashAsync;
  Coroutine$hashAsync.prototype.doResume = function () {
    do
      try {
        switch (this.state_0) {
          case 0:
            this.state_0 = 2;
            this.result_0 = await_0($module$bcrypt.hash(this.local$input, this.local$cost), this);
            if (this.result_0 === COROUTINE_SUSPENDED)
              return COROUTINE_SUSPENDED;
            continue;
          case 1:
            throw this.exception_0;
          case 2:
            return encodeToByteArray(this.result_0);
          default:this.state_0 = 1;
            throw new Error('State Machine Unreachable execution');
        }
      } catch (e) {
        if (this.state_0 === 1) {
          this.exceptionState_0 = this.state_0;
          throw e;
        } else {
          this.state_0 = this.exceptionState_0;
          this.exception_0 = e;
        }
      }
     while (true);
  };
  function hashAsync(input_0, cost_0, continuation_0, suspended) {
    var instance = new Coroutine$hashAsync(input_0, cost_0, continuation_0);
    if (suspended)
      return instance;
    else
      return instance.doResume(null);
  }
  function verify(input, expected) {
    return $module$bcrypt.compareSync(input, decodeToString(expected));
  }
  function verifyAsync(input, expected, continuation) {
    return await_0($module$bcrypt.compare(input, decodeToString(expected)), continuation);
  }
  var package$de = _.de || (_.de = {});
  var package$nycode = package$de.nycode || (package$de.nycode = {});
  var package$bcrypt = package$nycode.bcrypt || (package$nycode.bcrypt = {});
  package$bcrypt.hash_bm4lxs$ = hash;
  package$bcrypt.hashAsync_bm4lxs$ = hashAsync;
  package$bcrypt.verify_yzgtim$ = verify;
  package$bcrypt.verifyAsync_yzgtim$ = verifyAsync;
  Kotlin.defineModule('bcrypt-js-legacy', _);
  return _;
}));

//# sourceMappingURL=bcrypt-js-legacy.js.map
