/*
 * Decompiled with CFR 0.152.
 */
package de.nikem.jebu.impl.websocket.server;

import de.nikem.jebu.api.Subscriber;
import de.nikem.jebu.impl.JebuRemoveSubscriberException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.nio.ByteBuffer;
import javax.websocket.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JebuWebSocketSubscriber
implements Subscriber {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Session session;

    public JebuWebSocketSubscriber(Session session) {
        this.session = session;
    }

    public void publish(String eventName, Object data) {
        this.sendData(data);
    }

    public Session getSession() {
        return this.session;
    }

    public String getId() {
        return this.getSession().getId();
    }

    private void sendData(Object data) {
        try (ByteArrayOutputStream bos = new ByteArrayOutputStream();
             ObjectOutputStream out = new ObjectOutputStream(bos);){
            out.writeObject(data);
            out.flush();
            ByteBuffer buf = ByteBuffer.wrap(bos.toByteArray());
            this.getSession().getAsyncRemote().sendBinary(buf);
        }
        catch (IOException e) {
            this.log.debug("error during communication of session {}", (Object)this.session.getId());
            throw new JebuRemoveSubscriberException((Throwable)e);
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getId() == null ? 0 : this.getId().hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        JebuWebSocketSubscriber other = (JebuWebSocketSubscriber)obj;
        return !(this.getId() == null ? other.getId() != null : !this.getId().equals(other.getId()));
    }

    public String toString() {
        return "JebuWebSocketSubscriber [" + this.session.getId() + "]";
    }
}

