/*
 * Decompiled with CFR 0.152.
 */
package de.nikem.jebu.impl.websocket.server;

import de.nikem.jebu.api.Subscriber;
import de.nikem.jebu.impl.EventBusImpl;
import de.nikem.jebu.impl.websocket.JebuWebsocketEvent;
import de.nikem.jebu.impl.websocket.server.JebuServerContext;
import de.nikem.jebu.impl.websocket.server.JebuWebSocketSubscriber;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Map;
import javax.websocket.CloseReason;
import javax.websocket.EndpointConfig;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/{path}/")
public class JebuServerEndpoint {
    public static final String PATH_EVENTBUS = "eventbus";
    public static final String PATH_MANAGER = "manager";
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private EventBusImpl jebu = null;
    private Collection<Session> managerSessions = null;

    @OnOpen
    public void onOpen(Session session, EndpointConfig config, @PathParam(value="path") String path) {
        this.log.debug("connect on {} {{}} from {}", new Object[]{this, path, session.getId()});
        JebuServerContext serverContext = (JebuServerContext)config.getUserProperties().get("jebuServerContext");
        if (serverContext == null) {
            config.getUserProperties().put("jebuServerContext", serverContext);
        }
        this.jebu = serverContext.getJebu();
        this.managerSessions = serverContext.getManagerSessions();
        if (PATH_MANAGER.equals(path)) {
            this.getManagerSessions().add(session);
        }
        this.publishManagers();
    }

    @OnMessage
    public void onMessage(byte[] message, Session session, @PathParam(value="path") String path) {
        this.log.trace("message from {}", (Object)session.getId());
        if (PATH_EVENTBUS.equals(path)) {
            this.onEventbusMessage(message, session);
        } else if (PATH_MANAGER.equals(path)) {
            this.log.debug("cannot handle manager message");
        }
    }

    /*
     * Unable to fully structure code
     */
    private void onEventbusMessage(byte[] message, Session session) {
        event = null;
        try {
            is = new ByteArrayInputStream(message);
            var5_6 = null;
            try {
                ois = new ObjectInputStream(is);
                var7_10 = null;
                try {
                    event = (JebuWebsocketEvent)ois.readObject();
                    this.log.trace("event from {}: {}", (Object)session.getId(), (Object)event);
                    jebu = this.getJebu();
                    switch (1.$SwitchMap$de$nikem$jebu$impl$websocket$JebuWebsocketEvent$Action[event.getAction().ordinal()]) {
                        case 1: {
                            jebu.subscribe(event.getEventName(), (Subscriber)new JebuWebSocketSubscriber(session));
                            ** break;
lbl16:
                            // 1 sources

                            break;
                        }
                        case 2: {
                            if (event.getEventName() != null) {
                                jebu.unsubscribe(event.getEventName(), (Subscriber)new JebuWebSocketSubscriber(session));
                                ** break;
lbl21:
                                // 1 sources

                            } else {
                                jebu.unsubscribe((Subscriber)new JebuWebSocketSubscriber(session));
                                ** break;
                            }
lbl24:
                            // 1 sources

                            break;
                        }
                        case 3: {
                            jebu.publish(event.getEventName(), (Object)event);
                            ** break;
lbl28:
                            // 1 sources

                            break;
                        }
                        default: {
                            this.log.error("unknown action {}", (Object)event.getAction());
                            break;
                        }
                    }
                }
                catch (Throwable var8_13) {
                    var7_10 = var8_13;
                    throw var8_13;
                }
                finally {
                    if (ois != null) {
                        if (var7_10 != null) {
                            try {
                                ois.close();
                            }
                            catch (Throwable var8_12) {
                                var7_10.addSuppressed(var8_12);
                            }
                        } else {
                            ois.close();
                        }
                    }
                }
            }
            catch (Throwable var6_9) {
                var5_6 = var6_9;
                throw var6_9;
            }
            finally {
                if (is != null) {
                    if (var5_6 != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable var6_8) {
                            var5_6.addSuppressed(var6_8);
                        }
                    } else {
                        is.close();
                    }
                }
            }
        }
        catch (IOException | ClassNotFoundException e) {
            this.log.error("message processing error", (Throwable)e);
        }
        this.publishManagers(event, session);
    }

    @OnMessage
    public void onMessage(String message, Session session, @PathParam(value="path") String path) {
        this.log.debug("String message: {}", (Object)message);
        if (PATH_MANAGER.equals(path)) {
            this.log.debug("cannot handle manager message");
        }
    }

    @OnClose
    public void onClose(Session session, CloseReason reason, @PathParam(value="path") String path) {
        this.log.debug("Socket Closed: {}", (Object)reason);
        if (PATH_MANAGER.equals(path)) {
            this.getManagerSessions().remove(session);
            this.publishManagers();
        } else if (PATH_EVENTBUS.equals(path)) {
            this.getJebu().unsubscribe((Subscriber)new JebuWebSocketSubscriber(session));
        }
    }

    @OnError
    public void onError(Throwable cause, @PathParam(value="path") String path) {
        this.log.error("websocket error {{}}", (Object)path);
        this.log.error("websocket error", cause);
    }

    private void publishManagers() {
        this.publishManagers(null, null);
    }

    /*
     * WARNING - void declaration
     */
    private void publishManagers(JebuWebsocketEvent event, Session session) {
        StringWriter w = new StringWriter();
        try {
            ((Writer)w).append("{");
            JebuServerEndpoint.quote("subscriberMap", w).append(": {");
            boolean firstEvt = true;
            for (Map.Entry entry : this.getJebu().getSubscriberMap().entrySet()) {
                if (!firstEvt) {
                    ((Writer)w).append(',');
                }
                firstEvt = false;
                JebuServerEndpoint.quote((String)entry.getKey(), w).append(": [");
                boolean firstSub = true;
                for (Subscriber s : (Collection)entry.getValue()) {
                    if (!firstSub) {
                        ((Writer)w).append(',');
                    }
                    firstSub = false;
                    JebuServerEndpoint.quote(s.getId(), w);
                }
                ((Writer)w).append(']');
            }
            ((Writer)w).append("},");
            JebuServerEndpoint.quote("managerSessions", w).append(": [");
            boolean firstSub = true;
            for (Session managerSession : this.getManagerSessions()) {
                if (!firstSub) {
                    ((Writer)w).append(',');
                }
                firstSub = false;
                JebuServerEndpoint.quote(managerSession.getId(), w);
            }
            ((Writer)w).append(']');
            if (event != null) {
                void var6_13;
                String string;
                Object var6_10 = null;
                if (event.getData() != null && (string = event.getData().toString()).length() > 100) {
                    String string2 = string.substring(0, 97) + "...";
                }
                ((Writer)w).append(',');
                JebuServerEndpoint.quote("event", w).append(": {");
                JebuServerEndpoint.quote("sender", w).append(':');
                JebuServerEndpoint.quote(session.getId(), w).append(',');
                JebuServerEndpoint.quote("action", w).append(':');
                JebuServerEndpoint.quote(event.getAction().toString(), w).append(',');
                JebuServerEndpoint.quote("eventName", w).append(':');
                JebuServerEndpoint.quote(event.getEventName(), w).append(',');
                JebuServerEndpoint.quote("data", w).append(':');
                JebuServerEndpoint.quote((String)var6_13, w).append(',');
                JebuServerEndpoint.quote("timestamp", w).append(':');
                JebuServerEndpoint.quote(new Timestamp(System.currentTimeMillis()).toString(), w).append('}');
            }
            ((Writer)w).append('}');
            for (Session managerSession : this.getManagerSessions()) {
                managerSession.getAsyncRemote().sendText(((Object)w).toString());
            }
        }
        catch (IOException e) {
            this.log.debug("JSON wirte error", (Throwable)e);
        }
    }

    protected Collection<Session> getManagerSessions() {
        return this.managerSessions;
    }

    protected EventBusImpl getJebu() {
        return this.jebu;
    }

    protected void finalize() throws Throwable {
        for (Session session : this.getManagerSessions()) {
            session.close(new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.GOING_AWAY, "good night!"));
        }
    }

    public static Writer quote(String string, Writer w) throws IOException {
        if (string == null || string.length() == 0) {
            w.write("\"\"");
            return w;
        }
        char c = '\u0000';
        int len = string.length();
        w.write(34);
        block10: for (int i = 0; i < len; ++i) {
            char b = c;
            c = string.charAt(i);
            switch (c) {
                case '\\': {
                    w.write(92);
                    w.write(c);
                    continue block10;
                }
                case '\"': {
                    w.write(92);
                    w.write(c);
                    continue block10;
                }
                case '/': {
                    if (b == '<') {
                        w.write(92);
                    }
                    w.write(c);
                    continue block10;
                }
                case '\b': {
                    w.write("\\b");
                    continue block10;
                }
                case '\t': {
                    w.write("\\t");
                    continue block10;
                }
                case '\n': {
                    w.write("\\n");
                    continue block10;
                }
                case '\f': {
                    w.write("\\f");
                    continue block10;
                }
                case '\r': {
                    w.write("\\r");
                    continue block10;
                }
                default: {
                    if (c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100') {
                        w.write("\\u");
                        String hhhh = Integer.toHexString(c);
                        w.write("0000", 0, 4 - hhhh.length());
                        w.write(hhhh);
                        continue block10;
                    }
                    w.write(c);
                }
            }
        }
        w.write(34);
        return w;
    }

    static class 1 {
        static final /* synthetic */ int[] $SwitchMap$de$nikem$jebu$impl$websocket$JebuWebsocketEvent$Action;

        static {
            $SwitchMap$de$nikem$jebu$impl$websocket$JebuWebsocketEvent$Action = new int[JebuWebsocketEvent.Action.values().length];
            try {
                1.$SwitchMap$de$nikem$jebu$impl$websocket$JebuWebsocketEvent$Action[JebuWebsocketEvent.Action.subscribe.ordinal()] = 1;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$de$nikem$jebu$impl$websocket$JebuWebsocketEvent$Action[JebuWebsocketEvent.Action.unsubscribe.ordinal()] = 2;
            }
            catch (NoSuchFieldError ex) {
                // empty catch block
            }
            try {
                1.$SwitchMap$de$nikem$jebu$impl$websocket$JebuWebsocketEvent$Action[JebuWebsocketEvent.Action.publish.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
        }
    }
}

