/*
 * Decompiled with CFR 0.152.
 */
package de.nikem.jebu.impl.websocket.server.jetty;

import de.nikem.jebu.api.JebuException;
import de.nikem.jebu.impl.websocket.server.JebuServerContext;
import de.nikem.jebu.impl.websocket.server.JebuServerEndpoint;
import java.net.URL;
import javax.websocket.server.ServerEndpointConfig;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ContextHandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.webapp.WebAppContext;
import org.eclipse.jetty.websocket.jsr356.server.ServerContainer;
import org.eclipse.jetty.websocket.jsr356.server.deploy.WebSocketServerContainerInitializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JebuWebsocketServer {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private JebuServerContext actualContext = null;
    private int port;
    private Server server = null;

    public void startServer() {
        if (this.server == null) {
            try {
                this.server = new Server(this.port);
                ContextHandlerCollection collection = new ContextHandlerCollection();
                this.server.setHandler((Handler)collection);
                ServletContextHandler context = new ServletContextHandler();
                context.setContextPath("/jebu");
                collection.addHandler((Handler)context);
                ServerContainer wscontainer = WebSocketServerContainerInitializer.configureContext((ServletContextHandler)context);
                ServerEndpointConfig.Builder configBuilder = ServerEndpointConfig.Builder.create(JebuServerEndpoint.class, (String)"/{path}/");
                ServerEndpointConfig config = configBuilder.build();
                if (!config.getUserProperties().containsKey("jebuServerContext")) {
                    this.actualContext = new JebuServerContext();
                    config.getUserProperties().put("jebuServerContext", this.actualContext);
                }
                wscontainer.addEndpoint(config);
                URL warUrl = JebuWebsocketServer.class.getClassLoader().getResource("de/nikem/jebu/site");
                String warUrlString = warUrl.toExternalForm();
                this.log.debug("doc root: " + warUrlString);
                collection.addHandler((Handler)new WebAppContext(warUrlString, "/"));
                this.server.start();
                ServerThread t = new ServerThread(this.server);
                t.setDaemon(true);
                t.start();
                this.log.info("Server started on port {}. Got to http://localhost:{}/ to start Jebu manager", (Object)this.port, (Object)this.port);
            }
            catch (Exception e) {
                throw new JebuException((Throwable)e);
            }
        } else {
            this.log.info("Server already started: {}", (Object)this.server.dump());
        }
    }

    public void stopServer() {
        if (this.server != null) {
            try {
                this.server.stop();
                this.server = null;
                this.actualContext = null;
            }
            catch (Exception e) {
                this.log.error("can't stop server", (Throwable)e);
            }
        } else {
            this.log.info("server already stopped");
        }
    }

    public void setPort(int port) {
        this.port = port;
    }

    void publish(String eventName, Object data) {
        if (this.actualContext != null) {
            this.actualContext.getJebu().publish(eventName, data);
        } else {
            this.log.debug("Lost event, because no server context: {}", (Object)eventName);
        }
    }

    public static class ServerThread
    extends Thread {
        private final Logger log = LoggerFactory.getLogger(this.getClass());
        private final Server server;

        public ServerThread(Server server) {
            super("Server-Thread");
            this.server = server;
        }

        @Override
        public void run() {
            try {
                this.server.join();
                this.log.info("server stopped");
            }
            catch (InterruptedException e) {
                this.log.error("server interrupted", (Throwable)e);
            }
        }
    }
}

