/*
 * Decompiled with CFR 0.152.
 */
package de.nikem.jebu.impl.websocket.server.jetty.demo;

import de.nikem.jebu.api.Subscriber;
import de.nikem.jebu.impl.websocket.client.JebuWebSocketClient;
import de.nikem.jebu.impl.websocket.server.jetty.JebuWebsocketServer;
import java.net.URI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JettyDemo {
    public static void main(String[] args) throws Exception {
        URI uri = new URI("ws://localhost:8080/jebu/eventbus/");
        JebuWebSocketClient client = new JebuWebSocketClient(uri);
        JebuWebsocketServer server = new JebuWebsocketServer();
        server.setPort(8080);
        server.startServer();
        Thread.sleep(3000L);
        class DemoSubscriber
        implements Subscriber {
            private final Logger log = LoggerFactory.getLogger(this.getClass());

            DemoSubscriber() {
            }

            public void publish(String eventName, Object data) {
                this.log.debug("{} received event {}: {}", new Object[]{this.getId(), eventName, data});
            }

            public String getId() {
                return this.toString();
            }
        }
        DemoSubscriber s = new DemoSubscriber();
        client.subscribe("test.event.1", (Subscriber)s);
        Thread.sleep(3000L);
        client.subscribe("test.event.2", (Subscriber)s);
        Thread.sleep(3000L);
        client.subscribe("test.event.1", (Subscriber)new DemoSubscriber());
        Thread.sleep(3000L);
        client.publish("test.event.1", (Object)"Hallo!");
        while (true) {
            Thread.sleep(3000L);
            client.unsubscribe("test.event.2", (Subscriber)s);
            Thread.sleep(1500L);
            server.stopServer();
            client.publish("test.event.2", (Object)"Hi 2!");
            Thread.sleep(1000L);
            client.subscribe("test.event.2", (Subscriber)s);
            Thread.sleep(1000L);
            server.startServer();
            client.publish("test.event.2", (Object)"Hoi 2!");
        }
    }
}

