/*
 * Decompiled with CFR 0.152.
 */
package de.nikem.jebu.impl;

import de.nikem.jebu.api.EventBus;
import de.nikem.jebu.api.Subscriber;
import de.nikem.jebu.impl.JebuRemoveSubscriberException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventBusImpl
implements EventBus {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<String, Collection<Subscriber>> subscriberMap = Collections.synchronizedMap(new HashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(String eventName, Object data) {
        Collection<Subscriber> subscriberCollection = this.getSubscriberMap().get(eventName);
        if (subscriberCollection != null) {
            Collection<Subscriber> collection = subscriberCollection;
            synchronized (collection) {
                Iterator<Subscriber> it = subscriberCollection.iterator();
                while (it.hasNext()) {
                    Subscriber subscriber = it.next();
                    try {
                        this.log.trace("publish {} to: {}", (Object)eventName, (Object)subscriber.getId());
                        subscriber.publish(eventName, data);
                    }
                    catch (JebuRemoveSubscriberException ex) {
                        this.log.debug("remove subscriber due to exception: " + subscriber.getId(), (Throwable)ex);
                        it.remove();
                        if (!subscriberCollection.isEmpty()) continue;
                        this.log.trace("remove subscriber collection for: {}", (Object)eventName);
                        this.getSubscriberMap().remove(eventName);
                    }
                }
            }
        }
    }

    @Override
    public void subscribe(String eventName, Subscriber subscriber) {
        Collection<Subscriber> subscriberCollection = this.getSubscriberMap().get(eventName);
        if (subscriberCollection == null) {
            this.log.trace("create subscriber collection for: {}", (Object)eventName);
            subscriberCollection = Collections.synchronizedCollection(new LinkedHashSet());
            this.getSubscriberMap().put(eventName, subscriberCollection);
        }
        subscriberCollection.add(subscriber);
        this.log.trace("subscribe for {}: {}", (Object)eventName, (Object)subscriber.getId());
    }

    @Override
    public void unsubscribe(String eventName, Subscriber subscriber) {
        Collection<Subscriber> subscriberCollection = this.getSubscriberMap().get(eventName);
        if (subscriberCollection != null) {
            subscriberCollection.remove(subscriber);
            if (subscriberCollection.isEmpty()) {
                this.log.trace("remove subscriber collection for: {}", (Object)eventName);
                this.getSubscriberMap().remove(eventName);
            }
        }
        this.log.trace("unsubscribe from {}: {}", (Object)eventName, (Object)subscriber.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unsubscribe(Subscriber subscriber) {
        Map<String, Collection<Subscriber>> subscriberMap;
        Map<String, Collection<Subscriber>> map = subscriberMap = this.getSubscriberMap();
        synchronized (map) {
            Iterator<Map.Entry<String, Collection<Subscriber>>> it = subscriberMap.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Collection<Subscriber>> entry = it.next();
                Collection<Subscriber> subscriberCollection = entry.getValue();
                subscriberCollection.remove(subscriber);
                if (!subscriberCollection.isEmpty()) continue;
                this.log.trace("remove subscriber collection for: {}", (Object)entry.getKey());
                it.remove();
            }
        }
        this.log.trace("unsubscribe from all events: {}", (Object)subscriber.getId());
    }

    public boolean hasSubscribers(String eventName) {
        Collection<Subscriber> subscriberCollection = this.getSubscriberMap().get(eventName);
        return subscriberCollection != null && !subscriberCollection.isEmpty();
    }

    public boolean hasSubscribers() {
        return !this.getSubscriberMap().isEmpty();
    }

    public Map<String, Collection<Subscriber>> getSubscriberMap() {
        return this.subscriberMap;
    }

    @Override
    public String getId() {
        return this.toString();
    }
}

