/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.spring.template;

import de.neuland.jade4j.template.TemplateLoader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.PostConstruct;
import javax.servlet.ServletContext;
import org.apache.commons.io.FilenameUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.context.ServletContextAware;
import org.springframework.web.context.support.ServletContextResourceLoader;

public class SpringTemplateLoader
implements TemplateLoader,
ServletContextAware {
    private ResourceLoader resourceLoader;
    private String encoding = "UTF-8";
    private String suffix = ".jade";
    private String basePath = "";
    private ServletContext context;

    @PostConstruct
    public void init() {
        if (this.resourceLoader == null) {
            this.resourceLoader = new ServletContextResourceLoader(this.context);
        }
    }

    public void setServletContext(ServletContext servletContext) {
        this.context = servletContext;
    }

    public void setResourceLoader(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public long getLastModified(String name) {
        Resource resource = this.getResource(name);
        try {
            return resource.lastModified();
        }
        catch (IOException ex) {
            return -1L;
        }
    }

    public Reader getReader(String name) throws IOException {
        Resource resource = this.getResource(name);
        return new InputStreamReader(resource.getInputStream(), this.encoding);
    }

    private Resource getResource(String name) {
        String resourceName = this.basePath + name;
        if (this.hasNoExtension(resourceName)) {
            resourceName = resourceName + this.suffix;
        }
        return this.resourceLoader.getResource(resourceName);
    }

    private boolean hasNoExtension(String filename) {
        return "".equals(FilenameUtils.getExtension((String)filename));
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getSuffix() {
        return this.suffix;
    }

    public void setSuffix(String suffix) {
        this.suffix = suffix;
    }

    public String getBasePath() {
        return this.basePath;
    }

    public void setBasePath(String basePath) {
        this.basePath = basePath;
    }
}

