/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.expression.ExpressionHandler;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.IfConditionNode;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class ConditionalNode
extends Node {
    private List<IfConditionNode> conditions = new LinkedList<IfConditionNode>();

    @Override
    public void execute(IndentWriter writer, PugModel model, PugTemplate template) throws PugCompilerException {
        for (IfConditionNode conditionNode : this.conditions) {
            try {
                if (!conditionNode.isDefault() && !(this.checkCondition(model, conditionNode.getValue(), template.getExpressionHandler()) ^ conditionNode.isInverse())) continue;
                conditionNode.getBlock().execute(writer, model, template);
                return;
            }
            catch (ExpressionException e) {
                throw new PugCompilerException((Node)conditionNode, template.getTemplateLoader(), e);
            }
        }
    }

    private boolean checkCondition(PugModel model, String condition, ExpressionHandler expressionHandler) throws ExpressionException {
        Boolean value = expressionHandler.evaluateBooleanExpression(condition, model);
        return value == null ? false : value;
    }

    public List<IfConditionNode> getConditions() {
        return Collections.unmodifiableList(this.conditions);
    }

    public void addCondition(IfConditionNode condition) {
        this.conditions.add(condition);
    }

    @Override
    public ConditionalNode clone() throws CloneNotSupportedException {
        ConditionalNode clone = (ConditionalNode)super.clone();
        clone.conditions = new LinkedList<IfConditionNode>();
        for (IfConditionNode condition : this.conditions) {
            clone.conditions.add((IfConditionNode)condition.clone());
        }
        return clone;
    }
}

