/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.lexer;

import java.io.BufferedReader;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;

public class Scanner {
    private String input;
    private String originalInput;
    public static final String UTF8_BOM = "\ufeff";

    public Scanner(Reader reader) {
        this.initFromReader(reader);
    }

    public Scanner(String input) {
        this.input = input;
    }

    public void consume(int length) {
        this.input = this.input.substring(length);
    }

    private void initFromReader(Reader reader) {
        try {
            BufferedReader in = new BufferedReader(reader);
            StringBuilder sb = new StringBuilder();
            String s = "";
            int data = in.read();
            while (data != -1) {
                char theChar = (char)data;
                sb.append(theChar);
                data = in.read();
            }
            this.input = sb.toString();
            if (StringUtils.isNotBlank((CharSequence)this.input)) {
                this.input = this.removeUTF8BOM(this.input);
                this.input = this.input.replaceAll("\\r\\n|\\r", "\n");
            }
            this.originalInput = this.input;
            in.close();
            reader.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public char charAt(int i) {
        return this.input.charAt(i);
    }

    public String getPipelessText() {
        int i = this.input.indexOf(10);
        if (-1 == i) {
            i = this.input.length();
        }
        String str = this.input.substring(0, i);
        this.consume(str.length());
        return str.trim();
    }

    public String getInput() {
        return this.input;
    }

    public String getOriginalInput() {
        return this.originalInput;
    }

    public Matcher getMatcherForPattern(Pattern pattern) {
        return pattern.matcher(this.input);
    }

    public boolean isBlankLine() {
        return this.input != null && this.input.length() > 0 && '\n' == this.input.charAt(0);
    }

    public void setInput(String input) {
        this.input = input;
    }

    private String removeUTF8BOM(String s) {
        if (s.startsWith(UTF8_BOM)) {
            s = s.substring(1);
        }
        return s;
    }
}

