/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j;

import com.googlecode.concurrentlinkedhashmap.ConcurrentLinkedHashMap;
import de.neuland.pug4j.Pug4J;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.exceptions.PugException;
import de.neuland.pug4j.expression.ExpressionHandler;
import de.neuland.pug4j.expression.JexlExpressionHandler;
import de.neuland.pug4j.filter.CDATAFilter;
import de.neuland.pug4j.filter.CssFilter;
import de.neuland.pug4j.filter.Filter;
import de.neuland.pug4j.filter.JsFilter;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.Parser;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.FileTemplateLoader;
import de.neuland.pug4j.template.PugTemplate;
import de.neuland.pug4j.template.TemplateLoader;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class PugConfiguration {
    private static final String FILTER_CDATA = "cdata";
    private static final String FILTER_STYLE = "css";
    private static final String FILTER_SCRIPT = "js";
    private boolean prettyPrint = false;
    private boolean caching = true;
    private Pug4J.Mode mode = Pug4J.Mode.XHTML;
    private Map<String, Filter> filters = new HashMap<String, Filter>();
    private Map<String, Object> sharedVariables = new HashMap<String, Object>();
    private TemplateLoader templateLoader = new FileTemplateLoader();
    private ExpressionHandler expressionHandler = new JexlExpressionHandler();
    protected static final int MAX_ENTRIES = 1000;
    private Map<String, PugTemplate> cache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1001L).build();
    private Map<String, String> lockCache = new ConcurrentLinkedHashMap.Builder().maximumWeightedCapacity(1001L).build();

    public PugConfiguration() {
        this.setFilter(FILTER_CDATA, new CDATAFilter());
        this.setFilter(FILTER_SCRIPT, new JsFilter());
        this.setFilter(FILTER_STYLE, new CssFilter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PugTemplate getTemplate(String name) throws IOException, PugException {
        if (this.caching) {
            String key;
            long lastModified = this.templateLoader.getLastModified(name);
            PugTemplate template = this.cache.get(this.getKeyValue(name, lastModified));
            if (template != null) {
                return template;
            }
            String string = key = this.getCachedKey(name, lastModified);
            synchronized (string) {
                PugTemplate newTemplate = this.createTemplate(name);
                this.cache.put(key, newTemplate);
                return newTemplate;
            }
        }
        return this.createTemplate(name);
    }

    private synchronized String getCachedKey(String name, long lastModified) {
        String cachedKey;
        String key = this.getKeyValue(name, lastModified);
        if (key.equals(cachedKey = this.lockCache.get(name))) {
            return cachedKey;
        }
        if (cachedKey != null) {
            this.cache.remove(cachedKey);
        }
        this.lockCache.put(name, key);
        return key;
    }

    private String getKeyValue(String name, long lastModified) {
        return name + "-" + lastModified;
    }

    public void renderTemplate(PugTemplate template, Map<String, Object> model, Writer writer) throws PugCompilerException {
        PugModel pugModel = new PugModel(this.sharedVariables);
        for (String filterName : this.filters.keySet()) {
            pugModel.addFilter(filterName, this.filters.get(filterName));
        }
        pugModel.putAll((Map<? extends String, ? extends Object>)model);
        template.process(pugModel, writer);
    }

    public String renderTemplate(PugTemplate template, Map<String, Object> model) throws PugCompilerException {
        StringWriter writer = new StringWriter();
        this.renderTemplate(template, model, writer);
        return writer.toString();
    }

    private PugTemplate createTemplate(String name) throws PugException, IOException {
        Parser parser = new Parser(name, this.templateLoader, this.expressionHandler);
        Node root = parser.parse();
        PugTemplate template = new PugTemplate(root, this.getMode());
        template.setTemplateLoader(this.templateLoader);
        template.setExpressionHandler(this.expressionHandler);
        template.setPrettyPrint(this.prettyPrint);
        return template;
    }

    public boolean isPrettyPrint() {
        return this.prettyPrint;
    }

    public void setPrettyPrint(boolean prettyPrint) {
        this.prettyPrint = prettyPrint;
    }

    public void setFilter(String name, Filter filter) {
        this.filters.put(name, filter);
    }

    public void removeFilter(String name) {
        this.filters.remove(name);
    }

    public Map<String, Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(Map<String, Filter> filters) {
        this.filters = filters;
    }

    public Map<String, Object> getSharedVariables() {
        return this.sharedVariables;
    }

    public void setSharedVariables(Map<String, Object> sharedVariables) {
        this.sharedVariables = sharedVariables;
    }

    public TemplateLoader getTemplateLoader() {
        return this.templateLoader;
    }

    public void setTemplateLoader(TemplateLoader templateLoader) {
        this.templateLoader = templateLoader;
    }

    public void setExpressionHandler(ExpressionHandler expressionHandler) {
        this.expressionHandler = expressionHandler;
    }

    public ExpressionHandler getExpressionHandler() {
        return this.expressionHandler;
    }

    public Pug4J.Mode getMode() {
        return this.mode;
    }

    public void setMode(Pug4J.Mode mode) {
        this.mode = mode;
    }

    public boolean templateExists(String url) {
        try {
            return this.templateLoader.getReader(url) != null;
        }
        catch (IOException e) {
            return false;
        }
    }

    public boolean isCaching() {
        return this.caching;
    }

    public void setCaching(boolean cache) {
        if (cache != this.caching) {
            this.expressionHandler.setCache(cache);
            this.caching = cache;
        }
    }

    public void clearCache() {
        this.expressionHandler.clearCache();
        this.cache.clear();
    }
}

