/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser;

import de.neuland.pug4j.exceptions.PugParserException;
import de.neuland.pug4j.expression.ExpressionHandler;
import de.neuland.pug4j.lexer.Lexer;
import de.neuland.pug4j.lexer.token.Assignment;
import de.neuland.pug4j.lexer.token.Attribute;
import de.neuland.pug4j.lexer.token.AttributesBlock;
import de.neuland.pug4j.lexer.token.Block;
import de.neuland.pug4j.lexer.token.BlockCode;
import de.neuland.pug4j.lexer.token.Call;
import de.neuland.pug4j.lexer.token.CaseToken;
import de.neuland.pug4j.lexer.token.Code;
import de.neuland.pug4j.lexer.token.Colon;
import de.neuland.pug4j.lexer.token.Comment;
import de.neuland.pug4j.lexer.token.CssClass;
import de.neuland.pug4j.lexer.token.CssId;
import de.neuland.pug4j.lexer.token.Default;
import de.neuland.pug4j.lexer.token.Doctype;
import de.neuland.pug4j.lexer.token.Dot;
import de.neuland.pug4j.lexer.token.Each;
import de.neuland.pug4j.lexer.token.Else;
import de.neuland.pug4j.lexer.token.ElseIf;
import de.neuland.pug4j.lexer.token.EndAttributes;
import de.neuland.pug4j.lexer.token.EndPipelessText;
import de.neuland.pug4j.lexer.token.EndPugInterpolation;
import de.neuland.pug4j.lexer.token.Eos;
import de.neuland.pug4j.lexer.token.Expression;
import de.neuland.pug4j.lexer.token.ExtendsToken;
import de.neuland.pug4j.lexer.token.Filter;
import de.neuland.pug4j.lexer.token.If;
import de.neuland.pug4j.lexer.token.Include;
import de.neuland.pug4j.lexer.token.Indent;
import de.neuland.pug4j.lexer.token.InterpolatedCode;
import de.neuland.pug4j.lexer.token.Interpolation;
import de.neuland.pug4j.lexer.token.Mixin;
import de.neuland.pug4j.lexer.token.MixinBlock;
import de.neuland.pug4j.lexer.token.Newline;
import de.neuland.pug4j.lexer.token.Outdent;
import de.neuland.pug4j.lexer.token.Path;
import de.neuland.pug4j.lexer.token.Slash;
import de.neuland.pug4j.lexer.token.StartAttributes;
import de.neuland.pug4j.lexer.token.StartPipelessText;
import de.neuland.pug4j.lexer.token.StartPugInterpolation;
import de.neuland.pug4j.lexer.token.Tag;
import de.neuland.pug4j.lexer.token.Text;
import de.neuland.pug4j.lexer.token.TextHtml;
import de.neuland.pug4j.lexer.token.Token;
import de.neuland.pug4j.lexer.token.When;
import de.neuland.pug4j.lexer.token.While;
import de.neuland.pug4j.lexer.token.Yield;
import de.neuland.pug4j.parser.PathHelper;
import de.neuland.pug4j.parser.node.AssigmentNode;
import de.neuland.pug4j.parser.node.AttrsNode;
import de.neuland.pug4j.parser.node.BlockCommentNode;
import de.neuland.pug4j.parser.node.BlockNode;
import de.neuland.pug4j.parser.node.CaseNode;
import de.neuland.pug4j.parser.node.CommentNode;
import de.neuland.pug4j.parser.node.ConditionalNode;
import de.neuland.pug4j.parser.node.DoctypeNode;
import de.neuland.pug4j.parser.node.EachNode;
import de.neuland.pug4j.parser.node.ExpressionNode;
import de.neuland.pug4j.parser.node.FilterNode;
import de.neuland.pug4j.parser.node.IfConditionNode;
import de.neuland.pug4j.parser.node.IncludeFilterNode;
import de.neuland.pug4j.parser.node.LiteralNode;
import de.neuland.pug4j.parser.node.MixinBlockNode;
import de.neuland.pug4j.parser.node.MixinNode;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.parser.node.TagNode;
import de.neuland.pug4j.parser.node.TextNode;
import de.neuland.pug4j.parser.node.WhileNode;
import de.neuland.pug4j.template.TemplateLoader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;

public class Parser {
    private final Lexer lexer;
    private LinkedHashMap<String, BlockNode> blocks = new LinkedHashMap();
    private final TemplateLoader templateLoader;
    private final ExpressionHandler expressionHandler;
    private Parser extending;
    private final String filename;
    private LinkedList<Parser> contexts = new LinkedList();
    private int inMixin = 0;
    private HashMap<String, MixinNode> mixins = new HashMap();
    private int inBlock = 0;
    private PathHelper pathHelper = new PathHelper();
    private Node extendingNode;

    public Parser(String filename, TemplateLoader templateLoader, ExpressionHandler expressionHandler) throws IOException {
        this.filename = filename;
        this.templateLoader = templateLoader;
        this.expressionHandler = expressionHandler;
        this.lexer = new Lexer(filename, templateLoader, expressionHandler);
        this.getContexts().push(this);
    }

    public Parser(String src, String filename, TemplateLoader templateLoader, ExpressionHandler expressionHandler) throws IOException {
        this.filename = filename;
        this.templateLoader = templateLoader;
        this.expressionHandler = expressionHandler;
        this.lexer = new Lexer(src, filename, templateLoader, expressionHandler);
        this.getContexts().push(this);
    }

    private PugParserException error(String code, String message, Token token) {
        return new PugParserException(this.filename, token.getStartLineNumber(), this.templateLoader, message, code);
    }

    private BlockNode emptyBlock() {
        return this.emptyBlock(0);
    }

    private BlockNode emptyBlock(int line) {
        return this.initBlock(line, new LinkedList<Node>());
    }

    public Node parse() {
        BlockNode block = this.emptyBlock(0);
        while (!(this.peek() instanceof Eos)) {
            if (this.peek() instanceof Newline) {
                this.advance();
                continue;
            }
            if (this.peek() instanceof TextHtml) {
                block.getNodes().addAll(this.parseTextHtml());
                continue;
            }
            Node expr = this.parseExpr();
            if (expr == null) continue;
            if (expr instanceof BlockNode && !((BlockNode)expr).isYield() && !((BlockNode)expr).isNamedBlock()) {
                block.getNodes().addAll(expr.getNodes());
                continue;
            }
            block.push(expr);
        }
        if (this.extending != null) {
            Node rootNode = this.extendingNode;
            Set<String> keySet = this.mixins.keySet();
            for (String name : keySet) {
                rootNode.getNodes().push(this.mixins.get(name));
            }
            return rootNode;
        }
        return block;
    }

    private Node parseExpr() {
        Token token = this.peek();
        if (token instanceof Tag) {
            return this.parseTag();
        }
        if (token instanceof Mixin) {
            return this.parseMixin();
        }
        if (token instanceof Block) {
            return this.parseBlock();
        }
        if (token instanceof MixinBlock) {
            return this.parseMixinBlock();
        }
        if (token instanceof CaseToken) {
            return this.parseCase();
        }
        if (token instanceof ExtendsToken) {
            return this.parseExtends();
        }
        if (token instanceof Include) {
            return this.parseInclude();
        }
        if (token instanceof Doctype) {
            return this.parseDoctype();
        }
        if (token instanceof Filter) {
            return this.parseFilter();
        }
        if (token instanceof Comment) {
            return this.parseComment();
        }
        if (token instanceof Text || token instanceof InterpolatedCode || token instanceof StartPugInterpolation) {
            return this.parseText(true);
        }
        if (token instanceof TextHtml) {
            return this.initBlock(this.peek().getStartLineNumber(), this.parseTextHtml());
        }
        if (token instanceof Dot) {
            return this.parseDot();
        }
        if (token instanceof Each) {
            return this.parseEach();
        }
        if (token instanceof Code) {
            return this.parseCode();
        }
        if (token instanceof Expression) {
            return this.parseCode();
        }
        if (token instanceof BlockCode) {
            return this.parseBlockCode();
        }
        if (token instanceof If) {
            return this.parseConditional();
        }
        if (token instanceof While) {
            return this.parseWhile();
        }
        if (token instanceof Call) {
            return this.parseCall();
        }
        if (token instanceof Interpolation) {
            return this.parseInterpolation();
        }
        if (token instanceof Yield) {
            return this.parseYield();
        }
        if (token instanceof CssClass || token instanceof CssId) {
            return this.parseCssClassOrId();
        }
        if (token instanceof Assignment) {
            return this.parseAssignment();
        }
        throw this.error("INVALID_TOKEN", "unexpected token \"" + this.peek().getType() + "\"", this.peek());
    }

    private BlockNode initBlock(int startLineNumber, LinkedList<Node> nodes) {
        if (nodes == null) {
            throw new PugParserException(this.filename, this.line(), this.templateLoader, "`nodes` is not an array");
        }
        BlockNode blockNode = new BlockNode();
        blockNode.setNodes(nodes);
        blockNode.setLineNumber(startLineNumber);
        blockNode.setFileName(this.filename);
        return blockNode;
    }

    private Node parseBlockCode() {
        Token tok = this.expect(BlockCode.class);
        int line = tok.getStartLineNumber();
        int column = tok.getStartColumn();
        Token body = this.peek();
        String text = "";
        if (body instanceof StartPipelessText) {
            this.advance();
            while (!(this.peek() instanceof EndPipelessText)) {
                tok = this.advance();
                if (tok instanceof Text) {
                    text = text + tok.getValue();
                    continue;
                }
                if (tok instanceof Newline) {
                    text = text + "\n";
                    continue;
                }
                throw this.error("INVALID_TOKEN", "Unexpected token type: " + tok.getType(), tok);
            }
            this.advance();
        }
        ExpressionNode node = new ExpressionNode();
        node.setValue(text);
        node.setBuffer(false);
        node.setEscape(false);
        node.setInline(false);
        node.setLineNumber(line);
        node.setColumn(column);
        return node;
    }

    private Node parseComment() {
        Token token = this.expect(Comment.class);
        BlockNode block = this.parseTextBlock();
        if (block != null) {
            BlockCommentNode node = new BlockCommentNode();
            node.setValue(token.getValue());
            node.setBlock(block);
            node.setBuffered(token.isBuffer());
            node.setLineNumber(token.getStartLineNumber());
            node.setColumn(token.getStartColumn());
            node.setFileName(this.filename);
            return node;
        }
        CommentNode node = new CommentNode();
        node.setValue(token.getValue());
        node.setBuffered(token.isBuffer());
        node.setLineNumber(token.getStartLineNumber());
        node.setColumn(token.getStartColumn());
        node.setFileName(this.filename);
        return node;
    }

    private Node parseMixin() {
        Mixin mixinToken = (Mixin)this.expect(Mixin.class);
        if (this.peek() instanceof Indent) {
            Matcher matcher;
            List<String> args;
            ++this.inMixin;
            MixinNode node = new MixinNode();
            node.setName(mixinToken.getValue());
            node.setLineNumber(mixinToken.getStartLineNumber());
            node.setColumn(mixinToken.getStartColumn());
            node.setFileName(this.filename);
            if (StringUtils.isNotBlank((CharSequence)mixinToken.getArguments())) {
                node.setArguments(mixinToken.getArguments());
            }
            if ((args = node.getArguments()).size() > 0 && (matcher = Pattern.compile("^\\.\\.\\.").matcher(args.get(args.size() - 1).trim())).find(0)) {
                String rest = args.remove(args.size() - 1).trim().replaceAll("^\\.\\.\\.", "");
                node.setRest(rest);
            }
            node.setBlock(this.block());
            node.setCall(false);
            this.mixins.put(mixinToken.getValue(), node);
            --this.inMixin;
            return node;
        }
        throw this.error("MIXIN_WITHOUT_BODY", "Mixin " + mixinToken.getValue() + " declared without body", mixinToken);
    }

    private Node parseCall() {
        Call callToken = (Call)this.expect(Call.class);
        MixinNode mixin = new MixinNode();
        mixin.setBlock(this.emptyBlock(callToken.getStartLineNumber()));
        mixin.setName(callToken.getValue());
        mixin.setLineNumber(callToken.getStartLineNumber());
        mixin.setColumn(callToken.getStartColumn());
        mixin.setFileName(this.filename);
        mixin.setCall(true);
        if (StringUtils.isNotBlank((CharSequence)callToken.getArguments())) {
            mixin.setArguments(callToken.getArguments());
        }
        this.tag(mixin);
        if (mixin.hasCodeNode()) {
            mixin.getBlock().push(mixin.getCodeNode());
            mixin.setCodeNode(null);
        }
        if (mixin.hasBlock() && mixin.getBlock().getNodes().isEmpty()) {
            mixin.setBlock(null);
        }
        return mixin;
    }

    private Node parseCssClassOrId() {
        Tag div = new Tag("div");
        div.setStartColumn(this.peek().getStartColumn());
        div.setStartLineNumber(this.peek().getStartLineNumber());
        div.setEndColumn(this.peek().getEndColumn());
        div.setEndLineNumber(this.peek().getEndLineNumber());
        div.setFileName(this.filename);
        this.lexer.defer(div);
        return this.parseExpr();
    }

    private BlockNode parseBlock() {
        Block blockToken = (Block)this.expect(Block.class);
        String mode = blockToken.getMode();
        String name = blockToken.getValue().trim();
        BlockNode blockNode = this.peek() instanceof Indent ? this.block() : this.emptyBlock(blockToken.getStartLineNumber());
        blockNode.setNamedBlock(true);
        blockNode.setName(name);
        blockNode.setLineNumber(blockToken.getStartLineNumber());
        blockNode.setColumn(blockToken.getStartColumn());
        blockNode.setFileName(this.filename);
        blockNode.setMode(mode);
        blockNode.setParser(this);
        BlockNode prev = this.blocks.get(name);
        if (prev != null) {
            LinkedList<Node> nodes = new LinkedList();
            if ("replace".equals(mode)) {
                nodes = blockNode.getNodes();
            } else if ("append".equals(mode)) {
                nodes.addAll(prev.getNodes());
                nodes.addAll(blockNode.getNodes());
            } else if ("prepend".equals(mode)) {
                nodes.addAll(blockNode.getNodes());
                nodes.addAll(prev.getNodes());
            }
            prev.setNodes(nodes);
            blockNode = prev;
        }
        this.blocks.put(name, blockNode);
        return blockNode;
    }

    private Node parseMixinBlock() {
        Token tok = this.expect(MixinBlock.class);
        if (this.inMixin == 0) {
            throw this.error("BLOCK_OUTSIDE_MIXIN", "Anonymous blocks are not allowed unless they are part of a mixin.", tok);
        }
        MixinBlockNode mixinBlockNode = new MixinBlockNode();
        mixinBlockNode.setLineNumber(tok.getStartLineNumber());
        mixinBlockNode.setColumn(tok.getStartColumn());
        mixinBlockNode.setFileName(this.filename);
        return mixinBlockNode;
    }

    private Node parseInclude() {
        Include includeToken = (Include)this.expect(Include.class);
        LinkedList<IncludeFilterNode> filters = new LinkedList<IncludeFilterNode>();
        while (this.peek() instanceof Filter) {
            filters.add(this.parseIncludeFilter());
        }
        Path pathToken = (Path)this.expect(Path.class);
        String templateName = pathToken.getValue().trim();
        String path = this.pathHelper.resolvePath(this.filename, templateName, this.templateLoader.getBase());
        try {
            if (filters.size() > 0) {
                Reader reader = this.templateLoader.getReader(path);
                FilterNode node = new FilterNode();
                node.setFilter(filters);
                node.setLineNumber(this.line());
                node.setFileName(this.filename);
                TextNode text = new TextNode();
                text.setValue(IOUtils.toString((Reader)reader));
                BlockNode block = new BlockNode();
                LinkedList<Node> nodes = new LinkedList<Node>();
                nodes.add(text);
                block.setNodes(nodes);
                if (block != null) {
                    node.setBlock(block);
                } else {
                    node.setBlock(this.emptyBlock(includeToken.getStartLineNumber()));
                }
                return node;
            }
        }
        catch (IOException e) {
            throw this.error("PATH_EXCEPTION", "the included file [" + templateName + "] could not be opened\n" + e.getMessage(), pathToken);
        }
        String extension = FilenameUtils.getExtension((String)path);
        if (!this.templateLoader.getExtension().equals(extension) && !"".equals(extension)) {
            try {
                Reader reader = this.templateLoader.getReader(path);
                LiteralNode node = new LiteralNode();
                node.setLineNumber(pathToken.getStartLineNumber());
                node.setColumn(pathToken.getStartColumn());
                node.setFileName(this.filename);
                node.setValue(IOUtils.toString((Reader)reader));
                return node;
            }
            catch (IOException e) {
                throw this.error("PATH_EXCEPTION", "the included file [" + templateName + "] could not be opened\n" + e.getMessage(), pathToken);
            }
        }
        Parser parser = this.createParser(templateName);
        parser.setBlocks(this.blocks);
        parser.setMixins(this.mixins);
        this.contexts.push(parser);
        Node ast = parser.parse();
        this.contexts.pop();
        ast.setFileName(path);
        if (this.peek() instanceof Indent && ast != null) {
            BlockNode includeBlock = ((BlockNode)ast).getYieldBlock();
            includeBlock.push(this.block());
            includeBlock.setYield(false);
        }
        return ast;
    }

    private Node parseExtends() {
        ExtendsToken extendsToken = (ExtendsToken)this.expect(ExtendsToken.class);
        Path path = (Path)this.expect(Path.class);
        String templateName = path.getValue().trim();
        Parser parser = this.createParser(templateName);
        parser.setContexts(this.contexts);
        this.extending = parser;
        this.getContexts().push(this.extending);
        this.extendingNode = this.extending.parse();
        this.blocks = parser.getBlocks();
        this.getContexts().pop();
        LiteralNode node = new LiteralNode();
        node.setValue("");
        return node;
    }

    private Parser createParser(String templateName) {
        templateName = this.ensurePugExtension(templateName);
        try {
            String resolvedPath = this.pathHelper.resolvePath(this.filename, templateName, this.templateLoader.getBase());
            return new Parser(resolvedPath, this.templateLoader, this.expressionHandler);
        }
        catch (IOException e) {
            throw new PugParserException(this.filename, this.lexer.getLineno(), this.templateLoader, "The template [" + templateName + "] could not be opened. \n" + e.getMessage());
        }
    }

    private String ensurePugExtension(String templateName) {
        if (!this.templateLoader.getExtension().equals(FilenameUtils.getExtension((String)templateName))) {
            return templateName + "." + this.templateLoader.getExtension();
        }
        return templateName;
    }

    private BlockNode parseYield() {
        Token token = this.expect(Yield.class);
        BlockNode block = new BlockNode();
        block.setLineNumber(token.getStartLineNumber());
        block.setColumn(token.getStartColumn());
        block.setFileName(this.filename);
        block.setYield(true);
        return block;
    }

    private Node parseInterpolation() {
        Token token = this.advance();
        String name = token.getValue();
        TagNode tagNode = new TagNode();
        tagNode.setBlock(this.emptyBlock(token.getStartLineNumber()));
        tagNode.setLineNumber(token.getStartLineNumber());
        tagNode.setColumn(token.getStartColumn());
        tagNode.setFileName(this.filename);
        tagNode.setName(name);
        tagNode.setInterpolated(true);
        return this.tag(tagNode, true);
    }

    private BlockNode block() {
        Token token = this.expect(Indent.class);
        BlockNode block = this.emptyBlock(token.getStartLineNumber());
        while (!(this.peek() instanceof Outdent)) {
            if (this.peek() instanceof Newline) {
                this.advance();
                continue;
            }
            if (this.peek() instanceof TextHtml) {
                block.getNodes().addAll(this.parseTextHtml());
                continue;
            }
            Node expr = this.parseExpr();
            if (expr == null) continue;
            if (expr instanceof BlockNode && !((BlockNode)expr).isYield() && !((BlockNode)expr).isNamedBlock()) {
                block.getNodes().addAll(expr.getNodes());
                continue;
            }
            block.push(expr);
        }
        this.expect(Outdent.class);
        return block;
    }

    private Node parseText() {
        return this.parseText(false);
    }

    private Node parseText(boolean block) {
        LinkedList<Node> tags = new LinkedList<Node>();
        int lineno = this.peek().getStartLineNumber();
        Token nextToken = this.peek();
        while (true) {
            Token token;
            if (nextToken instanceof Text) {
                token = this.advance();
                TextNode textNode = new TextNode();
                textNode.setValue(token.getValue());
                textNode.setLineNumber(token.getStartLineNumber());
                textNode.setColumn(token.getStartColumn());
                textNode.setFileName(this.filename);
                tags.add(textNode);
            } else if (nextToken instanceof InterpolatedCode) {
                token = (InterpolatedCode)this.advance();
                ExpressionNode expressionNode = new ExpressionNode();
                expressionNode.setValue(token.getValue());
                expressionNode.setBuffer(token.isBuffer());
                expressionNode.setEscape(((InterpolatedCode)token).isMustEscape());
                expressionNode.setInline(true);
                expressionNode.setLineNumber(token.getStartLineNumber());
                expressionNode.setColumn(token.getStartColumn());
                expressionNode.setFileName(this.filename);
                tags.add(expressionNode);
            } else if (nextToken instanceof Newline) {
                if (!block) break;
                token = this.advance();
                Token nextType = this.peek();
                if (nextType instanceof Text || nextType instanceof InterpolatedCode) {
                    TextNode textNode = new TextNode();
                    textNode.setValue("\n");
                    textNode.setLineNumber(token.getStartLineNumber());
                    textNode.setColumn(token.getStartColumn());
                    textNode.setFileName(this.filename);
                    tags.add(textNode);
                }
            } else {
                if (!(nextToken instanceof StartPugInterpolation)) break;
                this.advance();
                tags.add(this.parseExpr());
                this.expect(EndPugInterpolation.class);
            }
            nextToken = this.peek();
        }
        if (tags.size() == 1) {
            return (Node)tags.get(0);
        }
        return this.initBlock(lineno, tags);
    }

    private LinkedList<Node> parseTextHtml() {
        LinkedList<Node> nodes = new LinkedList<Node>();
        Node currentNode = null;
        block0: while (true) {
            if (this.peek() instanceof TextHtml) {
                Token text = this.advance();
                if (currentNode == null) {
                    TextNode textNode = new TextNode();
                    textNode.setValue(text.getValue());
                    textNode.setFileName(this.filename);
                    textNode.setLineNumber(text.getStartLineNumber());
                    textNode.setColumn(text.getStartColumn());
                    textNode.setHtml(true);
                    currentNode = textNode;
                    nodes.add(currentNode);
                    continue;
                }
                currentNode.setValue(currentNode.getValue() + "\n" + text.getValue());
                continue;
            }
            if (this.peek() instanceof Indent) {
                BlockNode block = this.block();
                LinkedList<Node> blockNodes = block.getNodes();
                Iterator iterator = blockNodes.iterator();
                while (true) {
                    if (!iterator.hasNext()) continue block0;
                    Node node = (Node)iterator.next();
                    if (node instanceof TextNode && ((TextNode)node).isHtml()) {
                        if (currentNode == null) {
                            currentNode = node;
                            nodes.add(currentNode);
                            continue;
                        }
                        currentNode.setValue(currentNode.getValue() + "\n" + node.getValue());
                        continue;
                    }
                    currentNode = null;
                    nodes.add(node);
                }
            }
            if (this.peek() instanceof Expression) {
                currentNode = null;
                nodes.add(this.parseCode(true));
                continue;
            }
            if (!(this.peek() instanceof Newline)) break;
            this.advance();
        }
        return nodes;
    }

    private Node parseDot() {
        this.advance();
        return this.parseTextBlock();
    }

    private Node parseEach() {
        Each eachToken = (Each)this.expect(Each.class);
        EachNode node = new EachNode();
        node.setValue(eachToken.getValue());
        node.setKey(eachToken.getKey());
        node.setCode(eachToken.getCode());
        node.setLineNumber(eachToken.getStartLineNumber());
        node.setColumn(eachToken.getStartColumn());
        node.setFileName(this.filename);
        node.setBlock(this.block());
        if (this.peek() instanceof Else) {
            this.advance();
            node.setElseNode(this.block());
        }
        return node;
    }

    private Node parseWhile() {
        While whileToken = (While)this.expect(While.class);
        WhileNode node = new WhileNode();
        node.setValue(whileToken.getValue());
        node.setLineNumber(whileToken.getStartLineNumber());
        node.setColumn(whileToken.getStartColumn());
        node.setFileName(this.filename);
        if (this.peek() instanceof Indent) {
            node.setBlock(this.block());
        } else {
            node.setBlock(this.emptyBlock());
        }
        return node;
    }

    private Node parseAssignment() {
        Token token = this.expect(Assignment.class);
        Assignment assignmentToken = (Assignment)token;
        AssigmentNode node = new AssigmentNode();
        node.setName(assignmentToken.getName());
        ((Node)node).setValue(assignmentToken.getValue());
        node.setLineNumber(assignmentToken.getStartLineNumber());
        node.setFileName(this.filename);
        return node;
    }

    private Node parseTag() {
        Token token = this.advance();
        String name = token.getValue();
        TagNode tagNode = new TagNode();
        tagNode.setName(name);
        tagNode.setBlock(this.emptyBlock());
        tagNode.setLineNumber(token.getStartLineNumber());
        tagNode.setColumn(token.getStartColumn());
        tagNode.setFileName(this.filename);
        tagNode.setValue(name);
        return this.tag(tagNode, true);
    }

    private Node tag(AttrsNode tagNode) {
        return this.tag(tagNode, false);
    }

    private Node tag(AttrsNode tagNode, boolean selfClosingAllowed) {
        BlockNode block;
        boolean seenAttrs = false;
        while (true) {
            Token tok;
            Token incomingToken;
            if ((incomingToken = this.peek()) instanceof CssId) {
                tok = this.advance();
                tagNode.setAttribute("id", tok.getValue(), false);
                continue;
            }
            if (incomingToken instanceof CssClass) {
                tok = this.advance();
                tagNode.setAttribute("class", tok.getValue(), false);
                continue;
            }
            if (incomingToken instanceof StartAttributes) {
                if (seenAttrs) {
                    throw new PugParserException(this.filename, this.line(), this.templateLoader, this.filename + ", line " + this.peek().getStartLineNumber() + ":\nYou should not have jade tags with multiple attributes.");
                }
                seenAttrs = true;
                this.attrs(tagNode);
                continue;
            }
            if (!(incomingToken instanceof AttributesBlock)) break;
            tok = this.advance();
            tagNode.addAttributes(tok.getValue());
        }
        if (this.peek() instanceof Dot) {
            tagNode.setTextOnly(true);
            this.advance();
        }
        if (this.peek() instanceof Text || this.peek() instanceof InterpolatedCode) {
            Node node = this.parseText();
            if (node instanceof BlockNode) {
                BlockNode block2 = (BlockNode)node;
                tagNode.getBlock().getNodes().addAll(block2.getNodes());
            } else {
                tagNode.getBlock().push(node);
            }
        } else if (this.peek() instanceof Expression) {
            tagNode.getBlock().push(this.parseCode(true));
        } else if (this.peek() instanceof Colon) {
            Token next = this.advance();
            Node node = this.parseExpr();
            if (node instanceof BlockNode) {
                tagNode.setBlock(node);
            } else {
                LinkedList<Node> nodes = new LinkedList<Node>();
                nodes.add(node);
                tagNode.setBlock(this.initBlock(tagNode.getLineNumber(), nodes));
            }
        } else if (this.peek() instanceof Slash && selfClosingAllowed) {
            this.advance();
            tagNode.setSelfClosing(true);
        }
        while (this.peek() instanceof Newline) {
            this.advance();
        }
        if (tagNode.isTextOnly()) {
            block = this.parseTextBlock();
            if (block == null) {
                block = this.emptyBlock(tagNode.getLineNumber());
            }
            tagNode.setBlock(block);
        } else if (this.peek() instanceof Indent) {
            block = this.block();
            int len = block.getNodes().size();
            for (int i = 0; i < len; ++i) {
                tagNode.getBlock().push(block.getNodes().get(i));
            }
        }
        return tagNode;
    }

    private void attrs(AttrsNode attrsNode) {
        this.expect(StartAttributes.class);
        Token token = this.advance();
        while (token instanceof Attribute) {
            Attribute attr = (Attribute)token;
            String name = attr.getName();
            Object value = attr.getAttributeValue();
            attrsNode.setAttribute(name, value, attr.mustEscape());
            token = this.advance();
        }
        this.defer(token);
        this.expect(EndAttributes.class);
    }

    private BlockNode parseTextBlock() {
        Token token = this.accept(StartPipelessText.class);
        if (token == null) {
            return null;
        }
        BlockNode blockNode = this.emptyBlock(token.getStartLineNumber());
        while (!(this.peek() instanceof EndPipelessText)) {
            TextNode textNode;
            token = this.advance();
            if (token instanceof Text) {
                textNode = new TextNode();
                textNode.setValue(token.getValue());
                textNode.setLineNumber(token.getStartLineNumber());
                textNode.setColumn(token.getStartColumn());
                textNode.setFileName(this.filename);
                blockNode.getNodes().add(textNode);
                continue;
            }
            if (token instanceof Newline) {
                textNode = new TextNode();
                textNode.setValue("\n");
                textNode.setLineNumber(token.getStartLineNumber());
                textNode.setColumn(token.getStartColumn());
                textNode.setFileName(this.filename);
                blockNode.getNodes().add(textNode);
                continue;
            }
            if (token instanceof StartPugInterpolation) {
                blockNode.getNodes().add(this.parseExpr());
                this.expect(EndPugInterpolation.class);
                continue;
            }
            if (token instanceof InterpolatedCode) {
                ExpressionNode expressionNode = new ExpressionNode();
                expressionNode.setValue(token.getValue());
                expressionNode.setBuffer(token.isBuffer());
                expressionNode.setEscape(((InterpolatedCode)token).isMustEscape());
                expressionNode.setInline(true);
                expressionNode.setLineNumber(token.getStartLineNumber());
                expressionNode.setColumn(token.getStartColumn());
                expressionNode.setFileName(this.filename);
                blockNode.getNodes().add(expressionNode);
                continue;
            }
            throw this.error("INVALID_TOKEN", "Unexpected token type: " + token.getType(), token);
        }
        this.advance();
        return blockNode;
    }

    private Node parseConditional() {
        ConditionalNode conditional;
        block8: {
            Token token;
            If conditionalToken = (If)this.expect(If.class);
            conditional = new ConditionalNode();
            conditional.setLineNumber(conditionalToken.getStartLineNumber());
            conditional.setColumn(conditionalToken.getStartColumn());
            conditional.setFileName(this.filename);
            List<IfConditionNode> conditions = conditional.getConditions();
            IfConditionNode main = new IfConditionNode(conditionalToken.getValue(), conditionalToken.getStartLineNumber());
            main.setInverse(conditionalToken.isInverseCondition());
            main.setFileName(this.filename);
            if (this.peek() instanceof Indent) {
                main.setBlock(this.block());
            } else {
                main.setBlock(this.emptyBlock());
            }
            conditions.add(main);
            while (true) {
                if (this.peek() instanceof Newline) {
                    this.expect(Newline.class);
                    continue;
                }
                if (!(this.peek() instanceof ElseIf)) break;
                token = (ElseIf)this.expect(ElseIf.class);
                IfConditionNode elseIf = new IfConditionNode(token.getValue(), token.getStartLineNumber());
                elseIf.setFileName(this.filename);
                if (this.peek() instanceof Indent) {
                    elseIf.setBlock(this.block());
                } else {
                    elseIf.setBlock(this.emptyBlock());
                }
                conditions.add(elseIf);
            }
            if (!(this.peek() instanceof Else)) break block8;
            token = (Else)this.expect(Else.class);
            IfConditionNode elseNode = new IfConditionNode(null, token.getStartLineNumber());
            elseNode.setFileName(this.filename);
            elseNode.setDefault(true);
            if (this.peek() instanceof Indent) {
                elseNode.setBlock(this.block());
            } else {
                elseNode.setBlock(this.emptyBlock());
            }
            conditions.add(elseNode);
        }
        return conditional;
    }

    private BlockNode parseBlockExpansion() {
        Token token = this.accept(Colon.class);
        if (token != null) {
            Node node = this.parseExpr();
            if (node instanceof BlockNode) {
                return (BlockNode)node;
            }
            LinkedList<Node> nodes = new LinkedList<Node>();
            nodes.add(node);
            return this.initBlock(node.getLineNumber(), nodes);
        }
        return this.block();
    }

    private CaseNode parseCase() {
        Token token = this.expect(CaseToken.class);
        String val = token.getValue();
        CaseNode node = new CaseNode();
        node.setValue(val);
        node.setLineNumber(token.getStartLineNumber());
        node.setColumn(token.getStartColumn());
        node.setFileName(this.filename);
        BlockNode block = this.emptyBlock(token.getStartLineNumber() + 1);
        this.expect(Indent.class);
        while (!(this.peek() instanceof Outdent)) {
            if (this.peek() instanceof Comment) {
                this.advance();
                continue;
            }
            if (this.peek() instanceof Newline) {
                this.advance();
                continue;
            }
            if (this.peek() instanceof When) {
                block.push(this.parseWhen());
                continue;
            }
            if (this.peek() instanceof Default) {
                block.push(this.parseDefault());
                continue;
            }
            throw this.error("INVALID_TOKEN", "Unexpected token \"" + this.peek() + "\", expected \"when\", \"default\" or \"newline\"", this.peek());
        }
        this.expect(Outdent.class);
        node.setBlock(block);
        return node;
    }

    private Node parseWhen() {
        Token token = this.expect(When.class);
        String val = token.getValue();
        CaseNode.When when = new CaseNode.When();
        when.setValue(val);
        when.setLineNumber(token.getStartLineNumber());
        when.setColumn(token.getStartColumn());
        when.setFileName(this.filename);
        if (!(this.peek() instanceof Newline)) {
            when.setBlock(this.parseBlockExpansion());
        }
        return when;
    }

    private Node parseDefault() {
        Token token = this.expect(Default.class);
        CaseNode.When when = new CaseNode.When();
        when.setValue("default");
        when.setBlock(this.parseBlockExpansion());
        when.setLineNumber(token.getStartLineNumber());
        when.setColumn(token.getStartColumn());
        when.setFileName(this.filename);
        return when;
    }

    private Node parseCode() {
        return this.parseCode(false);
    }

    private Node parseCode(boolean noBlock) {
        Token token = this.expect(Expression.class);
        Expression expressionToken = (Expression)token;
        ExpressionNode codeNode = new ExpressionNode();
        codeNode.setValue(expressionToken.getValue());
        codeNode.setBuffer(expressionToken.isBuffer());
        codeNode.setEscape(expressionToken.isEscape());
        codeNode.setInline(noBlock);
        codeNode.setLineNumber(expressionToken.getStartLineNumber());
        codeNode.setColumn(expressionToken.getStartColumn());
        codeNode.setFileName(this.filename);
        if (noBlock) {
            return codeNode;
        }
        boolean block = this.peek() instanceof Indent;
        if (block) {
            if (token.isBuffer()) {
                throw this.error("BLOCK_IN_BUFFERED_CODE", "Buffered code cannot have a block attached to it", this.peek());
            }
            codeNode.setBlock(this.block());
        }
        return codeNode;
    }

    private Node parseDoctype() {
        Doctype doctype = (Doctype)this.expect(Doctype.class);
        DoctypeNode doctypeNode = new DoctypeNode();
        doctypeNode.setValue(doctype.getValue());
        doctypeNode.setLineNumber(doctype.getStartLineNumber());
        doctypeNode.setColumn(doctype.getStartColumn());
        doctypeNode.setFileName(this.filename);
        return doctypeNode;
    }

    private IncludeFilterNode parseIncludeFilter() {
        Filter token = (Filter)this.expect(Filter.class);
        IncludeFilterNode includeFilter = new IncludeFilterNode();
        includeFilter.setValue(token.getValue());
        includeFilter.setLineNumber(token.getStartLineNumber());
        includeFilter.setColumn(token.getStartColumn());
        includeFilter.setFileName(this.filename);
        if (this.peek() instanceof StartAttributes) {
            this.attrs(includeFilter);
        }
        return includeFilter;
    }

    private Node parseFilter() {
        BlockNode blockNode;
        Filter filterToken = (Filter)this.expect(Filter.class);
        FilterNode node = new FilterNode();
        node.setValue(filterToken.getValue());
        node.setLineNumber(this.line());
        node.setFileName(this.filename);
        node.setColumn(filterToken.getStartColumn());
        if (this.peek() instanceof StartAttributes) {
            this.attrs(node);
        }
        if (this.peek() instanceof Text) {
            Token textToken = this.advance();
            LinkedList<Node> nodes = new LinkedList<Node>();
            TextNode textNode = new TextNode();
            textNode.setValue(textToken.getValue());
            textNode.setLineNumber(textToken.getStartLineNumber());
            textNode.setColumn(textToken.getStartColumn());
            textNode.setFileName(this.filename);
            nodes.add(textNode);
            blockNode = this.initBlock(textToken.getStartLineNumber(), nodes);
        } else if (this.peek() instanceof Filter) {
            LinkedList<Node> nodes = new LinkedList<Node>();
            nodes.add(this.parseFilter());
            blockNode = this.initBlock(filterToken.getStartLineNumber(), nodes);
        } else {
            BlockNode textBlock = this.parseTextBlock();
            blockNode = textBlock != null ? textBlock : this.emptyBlock(filterToken.getStartLineNumber());
        }
        node.setBlock(blockNode);
        return node;
    }

    private Token lookahead(int i) {
        return this.lexer.lookahead(i);
    }

    private Token peek() {
        return this.lookahead(0);
    }

    private Token advance() {
        return this.lexer.advance();
    }

    private void defer(Token token) {
        this.lexer.defer(token);
    }

    private Token accept(Class clazz) {
        if (this.peek().getClass().equals(clazz)) {
            return this.lexer.advance();
        }
        return null;
    }

    private int line() {
        return this.lexer.getLineno();
    }

    private Token expect(Class expectedTokenClass) {
        Token t = this.peek();
        if (t.getClass().equals(expectedTokenClass)) {
            return this.advance();
        }
        throw this.error("INVALID_TOKEN", "expected \"" + expectedTokenClass.toString() + "\", but got " + this.peek().getType() + "\"", this.peek());
    }

    public LinkedHashMap<String, BlockNode> getBlocks() {
        return this.blocks;
    }

    public void setBlocks(LinkedHashMap<String, BlockNode> blocks) {
        this.blocks = blocks;
    }

    public LinkedList<Parser> getContexts() {
        return this.contexts;
    }

    public void setContexts(LinkedList<Parser> contexts) {
        this.contexts = contexts;
    }

    public void setMixins(HashMap mixins) {
        this.mixins = mixins;
    }
}

