/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.template;

import de.neuland.pug4j.exceptions.PugTemplateLoaderException;
import de.neuland.pug4j.template.TemplateLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;

public class FileTemplateLoader
implements TemplateLoader {
    private Charset encoding = StandardCharsets.UTF_8;
    private String templateLoaderPath = "";
    private String extension = "pug";
    private String basePath = "";

    public FileTemplateLoader() {
    }

    public FileTemplateLoader(Charset encoding) {
        this.encoding = encoding;
    }

    public FileTemplateLoader(Charset encoding, String extension) {
        this(encoding);
        this.extension = extension;
    }

    public FileTemplateLoader(String templateLoaderPath) {
        if (!Files.isDirectory(Paths.get(templateLoaderPath, new String[0]), new LinkOption[0])) {
            throw new PugTemplateLoaderException("Directory '" + templateLoaderPath + "' does not exist.");
        }
        this.templateLoaderPath = templateLoaderPath.endsWith("/") ? templateLoaderPath : templateLoaderPath + "/";
    }

    public FileTemplateLoader(String templateLoaderPath, Charset encoding) {
        this(templateLoaderPath);
        this.encoding = encoding;
    }

    public FileTemplateLoader(String templateLoaderPath, String extension) {
        this(templateLoaderPath);
        this.extension = extension;
    }

    public FileTemplateLoader(String templateLoaderPath, Charset encoding, String extension) {
        this(templateLoaderPath, extension);
        this.encoding = encoding;
    }

    @Override
    public long getLastModified(String name) {
        File templateSource = this.getFile(name);
        return templateSource.lastModified();
    }

    @Override
    public Reader getReader(String name) throws IOException {
        if (name == null) {
            throw new IllegalArgumentException("Filename not provided!");
        }
        name = this.ensurePugExtension(name);
        File templateSource = this.getFile(name);
        return new InputStreamReader((InputStream)new FileInputStream(templateSource), this.encoding);
    }

    private String ensurePugExtension(String templateName) {
        if (StringUtils.isBlank((CharSequence)FilenameUtils.getExtension((String)templateName))) {
            return templateName + "." + this.getExtension();
        }
        return templateName;
    }

    private File getFile(String name) {
        if (!StringUtils.isBlank((CharSequence)this.templateLoaderPath)) {
            if (Paths.get(name, new String[0]).isAbsolute()) {
                return Paths.get(this.templateLoaderPath + this.basePath + name.substring(1), new String[0]).toFile();
            }
            return Paths.get(this.templateLoaderPath, new String[0]).resolve(name).toFile();
        }
        return Paths.get(name, new String[0]).toFile();
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getBase() {
        return this.basePath;
    }

    public void setBase(String basePath) {
        this.basePath = basePath.endsWith("/") ? basePath : basePath + "/";
    }
}

