/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;

public class ExpressionNode
extends Node {
    private boolean escape;
    private boolean buffer;
    private boolean inline;
    private String bufferedExpressionString = "";
    private String nodeId = this.createNodeId();

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setBuffer(boolean buffer) {
        this.buffer = buffer;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    private String createNodeId() {
        return UUID.randomUUID().toString().replace("-", "");
    }

    public String getBufferedExpressionString() {
        return this.bufferedExpressionString;
    }

    public void setBufferedExpressionString(String bufferedExpressionString) {
        this.bufferedExpressionString = bufferedExpressionString;
    }

    @Override
    public void execute(IndentWriter writer, PugModel model, PugTemplate template) throws PugCompilerException {
        String value = this.getValue();
        if (this.hasBlock()) {
            String pug4j_buffer = this.bufferedExpressionString;
            value = pug4j_buffer.length() == 0 ? this.getValue() : pug4j_buffer + " " + this.getValue();
            model.put("pug4j__innerblock_" + this.nodeId, (Object)this.block);
            model.put("pug4j__template_" + this.nodeId, (Object)template);
            model.put("pug4j__model", (Object)model);
            model.put("pug4j__writer", (Object)writer);
            this.bufferedExpressionString = value + "{" + "pug4j__" + "model.pushScope();" + "pug4j__" + "innerblock_" + this.nodeId + ".execute(" + "pug4j__" + "writer," + "pug4j__" + "model,pug4j__template_" + this.nodeId + ");" + "pug4j__" + "model.popScope();}";
        } else {
            String expressionValue;
            Object result = null;
            try {
                result = template.getExpressionHandler().evaluateExpression(value, model);
            }
            catch (ExpressionException e) {
                throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
            }
            if (result == null || !this.buffer) {
                return;
            }
            if (result.getClass().isArray()) {
                Object[] resultArray = (Object[])result;
                expressionValue = StringUtils.joinWith((String)",", (Object[])resultArray);
            } else if (result instanceof List) {
                List resultArray = (List)result;
                expressionValue = StringUtils.joinWith((String)",", (Object[])resultArray.toArray());
            } else {
                expressionValue = result instanceof Map ? new LinkedHashMap((Map)result).toString() : result.toString();
            }
            if (this.escape) {
                expressionValue = StringEscapeUtils.escapeHtml4((String)expressionValue);
            }
            writer.append(expressionValue);
        }
    }

    @Override
    public void setValue(String value) {
        super.setValue(value.trim());
    }
}

