/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.expression;

import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.expression.AbstractExpressionHandler;
import de.neuland.pug4j.expression.BooleanUtil;
import de.neuland.pug4j.expression.JexlExpressionHandler;
import de.neuland.pug4j.model.PugModel;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.Engine;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;

public class GraalJsExpressionHandler
extends AbstractExpressionHandler {
    JexlExpressionHandler jexlExpressionHandler = new JexlExpressionHandler();
    final HostAccess all = HostAccess.newBuilder().allowPublicAccess(true).allowAllImplementations(true).allowArrayAccess(true).allowListAccess(true).build();
    final Engine engine = Engine.newBuilder().option("engine.WarnInterpreterOnly", "false").allowExperimentalOptions(true).build();
    final ThreadLocal<Map<String, Value>> cacheThreadLocal = ThreadLocal.withInitial(new Supplier<Map<String, Value>>(){

        @Override
        public Map<String, Value> get() {
            return new ConcurrentHashMap<String, Value>();
        }
    });
    final ThreadLocal<Context> contextThreadLocal = ThreadLocal.withInitial(new Supplier<Context>(){

        @Override
        public Context get() {
            Context context = Context.newBuilder((String[])new String[]{"js"}).engine(GraalJsExpressionHandler.this.engine).allowHostAccess(GraalJsExpressionHandler.this.all).allowAllAccess(true).allowHostClassLookup(s -> true).allowPolyglotAccess(PolyglotAccess.ALL).build();
            context.initialize("js");
            return context;
        }
    });

    @Override
    public Boolean evaluateBooleanExpression(String expression, PugModel model) throws ExpressionException {
        return BooleanUtil.convert(this.evaluateExpression(expression, model));
    }

    @Override
    public Object evaluateExpression(String expression, PugModel model) throws ExpressionException {
        Context context = this.contextThreadLocal.get();
        Map<String, Value> cache = this.cacheThreadLocal.get();
        context.enter();
        try {
            Value eval;
            this.saveLocalVariableName(expression, model);
            Value jsContextBindings = context.getBindings("js");
            for (Map.Entry<String, Object> objectEntry : model.entrySet()) {
                String key = objectEntry.getKey();
                if ("pug4j__localVars".equals(key)) continue;
                Object value = this.jsValue(objectEntry);
                jsContextBindings.putMember(key, value);
            }
            Source js = expression.startsWith("{") ? Source.create((String)"js", (CharSequence)("(" + expression + ")")) : Source.create((String)"js", (CharSequence)expression);
            Value value = cache.get(expression);
            if (value != null) {
                eval = value.execute(new Object[0]);
            } else {
                eval = context.parse(js);
                cache.put(expression, eval);
                eval = eval.execute(new Object[0]);
            }
            Set memberKeys = jsContextBindings.getMemberKeys();
            for (String memberKey : memberKeys) {
                if (!model.knowsKey(memberKey) || memberKey.startsWith("pug4j__")) continue;
                Value member = jsContextBindings.getMember(memberKey);
                model.put(memberKey, this.javaValue(member));
                jsContextBindings.putMember(memberKey, null);
            }
            Object object = this.javaValue(eval);
            return object;
        }
        catch (Exception ex) {
            if (ex.getMessage().startsWith("ReferenceError:")) {
                Object var6_8 = null;
                return var6_8;
            }
            throw new ExpressionException(expression, ex);
        }
        finally {
            context.leave();
        }
    }

    private Object jsValue(Map.Entry<String, Object> objectEntry) {
        Object value = objectEntry.getValue();
        if (!objectEntry.getKey().startsWith("pug4j__") && !(objectEntry.getValue() instanceof PugModel)) {
            if (value instanceof Map) {
                value = ProxyObject.fromMap((Map)((Map)value));
            }
            if (value instanceof List) {
                value = ProxyArray.fromList((List)((List)value));
            }
        }
        return value;
    }

    private Object javaValue(Value eval) {
        if (eval.isNull()) {
            return null;
        }
        if (eval.isBoolean()) {
            return eval.asBoolean();
        }
        if (eval.isString()) {
            return eval.asString();
        }
        if (eval.isNumber()) {
            if (eval.fitsInByte()) {
                return eval.asByte();
            }
            if (eval.fitsInShort()) {
                return eval.asShort();
            }
            if (eval.fitsInInt()) {
                return eval.asInt();
            }
            if (eval.fitsInLong()) {
                return eval.asLong();
            }
            if (eval.fitsInFloat()) {
                return Float.valueOf(eval.asFloat());
            }
            if (eval.fitsInDouble()) {
                return eval.asDouble();
            }
        }
        if (eval.isInstant()) {
            return eval.asInstant();
        }
        if (eval.isDate()) {
            return eval.asDate();
        }
        if (eval.isDuration()) {
            return eval.asDuration();
        }
        if (eval.isTime()) {
            return eval.asTime();
        }
        if (eval.isTimeZone()) {
            return eval.asTimeZone();
        }
        if (eval.isHostObject()) {
            return eval.asHostObject();
        }
        if (eval.isMetaObject()) {
            return eval;
        }
        if (eval.hasArrayElements()) {
            return eval.as(List.class);
        }
        if (eval.hasMembers()) {
            return new LinkedHashMap((Map)eval.as(Map.class));
        }
        return null;
    }

    @Override
    public String evaluateStringExpression(String expression, PugModel model) throws ExpressionException {
        Object result = this.evaluateExpression(expression, model);
        return result == null ? "" : result.toString();
    }

    @Override
    public void assertExpression(String expression) throws ExpressionException {
        this.jexlExpressionHandler.assertExpression(expression);
    }

    @Override
    public void setCache(boolean cache) {
    }

    @Override
    public void clearCache() {
    }
}

