/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.template;

import de.neuland.pug4j.template.TemplateLoader;
import java.io.IOException;
import java.io.Reader;

public class ReaderTemplateLoader
implements TemplateLoader {
    private final Reader reader;
    private final String name;
    private String extension = "pug";

    public ReaderTemplateLoader(Reader reader, String name) {
        this.reader = reader;
        this.name = name;
    }

    public ReaderTemplateLoader(Reader reader, String name, String extension) {
        this.reader = reader;
        this.name = name;
        this.extension = extension;
    }

    @Override
    public long getLastModified(String name) throws IOException {
        this.checkName(name);
        return -1L;
    }

    @Override
    public Reader getReader(String name) throws IOException {
        this.checkName(name);
        return this.reader;
    }

    private void checkName(String name) {
        String nameOfParamWithoutExtension = this.getNameWithoutExtension(name);
        String nameOfObjectWithoutExtension = this.getNameWithoutExtension(this.name);
        if (!nameOfObjectWithoutExtension.equals(nameOfParamWithoutExtension)) {
            throw new RuntimeException("This reader only responds to [" + this.name + "] template. You should not reference other templates if using ReaderTemplateLoader, because multiple template loaders are currently not supported. Maybe you could use a FileTemplateLoader?");
        }
    }

    private String getNameWithoutExtension(String name) {
        return name.endsWith("." + this.extension) ? name.substring(0, name.lastIndexOf("." + this.extension)) : name;
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getBase() {
        return "";
    }
}

