/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.FilterNode;
import de.neuland.pug4j.parser.node.LiteralNode;
import de.neuland.pug4j.parser.node.TextNode;
import de.neuland.pug4j.template.PugTemplate;
import java.util.LinkedList;

public abstract class Node
implements Cloneable {
    protected LinkedList<Node> nodes = new LinkedList();
    protected int lineNumber;
    protected int column;
    protected String name;
    protected String value;
    protected Node block;
    protected String fileName;

    protected boolean isTextNode(Node node) {
        return node instanceof TextNode || node instanceof LiteralNode || node instanceof FilterNode && node.hasBlock() && node.getBlock().getNodes().size() > 0;
    }

    public abstract void execute(IndentWriter var1, PugModel var2, PugTemplate var3) throws PugCompilerException;

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void push(Node node) {
        if (node == null) {
            throw new RuntimeException();
        }
        this.nodes.add(node);
    }

    public LinkedList<Node> getNodes() {
        return this.nodes;
    }

    public void setNodes(LinkedList<Node> nodes) {
        this.nodes = nodes;
    }

    public Node pollNode() {
        return this.nodes.isEmpty() ? null : this.nodes.poll();
    }

    public boolean hasNodes() {
        return !this.nodes.isEmpty();
    }

    public boolean hasBlock() {
        return this.block != null;
    }

    public Node getBlock() {
        return this.block;
    }

    public void setBlock(Node block) {
        this.block = block;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Node clone() throws CloneNotSupportedException {
        Node clone = (Node)super.clone();
        if (this.block != null) {
            clone.block = this.block.clone();
        }
        clone.nodes = new LinkedList();
        for (Node node : this.nodes) {
            clone.nodes.add(node.clone());
        }
        return clone;
    }

    public void setColumn(int startColumn) {
        this.column = startColumn;
    }

    public int getColumn() {
        return this.column;
    }
}

