/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.compiler.Utils;
import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.expression.ExpressionHandler;
import de.neuland.pug4j.filter.Filter;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.Attr;
import de.neuland.pug4j.parser.node.AttrsNode;
import de.neuland.pug4j.parser.node.ExpressionString;
import de.neuland.pug4j.parser.node.IncludeFilterNode;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;

public class FilterNode
extends AttrsNode {
    private LinkedList<IncludeFilterNode> filters = new LinkedList();

    @Override
    public void execute(IndentWriter writer, PugModel model, PugTemplate template) throws PugCompilerException {
        ArrayList<String> values = new ArrayList<String>();
        LinkedList<Node> nodes = this.block.getNodes();
        for (Node node : nodes) {
            values.add(node.getValue());
        }
        ExpressionHandler expressionHandler = template.getExpressionHandler();
        String result = StringUtils.join(values, (String)"");
        Filter filter = model.getFilter(this.getValue());
        if (filter != null) {
            result = filter.convert(result, this.convertToFilterAttributes(template, model, this.attributes), model);
        }
        for (IncludeFilterNode filterValue : this.filters) {
            filter = model.getFilter(filterValue.getValue());
            if (filter == null) continue;
            result = filter.convert(result, this.convertToFilterAttributes(template, model, filterValue.getAttributes()), model);
        }
        try {
            result = Utils.interpolate(result, model, false, expressionHandler);
        }
        catch (ExpressionException e) {
            throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
        }
        writer.append(result);
    }

    private Map<String, Object> convertToFilterAttributes(PugTemplate template, PugModel model, LinkedList<Attr> attributes) {
        HashMap<String, Object> evaluatedAttributes = new HashMap<String, Object>();
        for (Attr attribute : attributes) {
            if (attribute.getValue() instanceof ExpressionString) {
                try {
                    evaluatedAttributes.put(attribute.getName(), template.getExpressionHandler().evaluateExpression(((ExpressionString)attribute.getValue()).getValue(), model));
                    continue;
                }
                catch (ExpressionException e) {
                    throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
                }
            }
            evaluatedAttributes.put(attribute.getName(), attribute.getValue());
        }
        return evaluatedAttributes;
    }

    public void setFilter(LinkedList<IncludeFilterNode> filters) {
        this.filters = filters;
    }

    public boolean hasFilters() {
        return this.filters.size() > 0;
    }
}

