/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.Parser;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.parser.node.TagNode;
import de.neuland.pug4j.template.PugTemplate;
import java.util.ArrayList;
import java.util.Collection;

public class BlockNode
extends Node {
    private boolean yield = false;
    private String mode;
    private Collection<? extends Node> prepended = new ArrayList<Node>();
    private Collection<? extends Node> appended = new ArrayList<Node>();
    private Parser parser;
    private boolean subBlock;
    private boolean namedBlock;

    @Override
    public void execute(IndentWriter writer, PugModel model, PugTemplate template) throws PugCompilerException {
        if (writer.isPp() && this.getNodes().size() > 1 && !writer.isEscape() && this.isTextNode(this.getNodes().get(0)) && this.isTextNode(this.getNodes().get(1))) {
            writer.prettyIndent(1, true);
        }
        for (int i = 0; i < this.getNodes().size(); ++i) {
            if (writer.isPp() && i > 0 && !writer.isEscape() && this.isTextNode(this.getNodes().get(i)) && this.isTextNode(this.getNodes().get(i - 1)) && this.getNodes().get(i - 1).getValue() != null && this.getNodes().get(i - 1).getValue().contains("\n")) {
                writer.prettyIndent(1, false);
            }
            this.getNodes().get(i).execute(writer, model, template);
        }
    }

    public void setYield(boolean yield) {
        this.yield = yield;
    }

    public boolean isYield() {
        return this.yield;
    }

    public BlockNode getYieldBlock() {
        BlockNode ret = this;
        for (Node node : this.getNodes()) {
            if (node instanceof BlockNode && ((BlockNode)node).isYield()) {
                return (BlockNode)node;
            }
            if (node instanceof TagNode && ((TagNode)node).isTextOnly()) continue;
            if (node instanceof BlockNode && ((BlockNode)node).getYieldBlock() != null) {
                ret = ((BlockNode)node).getYieldBlock();
            } else if (node.hasBlock()) {
                ret = ((BlockNode)node.getBlock()).getYieldBlock();
            }
            if (!(ret instanceof BlockNode) || !ret.isYield()) continue;
            return ret;
        }
        return ret;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Collection<? extends Node> getPrepended() {
        return this.prepended;
    }

    public void setPrepended(Collection<? extends Node> prepended) {
        this.prepended = prepended;
    }

    public Collection<? extends Node> getAppended() {
        return this.appended;
    }

    public void setAppended(Collection<? extends Node> appended) {
        this.appended = appended;
    }

    public void setParser(Parser parser) {
        this.parser = parser;
    }

    public Parser getParser() {
        return this.parser;
    }

    public void setSubBlock(boolean subBlock) {
        this.subBlock = subBlock;
    }

    public boolean isSubBlock() {
        return this.subBlock;
    }

    public boolean isNamedBlock() {
        return this.namedBlock;
    }

    public void setNamedBlock(boolean namedBlock) {
        this.namedBlock = namedBlock;
    }
}

