/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser;

import de.neuland.pug4j.exceptions.PugTemplateLoaderException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathHelper {
    public String resolvePath(String parentFileName, String templateName, String basePathString) {
        if (Paths.get(basePathString, new String[0]).isAbsolute()) {
            throw new PugTemplateLoaderException("basePath " + basePathString + " must be relative");
        }
        if (Paths.get(parentFileName, new String[0]).isAbsolute() && basePathString.length() > 0) {
            parentFileName = Paths.get(basePathString + parentFileName.substring(1), new String[0]).normalize().toString();
        }
        if (Paths.get(templateName, new String[0]).isAbsolute() && basePathString.length() > 0) {
            return Paths.get(basePathString + templateName.substring(1), new String[0]).normalize().toString();
        }
        Path parent = Paths.get(parentFileName, new String[0]).getParent();
        if (parent == null) {
            return templateName;
        }
        Path resolve = parent.resolve(Paths.get(templateName, new String[0])).normalize();
        return resolve.toString();
    }
}

