/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.filter;

import de.neuland.pug4j.filter.Filter;
import java.util.LinkedHashMap;
import java.util.Map;

public abstract class CachingFilter
implements Filter {
    private static final int MAX_ENTRIES = 1000;
    private static Map<String, String> cache = new LinkedHashMap<String, String>(1001, 0.75f, true){
        private static final long serialVersionUID = 618942552777647107L;

        @Override
        public boolean removeEldestEntry(Map.Entry<String, String> eldest) {
            return this.size() > 1000;
        }
    };

    @Override
    public String convert(String source, Map<String, Object> attributes, Map<String, Object> model) {
        String key = source.hashCode() + "-" + attributes.hashCode();
        if (!cache.containsKey(key)) {
            cache.put(key, this.convert(source, attributes));
        }
        return cache.get(key);
    }

    protected abstract String convert(String var1, Map<String, Object> var2);
}

