/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.expression;

import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.expression.AbstractExpressionHandler;
import de.neuland.pug4j.expression.BooleanUtil;
import de.neuland.pug4j.expression.JexlExpressionHandler;
import de.neuland.pug4j.model.PugModel;
import java.util.Map;
import javax.script.Bindings;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import jdk.nashorn.api.scripting.ScriptObjectMirror;

public class NashornExpressionHandler
extends AbstractExpressionHandler {
    JexlExpressionHandler jexlExpressionHandler = new JexlExpressionHandler();
    ScriptEngineManager mgr = new ScriptEngineManager();
    ScriptEngine jsEngine = this.mgr.getEngineByName("Nashorn");

    @Override
    public Boolean evaluateBooleanExpression(String expression, PugModel model) throws ExpressionException {
        return BooleanUtil.convert(this.evaluateExpression(expression, model));
    }

    @Override
    public Object evaluateExpression(String expression, PugModel model) throws ExpressionException {
        try {
            this.saveNonLocalVarAssignmentInModel(expression, model);
            Bindings bindings = this.jsEngine.createBindings();
            bindings.putAll(model);
            Object eval = expression.startsWith("{") ? ((Map)this.jsEngine.eval("[" + expression + "]", bindings)).get("0") : this.jsEngine.eval(expression, bindings);
            for (Map.Entry stringObjectEntry : bindings.entrySet()) {
                String key = (String)stringObjectEntry.getKey();
                if ("locals".equals(key) || "nonLocalVars".equals(key)) continue;
                model.put(key, this.convertToPugModelValue(stringObjectEntry.getValue()));
            }
            return this.convertToPugModelValue(eval);
        }
        catch (ScriptException ex) {
            throw new ExpressionException(expression, ex);
        }
    }

    private Object convertToPugModelValue(Object eval) {
        ScriptObjectMirror mirror;
        String s;
        if (eval == null) {
            return null;
        }
        if (eval instanceof Double && (s = String.valueOf(eval)).endsWith(".0")) {
            return Integer.valueOf(s.substring(0, s.length() - 2));
        }
        if (eval instanceof ScriptObjectMirror && (mirror = (ScriptObjectMirror)eval).isArray()) {
            return this.toArray(mirror);
        }
        return eval;
    }

    private Object toArray(ScriptObjectMirror mirror) {
        ScriptObjectMirror innerMirror;
        Object[] array = new Object[mirror.size()];
        if (mirror.isEmpty()) {
            return array;
        }
        boolean multiDimensional = false;
        if (mirror.get((Object)"0") instanceof ScriptObjectMirror && (innerMirror = (ScriptObjectMirror)mirror.get((Object)"0")).isArray()) {
            multiDimensional = true;
        }
        for (int i = 0; i < mirror.size(); ++i) {
            Object value = mirror.get((Object)(i + ""));
            array[i] = multiDimensional ? this.toArray((ScriptObjectMirror)value) : value;
        }
        return array;
    }

    @Override
    public String evaluateStringExpression(String expression, PugModel model) throws ExpressionException {
        Object result = this.evaluateExpression(expression, model);
        return result == null ? "" : result.toString();
    }

    @Override
    public void assertExpression(String expression) throws ExpressionException {
        this.jexlExpressionHandler.assertExpression(expression);
    }

    @Override
    public void setCache(boolean cache) {
    }

    @Override
    public void clearCache() {
    }
}

