/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.expression;

import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.expression.AbstractExpressionHandler;
import de.neuland.pug4j.expression.BooleanUtil;
import de.neuland.pug4j.model.PugModel;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.jexl3.JexlContext;
import org.apache.commons.jexl3.JexlEngine;
import org.apache.commons.jexl3.JexlScript;
import org.apache.commons.jexl3.MapContext;
import org.apache.commons.jexl3.internal.PugJexlEngine;

public class JexlExpressionHandler
extends AbstractExpressionHandler {
    private static final int MAX_ENTRIES = 5000;
    public static Pattern plusplus = Pattern.compile("([a-zA-Z0-9-_]*[a-zA-Z0-9])\\+\\+\\s*;{0,1}\\s*$");
    public static Pattern isplusplus = Pattern.compile("\\+\\+\\s*;{0,1}\\s*$");
    public static Pattern minusminus = Pattern.compile("([a-zA-Z0-9-_]*[a-zA-Z0-9])--\\s*;{0,1}\\s*$");
    public static Pattern isminusminus = Pattern.compile("--\\s*;{0,1}\\s*$");
    private JexlEngine jexl = new PugJexlEngine(5000);

    @Override
    public Boolean evaluateBooleanExpression(String expression, PugModel model) throws ExpressionException {
        return BooleanUtil.convert(this.evaluateExpression(expression, model));
    }

    @Override
    public Object evaluateExpression(String expression, PugModel model) throws ExpressionException {
        try {
            this.saveNonLocalVarAssignmentInModel(expression, model);
            expression = this.removeVar(expression);
            if (isplusplus.matcher(expression).find()) {
                expression = this.convertPlusPlusExpression(expression);
            }
            if (isminusminus.matcher(expression).find()) {
                expression = this.convertMinusMinusExpression(expression);
            }
            JexlScript e = this.jexl.createScript(expression);
            MapContext jexlContext = new MapContext((Map)model);
            Object evaluate = e.execute((JexlContext)jexlContext);
            return evaluate;
        }
        catch (Exception e) {
            throw new ExpressionException(expression, e);
        }
    }

    private String convertMinusMinusExpression(String expression) {
        Matcher matcher = minusminus.matcher(expression);
        if (matcher.find(0) && matcher.groupCount() == 1) {
            String a = matcher.group(1);
            expression = a + " = " + a + " - 1";
        }
        return expression;
    }

    private String convertPlusPlusExpression(String expression) {
        Matcher matcher = plusplus.matcher(expression);
        if (matcher.find(0) && matcher.groupCount() == 1) {
            String a = matcher.group(1);
            expression = a + " = " + a + " + 1";
        }
        return expression;
    }

    private String removeVar(String expression) {
        expression = expression.replace("var ", ";");
        return expression;
    }

    @Override
    public void assertExpression(String expression) throws ExpressionException {
        try {
            this.jexl.createExpression(expression);
        }
        catch (Exception e) {
            throw new ExpressionException(expression, e);
        }
    }

    @Override
    public String evaluateStringExpression(String expression, PugModel model) throws ExpressionException {
        Object result = this.evaluateExpression(expression, model);
        return result == null ? "" : result.toString();
    }

    @Override
    public void setCache(boolean cache) {
        this.jexl = new PugJexlEngine(cache ? 5000 : 0);
    }

    @Override
    public void clearCache() {
        this.jexl.clearCache();
    }
}

