/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import org.apache.commons.lang3.StringEscapeUtils;

public class ExpressionNode
extends Node {
    private boolean escape;
    private boolean buffer;
    private boolean inline;

    public void setEscape(boolean escape) {
        this.escape = escape;
    }

    public void setBuffer(boolean buffer) {
        this.buffer = buffer;
    }

    public boolean isInline() {
        return this.inline;
    }

    public void setInline(boolean inline) {
        this.inline = inline;
    }

    @Override
    public void execute(IndentWriter writer, PugModel model, PugTemplate template) throws PugCompilerException {
        try {
            Object result = template.getExpressionHandler().evaluateExpression(this.getValue(), model);
            if (result == null || !this.buffer) {
                return;
            }
            String string = result.toString();
            if (this.escape) {
                string = StringEscapeUtils.escapeHtml4((String)string);
            }
            writer.append(string);
            if (this.hasBlock()) {
                writer.increment();
                this.block.execute(writer, model, template);
                writer.decrement();
                writer.newline();
            }
        }
        catch (ExpressionException e) {
            throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
        }
    }

    @Override
    public void setValue(String value) {
        super.setValue(value.trim());
    }
}

