/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser;

import de.neuland.pug4j.exceptions.PugTemplateLoaderException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathHelper {
    public String resolvePath(String parentFileName, String templateName, String basePathString) {
        if (basePathString.startsWith("/")) {
            throw new PugTemplateLoaderException("basePath " + basePathString + " must be relative");
        }
        if (parentFileName.startsWith("/")) {
            parentFileName = Paths.get(basePathString + parentFileName.substring(1), new String[0]).normalize().toString();
        }
        if (templateName.startsWith("/")) {
            return Paths.get(basePathString + templateName.substring(1), new String[0]).normalize().toString();
        }
        Path parent = Paths.get(parentFileName, new String[0]).getParent();
        if (parent == null) {
            return templateName;
        }
        Path resolve = parent.resolve(Paths.get(templateName, new String[0])).normalize();
        return resolve.toString();
    }

    private String resolveAbsolutePath(String filename, String basePath) {
        if (Paths.get(filename, new String[0]).isAbsolute()) {
            return filename;
        }
        if (!Paths.get(basePath, new String[0]).isAbsolute()) {
            throw new PugTemplateLoaderException("Can't resolve absolute path for '" + filename + "' if basePath has not been set.");
        }
        return Paths.get(basePath, new String[0]).resolve(filename).normalize().toString();
    }
}

