/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.expression;

import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.expression.AbstractExpressionHandler;
import de.neuland.pug4j.expression.BooleanUtil;
import de.neuland.pug4j.expression.JexlExpressionHandler;
import de.neuland.pug4j.model.PugModel;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.graalvm.polyglot.Context;
import org.graalvm.polyglot.HostAccess;
import org.graalvm.polyglot.PolyglotAccess;
import org.graalvm.polyglot.Source;
import org.graalvm.polyglot.Value;
import org.graalvm.polyglot.proxy.ProxyArray;
import org.graalvm.polyglot.proxy.ProxyObject;

public class GraalJsExpressionHandler
extends AbstractExpressionHandler {
    JexlExpressionHandler jexlExpressionHandler = new JexlExpressionHandler();
    Context jsContext;

    public GraalJsExpressionHandler() {
        HostAccess all = HostAccess.newBuilder().allowPublicAccess(true).allowAllImplementations(true).allowArrayAccess(true).allowListAccess(true).build();
        this.jsContext = Context.newBuilder((String[])new String[]{"js"}).allowHostAccess(all).allowAllAccess(true).allowExperimentalOptions(true).allowHostClassLookup(s -> true).allowPolyglotAccess(PolyglotAccess.ALL).build();
    }

    @Override
    public Boolean evaluateBooleanExpression(String expression, PugModel model) throws ExpressionException {
        return BooleanUtil.convert(this.evaluateExpression(expression, model));
    }

    @Override
    public Object evaluateExpression(String expression, PugModel model) throws ExpressionException {
        try {
            this.saveNonLocalVarAssignmentInModel(expression, model);
            Value jsContextBindings = this.jsContext.getBindings("js");
            for (Map.Entry<String, Object> objectEntry : model.entrySet()) {
                String key = objectEntry.getKey();
                if ("locals".equals(key) || "nonLocalVars".equals(key)) continue;
                Object value = objectEntry.getValue();
                if (value instanceof Map) {
                    value = ProxyObject.fromMap((Map)((Map)value));
                }
                if (value instanceof List) {
                    value = ProxyArray.fromList((List)((List)value));
                }
                jsContextBindings.putMember(key, value);
            }
            Source js = expression.startsWith("{") ? Source.create((String)"js", (CharSequence)("(" + expression + ")")) : Source.create((String)"js", (CharSequence)expression);
            Value eval = this.jsContext.eval(js);
            Set memberKeys = jsContextBindings.getMemberKeys();
            for (String memberKey : memberKeys) {
                Value member = jsContextBindings.getMember(memberKey);
                model.put(memberKey, this.convertToPugModelValue(member));
            }
            return this.convertToPugModelValue(eval);
        }
        catch (Exception ex) {
            throw new ExpressionException(expression, ex);
        }
    }

    private Object convertToPugModelValue(Value eval) {
        if (eval.isNull()) {
            return null;
        }
        if (eval.hasArrayElements()) {
            return eval.as(List.class);
        }
        if (eval.fitsInInt()) {
            return eval.asInt();
        }
        if (eval.hasMembers()) {
            return eval.as(Map.class);
        }
        if (eval.fitsInDouble() && !eval.fitsInInt()) {
            return eval.asDouble();
        }
        if (eval.isString()) {
            return eval.asString();
        }
        if (eval.isBoolean()) {
            return eval.asBoolean();
        }
        return eval;
    }

    @Override
    public String evaluateStringExpression(String expression, PugModel model) throws ExpressionException {
        Object result = this.evaluateExpression(expression, model);
        return result == null ? "" : result.toString();
    }

    @Override
    public void assertExpression(String expression) throws ExpressionException {
        this.jexlExpressionHandler.assertExpression(expression);
    }

    @Override
    public void setCache(boolean cache) {
    }

    @Override
    public void clearCache() {
    }
}

