/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.template;

import de.neuland.pug4j.exceptions.PugTemplateLoaderException;
import de.neuland.pug4j.template.TemplateLoader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Paths;

public class FileTemplateLoader
implements TemplateLoader {
    private Charset encoding = StandardCharsets.UTF_8;
    private String basePath = "";
    private String extension = "pug";

    public FileTemplateLoader() {
    }

    public FileTemplateLoader(Charset encoding) {
        this.encoding = encoding;
    }

    public FileTemplateLoader(Charset encoding, String extension) {
        this(encoding);
        this.extension = extension;
    }

    public FileTemplateLoader(String basePath) {
        if (!Files.isDirectory(Paths.get(basePath, new String[0]), new LinkOption[0])) {
            throw new PugTemplateLoaderException("Directory '" + basePath + "' does not exist.");
        }
        this.basePath = basePath;
    }

    public FileTemplateLoader(String basePath, Charset encoding) {
        this(basePath);
        this.encoding = encoding;
    }

    public FileTemplateLoader(String basePath, String extension) {
        this(basePath);
        this.extension = extension;
    }

    public FileTemplateLoader(String basePath, Charset encoding, String extension) {
        this(basePath, extension);
        this.encoding = encoding;
    }

    @Override
    public long getLastModified(String name) {
        File templateSource = this.getFile(name);
        return templateSource.lastModified();
    }

    @Override
    public Reader getReader(String name) throws IOException {
        File templateSource = this.getFile(name);
        return new InputStreamReader((InputStream)new FileInputStream(templateSource), this.encoding);
    }

    private File getFile(String name) {
        if (Paths.get(name, new String[0]).isAbsolute()) {
            return Paths.get(name, new String[0]).toFile();
        }
        return Paths.get(this.basePath, new String[0]).resolve(name).toFile();
    }

    @Override
    public String getExtension() {
        return this.extension;
    }

    @Override
    public String getBasePath() {
        return this.basePath;
    }
}

