/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser.node;

import de.neuland.pug4j.compiler.IndentWriter;
import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugCompilerException;
import de.neuland.pug4j.expression.ExpressionHandler;
import de.neuland.pug4j.model.PugModel;
import de.neuland.pug4j.parser.node.CaseConditionNode;
import de.neuland.pug4j.parser.node.Node;
import de.neuland.pug4j.template.PugTemplate;
import java.util.LinkedList;
import java.util.List;

public class CaseNode
extends Node {
    private List<CaseConditionNode> caseConditionNodes = new LinkedList<CaseConditionNode>();

    @Override
    public void execute(IndentWriter writer, PugModel model, PugTemplate template) throws PugCompilerException {
        try {
            boolean skip = false;
            for (Node when : this.block.getNodes()) {
                if (!skip && !"default".equals(when.getValue()) && !this.checkCondition(model, when, template.getExpressionHandler()).booleanValue()) continue;
                skip = false;
                if (when.getBlock() != null) {
                    when.execute(writer, model, template);
                    break;
                }
                skip = true;
            }
        }
        catch (ExpressionException e) {
            throw new PugCompilerException((Node)this, template.getTemplateLoader(), e);
        }
    }

    private Boolean checkCondition(PugModel model, Node caseConditionNode, ExpressionHandler expressionHandler) throws ExpressionException {
        return expressionHandler.evaluateBooleanExpression(this.value + " == " + caseConditionNode.getValue(), model);
    }

    public void setConditions(List<CaseConditionNode> caseConditionNodes) {
        this.caseConditionNodes = caseConditionNodes;
    }

    public List<CaseConditionNode> getCaseConditionNodes() {
        return this.caseConditionNodes;
    }

    @Override
    public CaseNode clone() throws CloneNotSupportedException {
        CaseNode clone = (CaseNode)super.clone();
        clone.caseConditionNodes = new LinkedList<CaseConditionNode>();
        for (CaseConditionNode condition : this.caseConditionNodes) {
            clone.caseConditionNodes.add((CaseConditionNode)condition.clone());
        }
        return clone;
    }

    public static class When
    extends Node {
        @Override
        public void execute(IndentWriter writer, PugModel model, PugTemplate template) throws PugCompilerException {
            this.block.execute(writer, model, template);
        }
    }
}

