/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.parser;

import de.neuland.pug4j.exceptions.PugTemplateLoaderException;
import java.nio.file.Path;
import java.nio.file.Paths;

public class PathHelper {
    public String resolvePath(String parentFileName, String templateName, String basePathString) {
        if (!Paths.get(parentFileName, new String[0]).isAbsolute()) {
            parentFileName = this.resolveAbsolutePath(parentFileName, basePathString);
        }
        if (Paths.get(basePathString, new String[0]).isAbsolute()) {
            Path basePath = Paths.get(basePathString, new String[0]);
            if (Paths.get(templateName, new String[0]).isAbsolute()) {
                templateName = basePath.toString() + templateName;
            }
            Path parentPath = basePath.resolve(Paths.get(parentFileName, new String[0])).getParent().normalize();
            Path templatePath = parentPath.resolve(Paths.get(templateName, new String[0])).normalize();
            templatePath = templatePath.normalize();
            return templatePath.toString();
        }
        Path basePath = Paths.get(parentFileName, new String[0]).getParent();
        if (Paths.get(templateName, new String[0]).isAbsolute()) {
            templateName = basePath.toString() + templateName;
        }
        if (basePath == null) {
            Path templatePath = Paths.get(templateName, new String[0]);
            return templatePath.toString();
        }
        Path templatePath = basePath.resolve(Paths.get(templateName, new String[0])).normalize();
        templatePath = templatePath.normalize();
        return templatePath.toString();
    }

    private String resolveAbsolutePath(String filename, String basePath) {
        if (Paths.get(filename, new String[0]).isAbsolute()) {
            return filename;
        }
        if (!Paths.get(basePath, new String[0]).isAbsolute()) {
            throw new PugTemplateLoaderException("Can't resolve absolute path for '" + filename + "' if basePath has not been set.");
        }
        return Paths.get(basePath, new String[0]).resolve(filename).normalize().toString();
    }
}

