/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.pug4j.lexer;

import de.neuland.pug4j.exceptions.ExpressionException;
import de.neuland.pug4j.exceptions.PugLexerException;
import de.neuland.pug4j.expression.ExpressionHandler;
import de.neuland.pug4j.lexer.AttributeValueResponse;
import de.neuland.pug4j.lexer.Scanner;
import de.neuland.pug4j.lexer.token.Assignment;
import de.neuland.pug4j.lexer.token.Attribute;
import de.neuland.pug4j.lexer.token.AttributesBlock;
import de.neuland.pug4j.lexer.token.Block;
import de.neuland.pug4j.lexer.token.BlockCode;
import de.neuland.pug4j.lexer.token.Call;
import de.neuland.pug4j.lexer.token.CaseToken;
import de.neuland.pug4j.lexer.token.Colon;
import de.neuland.pug4j.lexer.token.Comment;
import de.neuland.pug4j.lexer.token.CssClass;
import de.neuland.pug4j.lexer.token.CssId;
import de.neuland.pug4j.lexer.token.Default;
import de.neuland.pug4j.lexer.token.Doctype;
import de.neuland.pug4j.lexer.token.Dot;
import de.neuland.pug4j.lexer.token.Each;
import de.neuland.pug4j.lexer.token.Else;
import de.neuland.pug4j.lexer.token.ElseIf;
import de.neuland.pug4j.lexer.token.EndAttributes;
import de.neuland.pug4j.lexer.token.EndPipelessText;
import de.neuland.pug4j.lexer.token.EndPugInterpolation;
import de.neuland.pug4j.lexer.token.Eos;
import de.neuland.pug4j.lexer.token.Expression;
import de.neuland.pug4j.lexer.token.ExtendsToken;
import de.neuland.pug4j.lexer.token.Filter;
import de.neuland.pug4j.lexer.token.If;
import de.neuland.pug4j.lexer.token.Include;
import de.neuland.pug4j.lexer.token.Indent;
import de.neuland.pug4j.lexer.token.InterpolatedCode;
import de.neuland.pug4j.lexer.token.Interpolation;
import de.neuland.pug4j.lexer.token.Mixin;
import de.neuland.pug4j.lexer.token.MixinBlock;
import de.neuland.pug4j.lexer.token.Newline;
import de.neuland.pug4j.lexer.token.Outdent;
import de.neuland.pug4j.lexer.token.Path;
import de.neuland.pug4j.lexer.token.Slash;
import de.neuland.pug4j.lexer.token.StartAttributes;
import de.neuland.pug4j.lexer.token.StartPipelessText;
import de.neuland.pug4j.lexer.token.StartPugInterpolation;
import de.neuland.pug4j.lexer.token.Tag;
import de.neuland.pug4j.lexer.token.Text;
import de.neuland.pug4j.lexer.token.TextHtml;
import de.neuland.pug4j.lexer.token.Token;
import de.neuland.pug4j.lexer.token.When;
import de.neuland.pug4j.lexer.token.While;
import de.neuland.pug4j.lexer.token.Yield;
import de.neuland.pug4j.parser.node.ExpressionString;
import de.neuland.pug4j.template.TemplateLoader;
import de.neuland.pug4j.util.CharacterParser;
import de.neuland.pug4j.util.Options;
import de.neuland.pug4j.util.StringReplacer;
import de.neuland.pug4j.util.StringReplacerCallback;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public class Lexer {
    private static final Pattern cleanRe = Pattern.compile("^['\"]|['\"]$");
    private static final Pattern doubleQuotedRe = Pattern.compile("^\"[^\"]*\"$");
    private static final Pattern quotedRe = Pattern.compile("^'[^']*'$");
    public static final Pattern PATTERN_MIXIN_BLOCK = Pattern.compile("^block");
    public static final Pattern PATTERN_YIELD = Pattern.compile("^yield");
    public static final Pattern PATTERN_DOT = Pattern.compile("^\\.");
    public static final Pattern PATTERN_DEFAULT = Pattern.compile("^default");
    public static final Pattern PATTERN_CASE = Pattern.compile("^case +([^\\n]+)");
    public static final Pattern PATTERN_WHEN = Pattern.compile("^when +([^:\\n]+)");
    public static final Pattern PATTERN_PATH = Pattern.compile("^ ([^\\n]+)");
    public static final Pattern PATTERN_TEXT_1 = Pattern.compile("^(?:\\| ?| )([^\\n]+)");
    public static final Pattern PATTERN_TEXT_2 = Pattern.compile("^( )");
    public static final Pattern PATTERN_TEXT_3 = Pattern.compile("^\\|( ?)");
    public static final Pattern PATTERN_FILTER = Pattern.compile("^:([\\w\\-]+)");
    public static final Pattern PATTERN_COLON = Pattern.compile("^: +");
    public static final Pattern PATTERN_SLASH = Pattern.compile("^\\/");
    public static final Pattern PATTERN_TAG = Pattern.compile("^(\\w(?:[-:\\w]*\\w)?)");
    public static final Pattern PATTERN_INTERPOLATION = Pattern.compile("^#\\{");
    public static final Pattern PATTERN_BLANK = Pattern.compile("^\\n[ \\t]*\\n");
    public static final Pattern PATTERN_INCLUDE = Pattern.compile("^include(?=:| |$|\\n)");
    public static final Pattern PATTERN_CONDITIONAL = Pattern.compile("^(if|unless|else if|else)\\b([^\\n]*)");
    public static final Pattern PATTERN_EACH = Pattern.compile("^(?:each|for) +([a-zA-Z_$][\\w$]*)(?: *, *([a-zA-Z_$][\\w$]*))? * in *([^\\n]+)");
    public static final Pattern PATTERN_WHILE = Pattern.compile("^while +([^\\n]+)");
    public static final Pattern PATTERN_CODE = Pattern.compile("^(!?=|-)[ \\t]*([^\\n]+)");
    public static final Pattern PATTERN_ATTRIBUTES_BLOCK = Pattern.compile("^&attributes\\b");
    public static final Pattern PATTERN_WHITESPACE = Pattern.compile("[ \\n\\t]");
    public static final Pattern PATTERN_QUOTE = Pattern.compile("['\"]");
    public static final int INFINITY = Integer.MAX_VALUE;
    private LinkedList<String> options;
    Scanner scanner;
    private LinkedList<Token> deferredTokens;
    private int lastIndents = -1;
    private int lineno;
    private int colno;
    private LinkedList<Token> tokens;
    private LinkedList<Integer> indentStack;
    private Pattern indentRe = null;
    private boolean pipeless = false;
    private boolean interpolationAllowed = true;
    private boolean attributeMode;
    private final String filename;
    private final TemplateLoader templateLoader;
    private String indentType;
    private CharacterParser characterParser;
    private ExpressionHandler expressionHandler;
    private boolean ternary = false;
    private boolean ended = false;
    private boolean interpolated = false;

    public Lexer(String filename, TemplateLoader templateLoader, ExpressionHandler expressionHandler) throws IOException {
        this.expressionHandler = expressionHandler;
        this.templateLoader = templateLoader;
        this.filename = this.ensurePugExtension(filename);
        Reader reader = templateLoader.getReader(this.filename);
        this.options = new LinkedList();
        this.scanner = new Scanner(reader);
        this.deferredTokens = new LinkedList();
        this.tokens = new LinkedList();
        this.indentStack = new LinkedList();
        this.indentStack.add(0);
        this.lastIndents = 0;
        this.lineno = 1;
        this.colno = 1;
        this.characterParser = new CharacterParser();
        boolean x = false;
    }

    public Lexer(String input, String filename, TemplateLoader templateLoader, ExpressionHandler expressionHandler, int lineno, int colno, boolean interpolated) throws IOException {
        this(input, filename, templateLoader, expressionHandler);
        this.lineno = lineno;
        this.colno = colno;
        this.interpolated = interpolated;
    }

    public Lexer(String input, String filename, TemplateLoader templateLoader, ExpressionHandler expressionHandler) throws IOException {
        this.expressionHandler = expressionHandler;
        this.templateLoader = templateLoader;
        this.filename = this.ensurePugExtension(filename);
        this.options = new LinkedList();
        this.scanner = new Scanner(input);
        this.deferredTokens = new LinkedList();
        this.tokens = new LinkedList();
        this.indentStack = new LinkedList();
        this.indentStack.add(0);
        this.lastIndents = 0;
        this.lineno = 1;
        this.colno = 1;
        this.characterParser = new CharacterParser();
        boolean x = false;
    }

    private PugLexerException error(String code, String message, Token token) {
        int startLineNumber = 0;
        if (token != null) {
            token.getStartLineNumber();
        }
        return new PugLexerException(code, message, this.filename, startLineNumber, this.templateLoader);
    }

    public boolean next() {
        if (this.blank()) {
            return true;
        }
        if (this.eos()) {
            return true;
        }
        if (this.endInterpolation()) {
            return true;
        }
        if (this.yield()) {
            return true;
        }
        if (this.doctype()) {
            return true;
        }
        if (this.interpolation()) {
            return true;
        }
        if (this.caseToken()) {
            return true;
        }
        if (this.when()) {
            return true;
        }
        if (this.defaultToken()) {
            return true;
        }
        if (this.extendsToken()) {
            return true;
        }
        if (this.append()) {
            return true;
        }
        if (this.prepend()) {
            return true;
        }
        if (this.block()) {
            return true;
        }
        if (this.mixinBlock()) {
            return true;
        }
        if (this.include()) {
            return true;
        }
        if (this.mixin()) {
            return true;
        }
        if (this.call()) {
            return true;
        }
        if (this.conditional()) {
            return true;
        }
        if (this.each()) {
            return true;
        }
        if (this.whileToken()) {
            return true;
        }
        if (this.tag()) {
            return true;
        }
        if (this.filter()) {
            return true;
        }
        if (this.blockCode()) {
            return true;
        }
        if (this.code()) {
            return true;
        }
        if (this.id()) {
            return true;
        }
        if (this.dot()) {
            return true;
        }
        if (this.className()) {
            return true;
        }
        if (this.attrs()) {
            return true;
        }
        if (this.attributesBlock()) {
            return true;
        }
        if (this.indent()) {
            return true;
        }
        if (this.text()) {
            return true;
        }
        if (this.textHtml()) {
            return true;
        }
        if (this.comment()) {
            return true;
        }
        if (this.slash()) {
            return true;
        }
        if (this.colon()) {
            return true;
        }
        return this.fail();
    }

    public void consume(int len) {
        this.scanner.consume(len);
    }

    public void defer(Token tok) {
        this.tokens.push(tok);
    }

    public Token lookahead(int index) {
        boolean found = true;
        while (this.tokens.size() <= index && found) {
            found = this.next();
        }
        if (this.tokens.size() <= index) {
            throw new PugLexerException("Cannot read past the end of a stream", this.filename, this.lineno, this.templateLoader);
        }
        return this.tokens.get(index);
    }

    private CharacterParser.Match bracketExpression() {
        return this.bracketExpression(0);
    }

    private CharacterParser.Match bracketExpression(int skip) {
        CharacterParser.Match range;
        char start = this.scanner.getInput().charAt(skip);
        if (start != '(' && start != '{' && start != '[') {
            throw new PugLexerException("unrecognized start character", this.filename, this.getLineno(), this.templateLoader);
        }
        HashMap<Character, Character> closingBrackets = new HashMap<Character, Character>();
        closingBrackets.put(Character.valueOf('('), Character.valueOf(')'));
        closingBrackets.put(Character.valueOf('{'), Character.valueOf('}'));
        closingBrackets.put(Character.valueOf('['), Character.valueOf(']'));
        char end = ((Character)closingBrackets.get(Character.valueOf(start))).charValue();
        Options options = new Options();
        options.setStart(skip + 1);
        try {
            range = this.characterParser.parseMax(this.scanner.getInput(), options);
        }
        catch (CharacterParser.SyntaxError exception) {
            throw new PugLexerException(exception.getMessage() + " See " + StringUtils.substring((String)this.scanner.getInput(), (int)0, (int)5), this.filename, this.getLineno(), this.templateLoader);
        }
        if (this.scanner.getInput().charAt(range.getEnd()) != end) {
            throw new PugLexerException("start character " + start + " does not match end character " + this.scanner.getInput().charAt(range.getEnd()), this.filename, this.getLineno(), this.templateLoader);
        }
        return range;
    }

    public int getLineno() {
        return this.lineno;
    }

    public void setPipeless(boolean pipeless) {
        this.pipeless = pipeless;
    }

    public Token advance() {
        boolean found = true;
        while (this.tokens.size() <= 0 && found && !this.ended) {
            found = this.next();
        }
        return this.tokens.pollFirst();
    }

    private String scan(String regexp) {
        String result = null;
        Matcher matcher = this.scanner.getMatcherForPattern(regexp);
        if (matcher.find(0) && matcher.groupCount() > 0) {
            int end = matcher.end();
            String val = matcher.group(1);
            int diff = end - (val != null ? val.length() : 0);
            this.consume(end);
            this.incrementColumn(diff);
            return val;
        }
        return result;
    }

    private Token scan(Pattern pattern, Token token) {
        Matcher matcher = this.scanner.getMatcherForPattern(pattern);
        if (matcher.find(0)) {
            int end = matcher.end();
            String val = null;
            if (matcher.groupCount() > 0) {
                val = matcher.group(1);
            }
            int diff = end - (val != null ? val.length() : 0);
            token = this.tok(token);
            token.setValue(val);
            this.consume(end);
            this.incrementColumn(diff);
            return token;
        }
        return null;
    }

    private Token scanEndOfLine(Pattern pattern, Token token) {
        Matcher matcher = this.scanner.getMatcherForPattern(pattern);
        if (matcher.find(0)) {
            String newInput;
            int whitespaceLength = 0;
            Pattern pattern1 = Pattern.compile("^([ ]+)([^ ]*)");
            Matcher whitespace = pattern1.matcher(matcher.group(0));
            if (whitespace.find(0)) {
                whitespaceLength = whitespace.group(1).length();
                this.incrementColumn(whitespaceLength);
            }
            if ((newInput = this.scanner.getInput().substring(matcher.group(0).length())).length() > 0 && newInput.charAt(0) == ':') {
                this.scanner.consume(matcher.group(0).length());
                token = this.tok(token);
                if (matcher.groupCount() > 0) {
                    token.setValue(matcher.group(1));
                }
                this.incrementColumn(matcher.group(0).length() - whitespaceLength);
                return token;
            }
            Pattern pattern2 = Pattern.compile("^[ \\t]*(\\n|$)");
            Matcher matcher1 = pattern2.matcher(newInput);
            if (matcher1.find(0)) {
                Pattern pattern3 = Pattern.compile("^[ \\t]*");
                int length = matcher.group(0).length();
                Matcher matcher2 = pattern3.matcher(newInput);
                if (matcher2.find(0)) {
                    length += matcher2.end();
                }
                this.scanner.consume(length);
                token = this.tok(token);
                if (matcher.groupCount() > 0) {
                    token.setValue(matcher.group(1));
                }
                this.incrementColumn(matcher.group(0).length() - whitespaceLength);
                return token;
            }
        }
        return null;
    }

    private Token stashed() {
        if (this.tokens.size() > 0) {
            return this.tokens.poll();
        }
        return null;
    }

    private Token deferred() {
        if (this.deferredTokens.size() > 0) {
            return this.deferredTokens.poll();
        }
        return null;
    }

    private boolean blank() {
        Matcher matcher = this.scanner.getMatcherForPattern(PATTERN_BLANK);
        if (matcher.find(0)) {
            this.consume(matcher.end() - 1);
            this.incrementLine(1);
            if (this.pipeless) {
                this.pushToken(new Text("", this.lineno));
                return true;
            }
            this.next();
            return true;
        }
        return false;
    }

    private boolean eos() {
        if (this.scanner.getInput().length() > 0) {
            return false;
        }
        if (this.interpolated) {
            throw new PugLexerException("End of line was reached with no closing bracket for interpolation.", this.filename, this.lineno, this.templateLoader);
        }
        int i = 0;
        while (!this.indentStack.get(i).equals(0)) {
            this.pushToken(this.tokEnd(this.tok(new Outdent())));
            ++i;
        }
        this.pushToken(this.tokEnd(this.tok(new Eos(null, this.lineno))));
        this.ended = true;
        return true;
    }

    private boolean comment() {
        Matcher matcher = this.scanner.getMatcherForPattern("^\\/\\/(-)?([^\\n]*)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            boolean buffer;
            this.consume(matcher.end());
            this.interpolationAllowed = buffer = !"-".equals(matcher.group(1));
            Token comment = this.tok(new Comment(matcher.group(2), this.lineno, buffer));
            this.incrementColumn(matcher.end());
            this.pushToken(this.tokEnd(comment));
            this.pipelessText();
            return true;
        }
        return false;
    }

    private boolean code() {
        Matcher matcher = this.scanner.getMatcherForPattern(PATTERN_CODE);
        if (matcher.find(0) && matcher.groupCount() > 1) {
            String flags = matcher.group(1);
            String code = matcher.group(2);
            int shortend = 0;
            if (this.interpolated) {
                CharacterParser.Match parsed = this.characterParser.parseUntil(code, "]");
                shortend = code.length() - parsed.getEnd();
                code = parsed.getSrc();
            }
            int consumed = matcher.end() - shortend;
            this.consume(consumed);
            Expression expression = (Expression)this.tok(new Expression(code, this.lineno));
            expression.setEscape(flags.charAt(0) == '=');
            expression.setBuffer(flags.charAt(0) == '=' || flags.length() > 1 && flags.charAt(1) == '=');
            this.incrementColumn(matcher.end() - matcher.group(2).length());
            if (expression.isBuffer()) {
                this.assertExpression(code);
            }
            this.incrementColumn(code.length());
            this.pushToken(this.tokEnd(expression));
            return true;
        }
        return false;
    }

    private boolean interpolation() {
        Matcher matcher = this.scanner.getMatcherForPattern(PATTERN_INTERPOLATION);
        if (matcher.find(0)) {
            try {
                CharacterParser.Match match = this.bracketExpression(1);
                this.scanner.consume(match.getEnd() + 1);
                Token tok = this.tok(new Interpolation(match.getSrc(), this.lineno));
                this.incrementColumn(2);
                this.assertExpression(match.getSrc());
                String[] splitted = StringUtils.split((String)match.getSrc(), (char)'\n');
                int lines = splitted.length - 1;
                this.incrementLine(lines);
                this.incrementColumn(splitted[lines].length() + 1);
                this.pushToken(this.tokEnd(tok));
                return true;
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private boolean tag() {
        Matcher matcher = this.scanner.getMatcherForPattern(PATTERN_TAG);
        if (matcher.find(0) && matcher.groupCount() > 0) {
            String name = matcher.group(1);
            int length = matcher.group(0).length();
            this.consume(length);
            Token token = this.tok(new Tag(name));
            this.incrementColumn(length);
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean yield() {
        Token token = this.scanEndOfLine(PATTERN_YIELD, new Yield());
        if (token != null) {
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean filter() {
        return this.filter(false);
    }

    private boolean filter(boolean inInclude) {
        Token token = this.scan(PATTERN_FILTER, new Filter());
        if (token != null) {
            this.incrementColumn(token.getValue().length());
            this.pushToken(this.tokEnd(token));
            this.attrs();
            if (!inInclude) {
                this.interpolationAllowed = false;
                this.pipelessText();
            }
            return true;
        }
        return false;
    }

    private boolean each() {
        Matcher matcher = this.scanner.getMatcherForPattern(PATTERN_EACH);
        if (matcher.find(0) && matcher.groupCount() > 2) {
            this.consume(matcher.end());
            String value = matcher.group(1);
            Each each = (Each)this.tok(new Each(value, this.lineno));
            String key = matcher.group(2);
            each.setKey(key);
            String code = matcher.group(3);
            this.incrementColumn(matcher.end() - code.length());
            this.assertExpression(code);
            each.setCode(code);
            this.incrementColumn(code.length());
            this.pushToken(this.tokEnd(each));
            return true;
        }
        return false;
    }

    private boolean whileToken() {
        Matcher matcher = this.scanner.getMatcherForPattern(PATTERN_WHILE);
        if (matcher.find(0) && matcher.groupCount() > 0) {
            this.consume(matcher.end());
            this.assertExpression(matcher.group(1));
            Token token = this.tok(new While(matcher.group(1)));
            this.incrementColumn(matcher.end());
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean conditional() {
        Matcher matcher = this.scanner.getMatcherForPattern(PATTERN_CONDITIONAL);
        if (matcher.find(0) && matcher.groupCount() > 1) {
            this.consume(matcher.end());
            String type = matcher.group(1).replace(' ', '-');
            String js = matcher.group(2);
            if (js != null) {
                js = js.trim();
            }
            Token token = null;
            switch (type) {
                case "if": {
                    this.assertExpression(js);
                    If ifToken = new If(js, this.lineno);
                    token = this.tok(ifToken);
                    break;
                }
                case "else-if": {
                    this.assertExpression(js);
                    token = this.tok(new ElseIf(js, this.lineno));
                    break;
                }
                case "unless": {
                    this.assertExpression(js);
                    If unlessToken = new If("!(" + js + ")", this.lineno);
                    token = this.tok(unlessToken);
                    break;
                }
                case "else": {
                    if (js != null && js.length() > 0) {
                        throw new PugLexerException("`else` cannot have a condition, perhaps you meant `else if`", this.filename, this.lineno, this.templateLoader);
                    }
                    token = this.tok(new Else(null, this.lineno));
                }
            }
            this.incrementColumn(matcher.end() - js.length());
            this.incrementColumn(js.length());
            if (token == null) {
                throw new PugLexerException("type " + type + " no allowed here", this.filename, this.lineno, this.templateLoader);
            }
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean doctype() {
        Token token = this.scanEndOfLine(Pattern.compile("^doctype *([^\\n]*)"), new Doctype());
        if (token != null) {
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean id() {
        Token token = this.scan(Pattern.compile("^#([\\w-]+)"), new CssId());
        if (token != null) {
            this.incrementColumn(token.getValue().length());
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean className() {
        Token token = this.scan(Pattern.compile("^\\.([_a-z0-9\\-]*[_a-z][_a-z0-9\\-]*)", 2), new CssClass());
        if (token != null) {
            this.incrementColumn(token.getValue().length());
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean endInterpolation() {
        if (this.interpolated && this.scanner.getInput().charAt(0) == ']') {
            this.consume(1);
            this.ended = true;
            return true;
        }
        return false;
    }

    private void addText(Token token, String value) {
        this.addText(token, value, null);
    }

    private void addText(Token token, String value, String prefix) {
        this.addText(token, value, prefix, 0);
    }

    private void addText(Token token, String value, String prefix, int escaped) {
        int indexOfStringInterp;
        if (prefix != null && "".equals(value + prefix)) {
            return;
        }
        int indexOfEnd = this.interpolated ? value.indexOf(93) : -1;
        int indexOfStart = this.interpolationAllowed ? value.indexOf("#[") : -1;
        int indexOfEscaped = this.interpolationAllowed ? value.indexOf("\\#[") : -1;
        Matcher matchOfStringInterp = Pattern.compile("(\\\\)?([#!])\\{((?:.|\\n)*)$").matcher(value);
        int n = indexOfStringInterp = this.interpolationAllowed && matchOfStringInterp.find(0) ? matchOfStringInterp.start() : Integer.MAX_VALUE;
        if (indexOfEnd == -1) {
            indexOfEnd = Integer.MAX_VALUE;
        }
        if (indexOfStart == -1) {
            indexOfStart = Integer.MAX_VALUE;
        }
        if (indexOfEscaped == -1) {
            indexOfEscaped = Integer.MAX_VALUE;
        }
        if (indexOfEscaped != Integer.MAX_VALUE && indexOfEscaped < indexOfEnd && indexOfEscaped < indexOfStart && indexOfEscaped < indexOfStringInterp) {
            prefix = prefix != null ? prefix + value.substring(0, indexOfEscaped) + "#[" : value.substring(0, indexOfEscaped) + "#[";
            this.addText(token, StringUtils.substring((String)value, (int)(indexOfEscaped + 3)), prefix, escaped + 1);
            return;
        }
        if (indexOfStart != Integer.MAX_VALUE && indexOfStart < indexOfEnd && indexOfStart < indexOfEscaped && indexOfStart < indexOfStringInterp) {
            Token newToken = this.tok(token);
            if (prefix == null) {
                newToken.setValue(StringUtils.substring((String)value, (int)0, (int)indexOfStart));
                this.incrementColumn(indexOfStart + escaped);
            } else {
                newToken.setValue(prefix + StringUtils.substring((String)value, (int)0, (int)indexOfStart));
                this.incrementColumn(prefix.length() + indexOfStart + escaped);
            }
            this.pushToken(this.tokEnd(newToken));
            StartPugInterpolation startPugInterpolation = (StartPugInterpolation)this.tok(new StartPugInterpolation());
            this.incrementColumn(2);
            this.pushToken(this.tokEnd(startPugInterpolation));
            Lexer child = null;
            try {
                child = new Lexer(value.substring(indexOfStart + 2), this.filename, this.templateLoader, this.expressionHandler, this.lineno, this.colno, true);
            }
            catch (IOException e) {
                new PugLexerException(e.getMessage(), this.filename, this.lineno, this.templateLoader);
            }
            LinkedList<Token> childTokens = child.getTokens();
            this.colno = child.getLineno();
            this.tokens.addAll(childTokens);
            Token endInterpolationToken = this.tok(new EndPugInterpolation());
            this.incrementColumn(1);
            this.pushToken(this.tokEnd(endInterpolationToken));
            this.addText(token, child.getInput());
            return;
        }
        if (indexOfEnd != Integer.MAX_VALUE && indexOfEnd < indexOfStart && indexOfEnd < indexOfEscaped && indexOfEnd < indexOfStringInterp) {
            if (prefix == null) {
                if (StringUtils.substring((String)value, (int)0, (int)indexOfEnd).length() > 0) {
                    this.addText(token, value.substring(0, indexOfEnd), prefix);
                }
            } else if ((prefix + StringUtils.substring((String)value, (int)0, (int)indexOfEnd)).length() > 0) {
                this.addText(token, value.substring(0, indexOfEnd), prefix);
            }
            this.ended = true;
            this.scanner.setInput(value.substring(value.indexOf(93) + 1) + this.scanner.getInput());
            return;
        }
        if (indexOfStringInterp != Integer.MAX_VALUE) {
            if (matchOfStringInterp.group(1) != null) {
                prefix = prefix == null ? StringUtils.substring((String)value, (int)0, (int)indexOfStringInterp) + "#{" : prefix + StringUtils.substring((String)value, (int)0, (int)indexOfStringInterp) + "#{";
                this.addText(token, value.substring(indexOfStringInterp + 3), prefix, escaped + 1);
                return;
            }
            String before = StringUtils.substring((String)value, (int)0, (int)(0 + indexOfStringInterp));
            if (prefix != null || before != null) {
                if (prefix != null) {
                    before = prefix + before;
                }
                Token tok = this.tok(token);
                tok.setValue(before);
                this.incrementColumn(before.length() + escaped);
                this.pushToken(this.tokEnd(tok));
            }
            String rest = matchOfStringInterp.group(3);
            InterpolatedCode interpolatedCodeToken = (InterpolatedCode)this.tok(new InterpolatedCode());
            this.incrementColumn(2);
            CharacterParser.Match range = this.characterParser.parseUntil(rest, "}");
            interpolatedCodeToken.setMustEscape("#".equals(matchOfStringInterp.group(2)));
            interpolatedCodeToken.setBuffer(true);
            interpolatedCodeToken.setValue(range.getSrc());
            this.assertExpression(range.getSrc());
            if (range.getEnd() + 1 < rest.length()) {
                rest = rest.substring(range.getEnd() + 1);
                this.incrementColumn(range.getEnd() + 1);
                this.pushToken(this.tokEnd(interpolatedCodeToken));
                this.addText(token, rest);
            } else {
                this.incrementColumn(rest.length());
                this.pushToken(this.tokEnd(interpolatedCodeToken));
            }
            return;
        }
        if (prefix != null) {
            value = prefix + value;
        }
        Token tok = this.tok(token);
        tok.setValue(value);
        this.incrementColumn(value.length() + escaped);
        this.pushToken(this.tokEnd(tok));
    }

    private boolean text() {
        Text textToken = new Text();
        Token token = this.scan(PATTERN_TEXT_1, textToken);
        if (token == null) {
            token = this.scan(PATTERN_TEXT_2, textToken);
        }
        if (token == null) {
            token = this.scan(PATTERN_TEXT_3, textToken);
        }
        if (token != null) {
            this.addText(new Text(), token.getValue());
            return true;
        }
        return false;
    }

    private boolean textHtml() {
        Token token = this.scan(Pattern.compile("^(<[^\\n]*)"), new TextHtml());
        if (token != null) {
            this.addText(new TextHtml(), token.getValue());
            return true;
        }
        return false;
    }

    private boolean textFail() {
        String val = this.scan("^([^\\.\\n][^\\n]+)");
        if (StringUtils.isNotEmpty((CharSequence)val)) {
            this.pushToken(this.tokEnd(this.tok(new Text(val, this.lineno))));
            return true;
        }
        return false;
    }

    private boolean fail() {
        throw this.error("UNEXPECTED_TEXT", "unexpected text \"" + StringUtils.substring((String)this.scanner.getInput(), (int)0, (int)5) + "\"", null);
    }

    private boolean extendsTokenOld() {
        String val = this.scan("^extends? +([^\\n]+)");
        if (StringUtils.isNotBlank((CharSequence)val)) {
            this.pushToken(this.tokEnd(this.tok(new ExtendsToken(val, this.lineno))));
            return true;
        }
        return false;
    }

    private boolean extendsToken() {
        Token token = this.scan(Pattern.compile("^extends?(?= |$|\\n)"), new ExtendsToken());
        if (token != null) {
            this.pushToken(this.tokEnd(token));
            if (!this.path()) {
                throw new PugLexerException("missing path for extends", this.filename, this.lineno, this.templateLoader);
            }
            return true;
        }
        return false;
    }

    private boolean prepend() {
        Matcher matcher = this.scanner.getMatcherForPattern(Pattern.compile("^(?:block +)?prepend +([^\\n]+)"));
        if (matcher.find(0)) {
            String name = matcher.group(1).trim();
            String comment = "";
            if (name.indexOf("//") != -1) {
                String[] split = StringUtils.split((String)name, (String)"//");
                comment = "//" + StringUtils.join((Object[])Arrays.copyOfRange(split, 1, split.length), (String)"//");
                name = StringUtils.split((String)name, (String)"//")[0].trim();
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Token token = this.tok(new Block(name));
                int len = matcher.group(0).length() - comment.length();
                while (PATTERN_WHITESPACE.matcher(String.valueOf(this.scanner.getInput().charAt(len - 1))).find(0)) {
                    --len;
                }
                this.incrementColumn(len);
                token.setMode("prepend");
                this.pushToken(this.tokEnd(token));
                this.consume(matcher.end() - comment.length());
                this.incrementColumn(matcher.end() - comment.length() - len);
                return true;
            }
        }
        return false;
    }

    private boolean append() {
        Matcher matcher = this.scanner.getMatcherForPattern(Pattern.compile("^(?:block +)?append +([^\\n]+)"));
        if (matcher.find(0)) {
            String name = matcher.group(1).trim();
            String comment = "";
            if (name.indexOf("//") != -1) {
                String[] split = StringUtils.split((String)name, (String)"//");
                comment = "//" + StringUtils.join((Object[])Arrays.copyOfRange(split, 1, split.length), (String)"//");
                name = StringUtils.split((String)name, (String)"//")[0].trim();
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Token token = this.tok(new Block(name));
                int len = matcher.group(0).length() - comment.length();
                while (PATTERN_WHITESPACE.matcher(String.valueOf(this.scanner.getInput().charAt(len - 1))).find(0)) {
                    --len;
                }
                this.incrementColumn(len);
                token.setMode("append");
                this.pushToken(this.tokEnd(token));
                this.consume(matcher.end() - comment.length());
                this.incrementColumn(matcher.end() - comment.length() - len);
                return true;
            }
        }
        return false;
    }

    private boolean block() {
        Matcher matcher = this.scanner.getMatcherForPattern(Pattern.compile("^block +([^\\n]+)"));
        if (matcher.find(0)) {
            String name = matcher.group(1).trim();
            String comment = "";
            if (name.indexOf("//") != -1) {
                String[] split = StringUtils.split((String)name, (String)"//");
                comment = "//" + StringUtils.join((Object[])Arrays.copyOfRange(split, 1, split.length), (String)"//");
                name = StringUtils.split((String)name, (String)"//")[0].trim();
            }
            if (StringUtils.isNotBlank((CharSequence)name)) {
                Token token = this.tok(new Block(name));
                int len = matcher.group(0).length() - comment.length();
                while (PATTERN_WHITESPACE.matcher(String.valueOf(this.scanner.getInput().charAt(len - 1))).find(0)) {
                    --len;
                }
                this.incrementColumn(len);
                token.setMode("replace");
                this.pushToken(this.tokEnd(token));
                this.consume(matcher.end() - comment.length());
                this.incrementColumn(matcher.end() - comment.length() - len);
                return true;
            }
        }
        return false;
    }

    private boolean mixinBlock() {
        Token token = this.scanEndOfLine(PATTERN_MIXIN_BLOCK, new MixinBlock());
        if (token != null) {
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean blockCode() {
        Token token = this.scanEndOfLine(Pattern.compile("^-"), new BlockCode());
        if (token != null) {
            this.pushToken(this.tokEnd(token));
            this.interpolationAllowed = false;
            this.pipelessText();
            return true;
        }
        return false;
    }

    private boolean include() {
        Token token = this.scan(PATTERN_INCLUDE, new Include());
        if (token != null) {
            this.pushToken(this.tokEnd(token));
            while (this.filter(true)) {
            }
            if (!this.path()) {
                if (Pattern.compile("^[^ \\n]+").matcher(this.scanner.getInput()).find(0)) {
                    this.fail();
                } else {
                    throw new PugLexerException("missing path for include", this.filename, this.lineno, this.templateLoader);
                }
            }
            return true;
        }
        return false;
    }

    private boolean path() {
        Token token = this.scanEndOfLine(PATTERN_PATH, new Path());
        if (token != null) {
            token.setValue(token.getValue().trim());
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean caseToken() {
        Token token = this.scanEndOfLine(PATTERN_CASE, new CaseToken());
        if (token != null) {
            this.incrementColumn(-token.getValue().length());
            this.assertExpression(token.getValue());
            this.incrementColumn(token.getValue().length());
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean when() {
        Token token = this.scanEndOfLine(PATTERN_WHEN, new When());
        if (token != null) {
            try {
                Matcher matcher;
                String val = token.getValue();
                CharacterParser.State parse = this.characterParser.parse(val);
                while ((parse.isNesting() || parse.isString()) && (matcher = this.scanner.getMatcherForPattern(":([^:\\n]+)")).find(0)) {
                    val = val + matcher.group(0);
                    int increment = matcher.group(0).length();
                    this.consume(increment);
                    this.incrementColumn(increment);
                    parse = this.characterParser.parse(val);
                }
                this.incrementColumn(-val.length());
                this.assertExpression(val);
                this.incrementColumn(val.length());
                token.setValue(val);
                this.pushToken(this.tokEnd(token));
                return true;
            }
            catch (CharacterParser.SyntaxError syntaxError) {
                throw new PugLexerException(syntaxError.getMessage(), this.filename, this.getLineno(), this.templateLoader);
            }
        }
        return false;
    }

    private boolean defaultToken() {
        Token token = this.scanEndOfLine(PATTERN_DEFAULT, new Default());
        if (token != null) {
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private Token assignment() {
        Matcher matcher = this.scanner.getMatcherForPattern("^(\\w+) += *([^;\\n]+)( *;? *)");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            String name = matcher.group(1);
            String val = matcher.group(2);
            this.consume(matcher.end());
            Assignment assign = new Assignment(val, this.lineno);
            assign.setName(name);
            return assign;
        }
        return null;
    }

    private boolean dot() {
        Token token = this.scanEndOfLine(PATTERN_DOT, new Dot());
        if (token != null) {
            this.pushToken(this.tokEnd(token));
            this.pipelessText();
            return true;
        }
        return false;
    }

    private boolean mixin() {
        Matcher matcher = this.scanner.getMatcherForPattern("^mixin +([-\\w]+)(?: *\\((.*)\\))? *");
        if (matcher.find(0) && matcher.groupCount() > 1) {
            this.consume(matcher.end());
            Mixin tok = (Mixin)this.tok(new Mixin(matcher.group(1), this.lineno));
            tok.setArguments(matcher.group(2));
            this.incrementColumn(matcher.group(0).length());
            this.pushToken(this.tokEnd(tok));
            return true;
        }
        return false;
    }

    private boolean call() {
        Matcher matcher = this.scanner.getMatcherForPattern("^\\+(\\s*)(([-\\w]+)|(#\\{))");
        if (matcher.find(0) && matcher.groupCount() > 3) {
            Call tok;
            int increment;
            if (matcher.group(3) != null) {
                increment = matcher.end();
                this.consume(increment);
                tok = (Call)this.tok(new Call(matcher.group(3), this.lineno));
            } else {
                CharacterParser.Match match = this.bracketExpression(2 + matcher.group(1).length());
                increment = match.getEnd() + 1;
                this.consume(increment);
                this.assertExpression(match.getSrc());
                tok = (Call)this.tok(new Call("#{" + match.getSrc() + "}", this.lineno));
            }
            this.incrementColumn(increment);
            matcher = this.scanner.getMatcherForPattern("^ *\\(");
            if (matcher.find(0)) {
                CharacterParser.Match range = this.bracketExpression(matcher.group(0).length() - 1);
                matcher = Pattern.compile("^\\s*[-\\w]+ *=").matcher(range.getSrc());
                if (!matcher.find(0)) {
                    this.incrementColumn(1);
                    this.consume(range.getEnd() + 1);
                    tok.setArguments(range.getSrc());
                }
                if (tok.getArguments() != null) {
                    this.assertExpression("[" + tok.getArguments() + "]");
                    for (int i = 0; i < tok.getArguments().length(); ++i) {
                        if (tok.getArguments().charAt(i) == '\n') {
                            this.incrementLine(1);
                            continue;
                        }
                        this.incrementColumn(1);
                    }
                }
            }
            this.pushToken(this.tokEnd(tok));
            return true;
        }
        return false;
    }

    public boolean isEndOfAttribute(int i, String str, String key, String val, Loc loc, CharacterParser.State state) {
        if (key.trim().isEmpty()) {
            return false;
        }
        if (i == str.length()) {
            return true;
        }
        if (Loc.KEY.equals((Object)loc)) {
            if (str.charAt(i) == ' ' || str.charAt(i) == '\n') {
                for (int x = i; x < str.length(); ++x) {
                    if (str.charAt(x) == ' ' || str.charAt(x) == '\n') continue;
                    return str.charAt(x) != '=' && str.charAt(x) != '!' && str.charAt(x) != ',';
                }
            }
            return str.charAt(i) == ',';
        }
        if (Loc.VALUE.equals((Object)loc) && !state.isNesting()) {
            try {
                this.expressionHandler.assertExpression(val);
                if (str.charAt(i) == ' ' || str.charAt(i) == '\n') {
                    for (int x = i; x < str.length(); ++x) {
                        if (str.charAt(x) == ' ' || str.charAt(x) == '\n') continue;
                        if (this.characterParser.isPunctuator(Character.valueOf(str.charAt(x))) && str.charAt(x) != '\"' && str.charAt(x) != '\'') {
                            if (str.charAt(x) == '?') {
                                this.ternary = true;
                            }
                            return str.charAt(x) == ':' && !this.ternary;
                        }
                        this.ternary = false;
                        return true;
                    }
                }
                return str.charAt(i) == ',';
            }
            catch (Exception ex) {
                return false;
            }
        }
        return false;
    }

    private String interpolate(String attr, final String quote) {
        Pattern regex = Pattern.compile("(\\\\)?#\\{(.+)");
        return StringReplacer.replace(attr, regex, new StringReplacerCallback(){

            @Override
            public String replace(Matcher m) {
                String match = m.group(0);
                String escape = m.group(1);
                String expr = m.group(2);
                if (escape != null) {
                    return match;
                }
                try {
                    try {
                        CharacterParser.Match range = Lexer.this.characterParser.parseMax(expr);
                        if (expr.charAt(range.getEnd()) != '}') {
                            return Lexer.this.substr(match, 0, 2) + Lexer.this.interpolate(match.substring(2), quote);
                        }
                        Lexer.this.expressionHandler.assertExpression(range.getSrc());
                        return quote + " + (" + range.getSrc() + ") + " + quote + Lexer.this.interpolate(expr.substring(range.getEnd() + 1), quote);
                    }
                    catch (ExpressionException ex) {
                        return Lexer.this.substr(match, 0, 2) + Lexer.this.interpolate(match.substring(2), quote);
                    }
                }
                catch (CharacterParser.SyntaxError e) {
                    throw new PugLexerException(e.getMessage() + " See " + match, Lexer.this.filename, Lexer.this.getLineno(), Lexer.this.templateLoader);
                }
            }
        });
    }

    private String substr(String str, int start, int length) {
        return str.substring(start, start + length);
    }

    private boolean assertNestingCorrect(String exp) {
        try {
            CharacterParser.State res = this.characterParser.parse(exp);
            if (res.isNesting()) {
                throw new PugLexerException("Nesting must match on expression `" + exp + "`", this.filename, this.getLineno(), this.templateLoader);
            }
        }
        catch (CharacterParser.SyntaxError syntaxError) {
            throw new PugLexerException("Nesting must match on expression `" + exp + "`", this.filename, this.getLineno(), this.templateLoader);
        }
        return true;
    }

    private boolean attrs() {
        if (this.scanner.getInput().length() > 1 && '(' == this.scanner.getInput().charAt(0)) {
            Token startAttributesToken = this.tok(new StartAttributes());
            int index = this.bracketExpression().getEnd();
            String str = this.scanner.getInput().substring(1, index);
            this.incrementColumn(1);
            this.pushToken(this.tokEnd(startAttributesToken));
            this.assertNestingCorrect(str);
            this.scanner.consume(index + 1);
            while (str != null && str.length() > 0) {
                str = this.attribute(str);
            }
            Token endAttributesToken = this.tok(new EndAttributes());
            this.incrementColumn(1);
            this.pushToken(this.tokEnd(endAttributesToken));
            return true;
        }
        return false;
    }

    private String attribute(String str) {
        int i;
        Character quote = null;
        Pattern quoteRe = PATTERN_QUOTE;
        String key = "";
        for (i = 0; i < str.length() && PATTERN_WHITESPACE.matcher(String.valueOf(str.charAt(i))).find(0); ++i) {
            if (str.charAt(i) == '\n') {
                this.incrementLine(1);
                continue;
            }
            this.incrementColumn(1);
        }
        if (i == str.length()) {
            return "";
        }
        Attribute tok = (Attribute)this.tok(new Attribute());
        if (quoteRe.matcher(String.valueOf(str.charAt(i))).find(0)) {
            quote = Character.valueOf(str.charAt(i));
            this.incrementColumn(1);
            ++i;
        }
        while (i < str.length()) {
            if (quote != null) {
                if (str.charAt(i) == quote.charValue()) {
                    this.incrementColumn(1);
                    ++i;
                    break;
                }
            } else if (PATTERN_WHITESPACE.matcher(String.valueOf(str.charAt(i))).find(0) || str.charAt(i) == '!' || str.charAt(i) == '=' || str.charAt(i) == ',') break;
            key = key + str.charAt(i);
            if (str.charAt(i) == '\n') {
                this.incrementLine(1);
            } else {
                this.incrementColumn(1);
            }
            ++i;
        }
        tok.setName(key);
        AttributeValueResponse valueResponse = this.attributeValue(str.substring(i));
        if (valueResponse.getValue() != null) {
            if ("".equals(valueResponse.getValue())) {
                tok.setAttributeValue(true);
                tok.setEscaped(false);
            } else if (doubleQuotedRe.matcher(valueResponse.getValue()).matches() || quotedRe.matcher(valueResponse.getValue()).matches()) {
                String val = valueResponse.getValue();
                val = val.trim();
                val = val.replaceAll("\\n", "");
                val = StringEscapeUtils.unescapeJson((String)val);
                String cleanValue = cleanRe.matcher(val).replaceAll("");
                tok.setAttributeValue(cleanValue);
                tok.setEscaped(valueResponse.isMustEscape());
            } else {
                ExpressionString expressionString = new ExpressionString(valueResponse.getValue());
                expressionString.setEscape(valueResponse.isMustEscape());
                this.assertExpression(valueResponse.getValue());
                tok.setAttributeValue(expressionString);
                tok.setEscaped(valueResponse.isMustEscape());
            }
        } else {
            tok.setAttributeValue(true);
            tok.setEscaped(true);
        }
        str = valueResponse.getRemainingSource();
        this.pushToken(this.tokEnd(tok));
        for (i = 0; i < str.length() && PATTERN_WHITESPACE.matcher(String.valueOf(str.charAt(i))).find(0); ++i) {
            if (str.charAt(i) == '\n') {
                this.incrementLine(1);
                continue;
            }
            this.incrementColumn(1);
        }
        if (str.length() > i && str.charAt(i) == ',') {
            this.incrementColumn(1);
            ++i;
        }
        return str.substring(i);
    }

    private AttributeValueResponse attributeValue(String str) {
        int i;
        Pattern quoteRe = PATTERN_QUOTE;
        String val = "";
        boolean escapeAttr = true;
        CharacterParser.State state = this.characterParser.defaultState();
        int col = this.colno;
        int line = this.lineno;
        for (i = 0; i < str.length() && PATTERN_WHITESPACE.matcher(String.valueOf(str.charAt(i))).find(0); ++i) {
            if (str.charAt(i) == '\n') {
                ++line;
                col = 1;
                continue;
            }
            ++col;
        }
        if (i == str.length()) {
            return new AttributeValueResponse(null, false, str);
        }
        if (str.charAt(i) == '!') {
            escapeAttr = false;
            ++col;
            if (str.charAt(++i) != '=') {
                throw new PugLexerException("Unexpected character " + str.charAt(i) + " expected `=`", this.filename, this.lineno, this.templateLoader);
            }
        }
        if (str.charAt(i) != '=') {
            if (i == 0 && str.length() > 0 && !PATTERN_WHITESPACE.matcher(String.valueOf(str.charAt(0))).find(0) && str.charAt(0) != ',') {
                throw new PugLexerException("Unexpected character " + str.charAt(i) + " expected `=`", this.filename, this.lineno, this.templateLoader);
            }
            return new AttributeValueResponse(null, false, str);
        }
        this.lineno = line;
        this.colno = col + 1;
        ++i;
        while (i < str.length() && PATTERN_WHITESPACE.matcher(String.valueOf(str.charAt(i))).find(0)) {
            if (str.charAt(i) == '\n') {
                this.incrementLine(1);
            } else {
                this.incrementColumn(1);
            }
            ++i;
        }
        line = this.lineno;
        col = this.colno;
        while (i < str.length()) {
            if (!state.isNesting() && !state.isString()) {
                if (PATTERN_WHITESPACE.matcher(String.valueOf(str.charAt(i))).find(0)) {
                    int x;
                    boolean done = false;
                    for (x = i; x < str.length(); ++x) {
                        boolean isSpreadOperator;
                        if (PATTERN_WHITESPACE.matcher(String.valueOf(str.charAt(x))).find(0)) continue;
                        boolean isNotPunctuator = !this.characterParser.isPunctuator(Character.valueOf(str.charAt(x)));
                        boolean isQuote = PATTERN_QUOTE.matcher(String.valueOf(str.charAt(x))).find(0);
                        boolean isColon = str.charAt(x) == ':';
                        boolean bl = isSpreadOperator = str.length() > x + 2 && "...".equals(str.charAt(x) + str.charAt(x + 1) + str.charAt(x + 2));
                        if (!isNotPunctuator && !isQuote && !isColon && !isSpreadOperator || !this.assertExpression(val, true)) break;
                        done = true;
                        break;
                    }
                    if (done || x == str.length()) break;
                }
                if (str.charAt(i) == ',' && this.assertExpression(val, true)) break;
            }
            state = this.characterParser.parseChar(str.charAt(i), state);
            val = val + str.charAt(i);
            if (str.charAt(i) == '\n') {
                ++line;
                col = 1;
            } else {
                ++col;
            }
            ++i;
        }
        this.lineno = line;
        this.colno = col;
        if ("".equals(val)) {
            return new AttributeValueResponse("", false, str.substring(i));
        }
        return new AttributeValueResponse(val, escapeAttr, str.substring(i));
    }

    private boolean attributesBlock() {
        Matcher matcher = this.scanner.getMatcherForPattern(PATTERN_ATTRIBUTES_BLOCK);
        if (matcher.find(0) && matcher.group(0) != null) {
            int consumed = 11;
            this.scanner.consume(consumed);
            Token attributesBlock = this.tok(new AttributesBlock());
            this.incrementColumn(consumed);
            CharacterParser.Match match = this.bracketExpression();
            consumed = match.getEnd() + 1;
            this.scanner.consume(consumed);
            attributesBlock.setValue(match.getSrc());
            this.incrementColumn(consumed);
            this.pushToken(this.tokEnd(attributesBlock));
            return true;
        }
        return false;
    }

    private int indexOfDelimiters(char start, char end) {
        String str = this.scanner.getInput();
        int nstart = 0;
        int nend = 0;
        int pos = 0;
        int len = str.length();
        for (int i = 0; i < len; ++i) {
            if (start == str.charAt(i)) {
                ++nstart;
                continue;
            }
            if (end != str.charAt(i) || ++nend != nstart) continue;
            pos = i;
            break;
        }
        return pos;
    }

    private Matcher scanIndentation() {
        Matcher matcher;
        if (this.indentRe != null) {
            matcher = this.scanner.getMatcherForPattern(this.indentRe);
        } else {
            Pattern re = Pattern.compile("^\\n(\\t*) *");
            String indentType = "tabs";
            matcher = this.scanner.getMatcherForPattern(re);
            if (matcher.find(0) && matcher.group(1).length() == 0) {
                re = Pattern.compile("^\\n( *)");
                indentType = "spaces";
                matcher = this.scanner.getMatcherForPattern(re);
            }
            if (matcher.find(0) && matcher.group(1).length() > 0) {
                this.indentRe = re;
            }
            this.indentType = indentType;
        }
        return matcher;
    }

    private boolean indent() {
        Matcher matcher = this.scanIndentation();
        if (matcher.find(0) && matcher.groupCount() > 0) {
            int indents = matcher.group(1).length();
            this.incrementLine(1);
            this.consume(indents + 1);
            if (this.scanner.getInput().length() > 0 && (this.scanner.getInput().charAt(0) == ' ' || this.scanner.getInput().charAt(0) == '\t')) {
                throw new PugLexerException("Invalid indentation, you can use tabs or spaces but not both", this.filename, this.getLineno(), this.templateLoader);
            }
            if (this.scanner.isBlankLine()) {
                this.interpolationAllowed = true;
                this.pushToken(this.tokEnd(this.tok(new Newline())));
                return true;
            }
            if (this.indentStack.size() > 0 && indents < this.indentStack.get(0)) {
                int outdent_count = 0;
                while (this.indentStack.size() > 0 && this.indentStack.get(0) > indents) {
                    if (this.indentStack.size() > 1 && this.indentStack.get(1) < indents) {
                        throw new PugLexerException("Inconsistent indentation. Expecting either " + this.indentStack.get(1) + " or " + this.indentStack.get(0) + " spaces/tabs.", this.filename, this.getLineno(), this.templateLoader);
                    }
                    ++outdent_count;
                    this.indentStack.poll();
                }
                while (outdent_count-- != 0) {
                    this.colno = 1;
                    Token tok = this.tok(new Outdent());
                    this.colno = this.indentStack.size() > 0 ? this.indentStack.get(0) + 1 : 1;
                    this.pushToken(this.tokEnd(tok));
                }
            } else if (indents > 0 && (this.indentStack.size() == 0 || indents != this.indentStack.get(0))) {
                Token tok = this.tok(new Indent(String.valueOf(indents), this.lineno));
                this.colno = 1 + indents;
                this.pushToken(this.tokEnd(tok));
                this.indentStack.push(indents);
                tok.setIndents(indents);
            } else {
                Token tok = this.tok(new Newline());
                Integer indentStack0 = 0;
                if (this.indentStack.size() > 0) {
                    indentStack0 = this.indentStack.get(0);
                }
                if (indentStack0 == null) {
                    indentStack0 = 0;
                }
                this.colno = 1 + Math.min(indentStack0, indents);
                this.pushToken(this.tokEnd(tok));
            }
            this.interpolationAllowed = true;
            return true;
        }
        return false;
    }

    private Token pushToken(Token token) {
        this.tokens.add(token);
        return token;
    }

    private Token tok(Token token) {
        try {
            Token newToken = token.clone();
            newToken.setStartLineNumber(this.lineno);
            newToken.setStartColumn(this.colno);
            newToken.setFileName(this.filename);
            return newToken;
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Token tokEnd(Token token) {
        token.setEndLineNumber(this.lineno);
        token.setEndColumn(this.colno);
        return token;
    }

    private void incrementLine(int increment) {
        this.lineno += increment;
        if (increment > 0) {
            this.colno = 1;
        }
    }

    private void incrementColumn(int increment) {
        this.colno += increment;
    }

    private boolean pipelessText() {
        return this.pipelessText(null);
    }

    private boolean pipelessText(Integer indents) {
        while (this.blank()) {
        }
        Matcher matcher = this.scanIndentation();
        if (matcher.find(0) && matcher.group(1).length() > 0) {
            if (indents == null && matcher.groupCount() > 0) {
                indents = matcher.group(1).length();
            }
            if (indents == null) {
                indents = 0;
            }
            if (indents > 0 && (this.indentStack.size() == 0 || indents > this.indentStack.get(0))) {
                this.pushToken(this.tokEnd(this.tok(new StartPipelessText())));
                LinkedList tokenList = new LinkedList();
                ArrayList<Boolean> token_indent = new ArrayList<Boolean>();
                String indent = this.scanner.getInput().substring(1, indents + 1);
                ArrayList<String> tokens = new ArrayList<String>();
                boolean isMatch = false;
                int stringPtr = 0;
                do {
                    int nextLineBreak;
                    if (-1 == (nextLineBreak = this.scanner.getInput().substring(stringPtr + 1).indexOf(10))) {
                        nextLineBreak = this.scanner.getInput().length() - stringPtr - 1;
                    }
                    String line = this.scanner.getInput().substring(stringPtr + 1, stringPtr + 1 + nextLineBreak);
                    Matcher lineCaptures = this.indentRe.matcher("\n" + line);
                    int lineIndents = 0;
                    if (lineCaptures.find(0) && lineCaptures.groupCount() > 0) {
                        lineIndents = lineCaptures.group(1).length();
                    }
                    isMatch = lineIndents >= indents;
                    token_indent.add(isMatch);
                    boolean bl = isMatch = isMatch || line.trim().length() == 0;
                    if (isMatch) {
                        stringPtr += line.length() + 1;
                        String substring = "";
                        if (indents <= line.length()) {
                            substring = line.substring(indents);
                        }
                        tokens.add(substring);
                        continue;
                    }
                    if (this.indentStack.size() <= 0 || lineIndents <= this.indentStack.get(0)) continue;
                    this.tokens.pollLast();
                    return this.pipelessText(lineCaptures.group(1).length());
                } while (this.scanner.getInput().length() - stringPtr > 0 && isMatch);
                this.consume(stringPtr);
                while (this.scanner.getInput().length() == 0 && ((String)tokens.get(tokens.size() - 1)).equals("")) {
                    tokens.remove(tokens.size() - 1);
                }
                for (int i = 0; i < tokens.size(); ++i) {
                    Token token = null;
                    String tokenString = (String)tokens.get(i);
                    this.incrementLine(1);
                    if (i != 0) {
                        token = this.tok(new Newline());
                    }
                    if (((Boolean)token_indent.get(i)).booleanValue()) {
                        this.incrementColumn(indents);
                    }
                    if (token != null) {
                        this.pushToken(this.tokEnd(token));
                    }
                    this.addText(new Text(), tokenString);
                }
                this.pushToken(this.tokEnd(this.tok(new EndPipelessText())));
                return true;
            }
        }
        return false;
    }

    private int calculateIndents(Matcher matcher) {
        int groupLength = matcher.group(1).length();
        int stackSize = this.indentStack.size();
        int indents = this.indentType.equals("tabs") ? Math.min(stackSize + 1, groupLength) : (groupLength > 1 ? Math.min((stackSize + 1) * 2, groupLength) : -1);
        return indents;
    }

    private boolean slash() {
        Token token = this.scan(PATTERN_SLASH, new Slash());
        if (token != null) {
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private boolean colon() {
        Token token = this.scan(PATTERN_COLON, new Colon());
        if (token != null) {
            this.pushToken(this.tokEnd(token));
            return true;
        }
        return false;
    }

    private String ensurePugExtension(String templateName) {
        if (StringUtils.isBlank((CharSequence)FilenameUtils.getExtension((String)templateName))) {
            return templateName + "." + this.templateLoader.getExtension();
        }
        return templateName;
    }

    public boolean getPipeless() {
        return this.pipeless;
    }

    public LinkedList<Token> getTokens() {
        Object t = null;
        LinkedList<Token> list = new LinkedList<Token>();
        while (!this.ended || this.tokens.size() > 0) {
            Token advance = this.advance();
            if (advance == null) continue;
            list.add(advance);
        }
        return list;
    }

    public String getInput() {
        return this.scanner.getInput();
    }

    public boolean assertExpression(String value) {
        return this.assertExpression(value, false);
    }

    public boolean assertExpression(String value, boolean noThrow) {
        try {
            this.expressionHandler.assertExpression(value);
            return true;
        }
        catch (ExpressionException e) {
            if (noThrow) {
                return false;
            }
            throw new PugLexerException(e.getMessage(), this.filename, this.lineno, this.templateLoader);
        }
    }

    private static enum Loc {
        KEY,
        KEY_CHAR,
        VALUE,
        STRING;

    }
}

