/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.jexl2;

import java.util.Collection;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.jexl2.JexlArithmetic;

public class JadeJexlArithmetic
extends JexlArithmetic {
    public JadeJexlArithmetic(boolean lenient) {
        super(lenient);
    }

    public boolean toBoolean(Object val) {
        if (val == null) {
            this.controlNullOperand();
            return false;
        }
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Number) {
            double number = this.toDouble(val);
            return !Double.isNaN(number) && number != 0.0;
        }
        if (val instanceof String) {
            String strval = val.toString();
            return strval.length() > 0 && !"false".equals(strval);
        }
        if (val instanceof Collection) {
            return CollectionUtils.isNotEmpty((Collection)((Collection)val));
        }
        return true;
    }

    public Object add(Object left, Object right) {
        if (left instanceof String || right instanceof String) {
            return left.toString() + right.toString();
        }
        return super.add(left, right);
    }
}

