/*
 * Decompiled with CFR 0.152.
 */
package de.neuland.jade4j.parser.node;

import de.neuland.jade4j.compiler.Utils;
import de.neuland.jade4j.exceptions.ExpressionException;
import de.neuland.jade4j.exceptions.JadeCompilerException;
import de.neuland.jade4j.expression.ExpressionHandler;
import de.neuland.jade4j.model.JadeModel;
import de.neuland.jade4j.parser.node.Attr;
import de.neuland.jade4j.parser.node.ExpressionString;
import de.neuland.jade4j.parser.node.Node;
import de.neuland.jade4j.template.JadeTemplate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;

public abstract class AttrsNode
extends Node {
    private static final String[] selfClosingTags = new String[]{"area", "base", "br", "col", "embed", "hr", "img", "input", "keygen", "link", "menuitem", "meta", "param", "source", "track", "wbr"};
    protected LinkedList<Attr> attributes = new LinkedList();
    protected LinkedList<String> attributeBlocks = new LinkedList();
    protected List<String> attributeNames = new LinkedList<String>();
    protected boolean selfClosing = false;
    protected Node codeNode;
    private boolean textOnly;

    public void setAttribute(String key, Object value, boolean escaped) {
        if (!"class".equals(key) && this.attributeNames.indexOf(key) != -1) {
            throw new Error("Duplicate attribute '" + key + "' is not allowed.");
        }
        this.attributeNames.add(key);
        Attr attr = new Attr();
        attr.setName(key);
        attr.setValue(value);
        attr.setEscaped(escaped);
        this.attributes.add(attr);
    }

    public String getAttribute(String key) {
        int len = this.attributes.size();
        for (int i = 0; i < len; ++i) {
            if (this.attributes.get(i) == null || !this.attributes.get(i).getName().equals(key)) continue;
            return this.attributeValueToString(this.attributes.get(i).getValue());
        }
        return null;
    }

    private String attributeValueToString(Object value) {
        if (value instanceof ExpressionString) {
            String expression = ((ExpressionString)value).getValue();
            return "#{" + expression + "}";
        }
        return value.toString();
    }

    @Override
    public AttrsNode clone() throws CloneNotSupportedException {
        AttrsNode clone = (AttrsNode)super.clone();
        if (this.attributes != null) {
            clone.attributes = new LinkedList<Attr>(this.attributes);
        }
        if (this.attributes != null) {
            clone.attributeBlocks = new LinkedList<String>(this.attributeBlocks);
        }
        return clone;
    }

    public void addAttributes(String src) {
        this.attributeBlocks.add(src);
    }

    public void setSelfClosing(boolean selfClosing) {
        this.selfClosing = selfClosing;
    }

    public boolean isSelfClosing() {
        return this.selfClosing;
    }

    public void setTextOnly(boolean textOnly) {
        this.textOnly = textOnly;
    }

    public boolean isTextOnly() {
        return this.textOnly;
    }

    public void setCodeNode(Node codeNode) {
        this.codeNode = codeNode;
    }

    public boolean hasCodeNode() {
        return this.codeNode != null;
    }

    protected String visitAttributes(JadeModel model, JadeTemplate template) {
        LinkedList<Attr> newAttributes = new LinkedList<Attr>(this.attributes);
        if (this.attributeBlocks.size() > 0) {
            for (String attributeBlock : this.attributeBlocks) {
                HashMap o = null;
                try {
                    o = (HashMap)template.getExpressionHandler().evaluateExpression(attributeBlock, model);
                }
                catch (ExpressionException e) {
                    e.printStackTrace();
                }
                if (o == null) continue;
                for (Map.Entry entry : o.entrySet()) {
                    Attr attr = new Attr();
                    attr.setName(String.valueOf(entry.getKey()));
                    attr.setValue(entry.getValue());
                    newAttributes.add(attr);
                }
            }
            LinkedHashMap<String, String> attrs = this.attrs(model, template, newAttributes);
            return this.attrsToString(attrs, template);
        }
        LinkedHashMap<String, String> attrs = this.attrs(model, template, newAttributes);
        return this.attrsToString(attrs, template);
    }

    private String attrsToString(LinkedHashMap<String, String> attrs, JadeTemplate template) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : attrs.entrySet()) {
            sb.append(" ");
            sb.append(entry.getKey());
            if (entry.getValue() != null) {
                sb.append("=").append('\"');
                sb.append(entry.getValue());
                sb.append('\"');
                continue;
            }
            if (entry.getValue() != null || this.isTerse(template)) continue;
            sb.append("=").append('\"');
            sb.append(entry.getKey());
            sb.append('\"');
        }
        return sb.toString();
    }

    protected LinkedHashMap<String, String> attrs(JadeModel model, JadeTemplate template, LinkedList<Attr> attrs) {
        ArrayList<String> classes = new ArrayList<String>();
        LinkedHashMap<String, String> newAttributes = new LinkedHashMap<String, String>();
        for (Attr attribute : attrs) {
            try {
                this.addAttributesToMap(newAttributes, classes, attribute, model, template);
            }
            catch (ExpressionException e) {
                throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
            }
        }
        LinkedHashMap<String, String> finalAttributes = new LinkedHashMap<String, String>();
        finalAttributes.putAll(newAttributes);
        if (!classes.isEmpty()) {
            finalAttributes.put("class", StringUtils.join(classes, (String)" "));
        }
        return finalAttributes;
    }

    private void addAttributesToMap(HashMap<String, String> newAttributes, ArrayList<String> classes, Attr attribute, JadeModel model, JadeTemplate template) throws ExpressionException {
        String name;
        String key = name = attribute.getName();
        boolean escaped = false;
        String value = null;
        Object attributeValue = attribute.getValue();
        if ("class".equals(key)) {
            if (attributeValue instanceof String) {
                escaped = attribute.isEscaped();
                value = this.getInterpolatedAttributeValue(name, attributeValue, escaped, model, template);
            } else if (attributeValue instanceof ExpressionString) {
                escaped = ((ExpressionString)attributeValue).isEscape();
                Object expressionValue = this.evaluateExpression((ExpressionString)attributeValue, model, template.getExpressionHandler());
                if (expressionValue != null && expressionValue.getClass().isArray()) {
                    StringBuffer s = new StringBuffer("");
                    boolean first = true;
                    if (expressionValue instanceof int[]) {
                        for (int o : (int[])expressionValue) {
                            if (!first) {
                                s.append(" ");
                            }
                            s.append(o);
                            first = false;
                        }
                    } else {
                        for (Object o : (Object[])expressionValue) {
                            if (!first) {
                                s.append(" ");
                            }
                            s.append(o.toString());
                            first = false;
                        }
                    }
                    value = s.toString();
                } else if (expressionValue != null && expressionValue instanceof Boolean) {
                    if (((Boolean)expressionValue).booleanValue()) {
                        value = expressionValue.toString();
                    }
                } else if (expressionValue != null) {
                    value = expressionValue.toString();
                }
            }
            if (!StringUtils.isBlank(value)) {
                classes.add(value);
            }
            return;
        }
        if (attributeValue instanceof String) {
            escaped = attribute.isEscaped();
            value = this.getInterpolatedAttributeValue(name, attributeValue, escaped, model, template);
        } else if (attributeValue instanceof Boolean) {
            if (!((Boolean)attributeValue).booleanValue()) {
                return;
            }
            value = name;
            if (template.isTerse()) {
                value = null;
            }
        } else if (attributeValue instanceof ExpressionString) {
            escaped = ((ExpressionString)attributeValue).isEscape();
            Object expressionValue = this.evaluateExpression((ExpressionString)attributeValue, model, template.getExpressionHandler());
            if (expressionValue == null) {
                return;
            }
            if (expressionValue instanceof Boolean) {
                if (!((Boolean)expressionValue).booleanValue()) {
                    return;
                }
                value = name;
                if (template.isTerse()) {
                    value = null;
                }
            } else {
                value = expressionValue.toString();
                value = StringEscapeUtils.escapeHtml4((String)value);
            }
        } else if (attributeValue instanceof String) {
            value = (String)attributeValue;
        }
        newAttributes.put(name, value);
    }

    private Object evaluateExpression(ExpressionString attribute, JadeModel model, ExpressionHandler expressionHandler) throws ExpressionException {
        String expression = attribute.getValue();
        Object result = expressionHandler.evaluateExpression(expression, model);
        if (result instanceof ExpressionString) {
            return this.evaluateExpression((ExpressionString)result, model, expressionHandler);
        }
        return result;
    }

    private String getInterpolatedAttributeValue(String name, Object attribute, boolean escaped, JadeModel model, JadeTemplate template) throws JadeCompilerException {
        List<Object> prepared = Utils.prepareInterpolate((String)attribute, escaped);
        try {
            return Utils.interpolate(prepared, model, template.getExpressionHandler());
        }
        catch (ExpressionException e) {
            throw new JadeCompilerException((Node)this, template.getTemplateLoader(), e);
        }
    }

    public boolean isTerse(JadeTemplate template) {
        return this.isSelfClosing(template) && template.isTerse();
    }

    public boolean isSelfClosing(JadeTemplate template) {
        return !template.isXml() && ArrayUtils.contains((Object[])selfClosingTags, (Object)this.name);
    }
}

