/*
 * Decompiled with CFR 0.152.
 */
package de.mwvb.base.xml;

import de.mwvb.base.xml.XMLElement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

class XMLElementImpl
implements XMLElement {
    private final Element element;

    XMLElementImpl(Element pElement) {
        this.element = pElement;
    }

    @Override
    public String getName() {
        return this.element.getName();
    }

    @Override
    public void setName(String name) {
        this.element.setName(name);
    }

    @Override
    public String getValue(String pAttributname) {
        String ret = this.element.attributeValue(pAttributname);
        return ret == null ? "" : ret;
    }

    @Override
    public String getMultiLineValue(String pAttributname) {
        return this.getValue(pAttributname).replace("[^NEWLINE^]", "\n");
    }

    @Override
    public void setValue(String pAttributname, String pValue) {
        this.element.addAttribute(pAttributname, pValue);
    }

    @Override
    public void setMultiLineValue(String pAttributname, String pValue) {
        if (pValue == null) {
            this.setValue(pAttributname, pValue);
        } else {
            this.setValue(pAttributname, pValue.replace("\r", "").replace("\n", "[^NEWLINE^]"));
        }
    }

    @Override
    public void setValueIfNotNull(String attributeName, String value) {
        if (value != null) {
            this.element.addAttribute(attributeName, value);
        }
    }

    @Override
    public List<XMLElement> getChildren() {
        return XMLElementImpl.getChildElements(this.element.elements());
    }

    @Override
    public int getChildrenCount() {
        return this.element.elements().size();
    }

    @Override
    public boolean hasChildren() {
        return this.element.elements().size() > 0;
    }

    static List<XMLElement> getChildElements(List<?> list) {
        ArrayList<XMLElement> ret = new ArrayList<XMLElement>();
        for (Object e : list) {
            ret.add(XMLElementImpl.create((Element)e));
        }
        return ret;
    }

    @Override
    public String getXML() {
        return this.element.asXML();
    }

    @Override
    public List<XMLElement> selectNodes(String pXPath) {
        return XMLElementImpl.getChildElements(this.element.selectNodes(pXPath));
    }

    @Override
    public XMLElement selectSingleNode(String pXPath) {
        Node node = this.element.selectSingleNode(pXPath);
        if (node == null || !(node instanceof Element)) {
            return null;
        }
        return XMLElementImpl.create((Element)node);
    }

    @Override
    public int getAttributeCount() {
        return this.element.attributeCount();
    }

    @Override
    public String getAttributeName(int pIndex) {
        return this.element.attribute(pIndex).getName();
    }

    @Override
    public String getText() {
        return this.element.getText();
    }

    @Override
    public void setText(String pText) {
        this.element.setText(pText);
    }

    @Override
    public XMLElement add(String pElementName) {
        return XMLElementImpl.create(this.element.addElement(pElementName));
    }

    @Override
    public XMLElement add(String elementName, String text) {
        XMLElement newElement = this.add(elementName);
        newElement.setText(text);
        return newElement;
    }

    @Override
    public List<String> getArray(String pAttributName) {
        ArrayList<String> array = new ArrayList<String>();
        for (XMLElement e : this.getChildren()) {
            array.add(e.getValue(pAttributName));
        }
        return array;
    }

    @Override
    public Map<String, String> getMap() {
        HashMap<String, String> map = new HashMap<String, String>();
        for (int i = 0; i < this.element.attributeCount(); ++i) {
            Attribute attr = this.element.attribute(i);
            map.put(attr.getName(), attr.getValue());
        }
        return map;
    }

    @Override
    public void append(String pXML) {
        try {
            Document doc = DocumentHelper.parseText((String)pXML);
            this.element.add(doc.getRootElement());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void insertXMLBefore(int index, String pXML) {
        try {
            Document doc = DocumentHelper.parseText((String)pXML);
            Element ele = doc.getRootElement();
            this.element.content().add(index, ele);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void removeChildren(int von, int bis) {
        for (int i = this.element.elements().size() - 1; i >= 0; --i) {
            if (i < von || i > bis) continue;
            this.element.elements().remove(i);
        }
    }

    @Override
    public void removeChildren(String pElementName) {
        List list = this.element.selectNodes(pElementName);
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            this.element.remove((Element)iter.next());
        }
    }

    @Override
    public XMLElement insertBefore(int pBeforeIndex, String pNewElementName) {
        int myBeforeIndex = pBeforeIndex;
        Element neu = new DocumentFactory().createElement(pNewElementName);
        int newIndex = -1;
        List c = this.element.content();
        for (int i = 0; i < c.size(); ++i) {
            String n = c.get(i).getClass().getName();
            if (!n.endsWith("Element") || ++newIndex != myBeforeIndex) continue;
            myBeforeIndex = i;
            break;
        }
        this.element.content().add(myBeforeIndex, neu);
        return XMLElementImpl.create(neu);
    }

    @Override
    public int indexByName(String pElementName, int pStart) {
        List children = this.element.elements();
        for (int i = pStart; i < children.size(); ++i) {
            if (!((Element)children.get(i)).getName().equals(pElementName)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void removeAttribute(String attributeName) {
        try {
            this.element.remove(this.element.attribute(attributeName));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    static XMLElement create(Element pElement) {
        return new XMLElementImpl(pElement);
    }

    @Override
    public boolean hasAttribute(String pAttributname) {
        return this.element.attributeValue(pAttributname) != null;
    }

    @Override
    public void removeEmptyAttributes() {
        ArrayList<String> zuLoeschendeAttribute = new ArrayList<String>();
        for (int i = 0; i < this.getAttributeCount(); ++i) {
            String name = this.getAttributeName(i);
            if (!"".equals(this.getValue(name))) continue;
            zuLoeschendeAttribute.add(name);
        }
        for (String name : zuLoeschendeAttribute) {
            this.removeAttribute(name);
        }
    }

    @Override
    public void setCdata(String cdata) {
        String cdataEndString = "]]>";
        int start = 0;
        int o = cdata.indexOf("]]>");
        while (o >= 0) {
            this.element.addCDATA(cdata.substring(start, o += 2));
            start = o;
            o = cdata.indexOf("]]>", start);
        }
        this.element.addCDATA(start == 0 ? cdata : cdata.substring(start));
    }

    @Override
    public XMLElement addWithAttributes(String elementname, String ... attr) {
        if (attr.length % 2 != 0) {
            throw new IllegalArgumentException("The number of attr-arguments must be even!");
        }
        XMLElement e = this.add(elementname);
        for (int i = 0; i < attr.length; i += 2) {
            e.setValue(attr[i], attr[i + 1]);
        }
        return e;
    }

    @Override
    public XMLElement getOrAdd(String elementname) {
        XMLElement ret = this.selectSingleNode(elementname);
        return ret == null ? this.add(elementname) : ret;
    }

    @Override
    public String getPath() {
        return this.element.getPath();
    }

    @Override
    public String getPath(XMLElement context) {
        return this.element.getPath(((XMLElementImpl)context).element);
    }

    @Override
    public XMLElement getParent() {
        return this.selectSingleNode("..");
    }

    @Override
    public XMLElement getRoot() {
        XMLElement pick = this;
        while (pick.getParent() != null) {
            pick = pick.getParent();
        }
        return pick;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.element == null ? 0 : this.element.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XMLElementImpl other = (XMLElementImpl)obj;
        return !(this.element == null ? other.element != null : !this.element.equals(other.element));
    }

    public String toString() {
        return this.getName() + this.getMap().toString();
    }
}

