/*
 * Decompiled with CFR 0.152.
 */
package de.mwvb.base.xml;

import de.mwvb.base.xml.XMLElement;
import de.mwvb.base.xml.XMLElementImpl;
import java.io.Closeable;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;
import org.dom4j.io.DOMReader;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;

public class XMLDocument
implements Closeable {
    private Document doc;

    public XMLDocument() {
    }

    public XMLDocument(String xml) {
        if (xml == null) {
            throw new IllegalArgumentException("XMLDocument argument xml must not be null!");
        }
        try {
            this.doc = DocumentHelper.parseText((String)xml);
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    public XMLDocument(boolean isResource, String fileName) {
        if (fileName.startsWith("file:") || fileName.startsWith("http:")) {
            try {
                URL url = new URL(fileName);
                this.loadStream(url.openConnection().getInputStream());
            }
            catch (Throwable e) {
                throw new RuntimeException("Error loading XML file '" + fileName + "'!", e);
            }
        } else if (isResource) {
            this.loadResource(fileName);
        } else {
            this.loadFile(fileName);
        }
    }

    public XMLDocument(File file) {
        this(false, file.getPath());
    }

    public XMLDocument(InputStream stream) {
        this.loadStream(stream);
    }

    public XMLDocument(Class<?> clazz, String resourceName) {
        int slash = 47;
        String path = clazz.getPackage().getName().replace('.', '/');
        this.loadResource('/' + path + '/' + resourceName);
    }

    public XMLDocument(org.w3c.dom.Document w3cDoc) {
        DOMReader reader = new DOMReader();
        this.doc = reader.read(w3cDoc);
    }

    public static XMLDocument load(String fileName) {
        XMLDocument ret = new XMLDocument();
        ret.loadFile(fileName);
        return ret;
    }

    public static String loadXML(String fileName) {
        XMLDocument ret = new XMLDocument();
        try {
            ret.loadFile(fileName);
            String string = ret.getXML();
            return string;
        }
        finally {
            ret.close();
        }
    }

    public void loadFile(String fileName) {
        try {
            SAXReader r = new SAXReader();
            this.doc = r.read(fileName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void loadResource(String resourceName) {
        InputStream stream = this.getClass().getResourceAsStream(resourceName);
        if (stream == null) {
            throw new RuntimeException("Error loading resource file '" + resourceName + "'!");
        }
        this.loadStream(stream);
    }

    public void loadStream(InputStream stream) {
        try {
            SAXReader r = new SAXReader();
            this.doc = r.read(stream);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            if (stream != null) {
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    public void saveFile(String fileName) {
        this.saveFile(fileName, OutputFormat.createPrettyPrint());
    }

    public void saveFileCompact(String fileName) {
        this.saveFile(fileName, OutputFormat.createCompactFormat());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFile(String fileName, OutputFormat format) {
        try {
            FileWriter writer = new FileWriter(fileName);
            try {
                format.setEncoding(this.getEncoding());
                new XMLWriter((Writer)writer, format).write(this.doc);
            }
            finally {
                writer.close();
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected String getEncoding() {
        return "windows-1252";
    }

    public boolean isOkay() {
        return this.doc != null && this.doc.getRootElement() != null && this.doc.getRootElement().elements() != null && this.doc.getRootElement().elements().size() > 0;
    }

    public XMLElement getElement() {
        return this.doc == null ? null : XMLElementImpl.create(this.doc.getRootElement());
    }

    public List<XMLElement> getChildren() {
        return XMLElementImpl.getChildElements(this.doc.getRootElement().elements());
    }

    public List<XMLElement> selectNodes(String pXPath) {
        return XMLElementImpl.getChildElements(this.doc.selectNodes(pXPath));
    }

    public XMLElement selectSingleNode(String pXPath) {
        Node node = this.doc.selectSingleNode(pXPath);
        if (node == null) {
            return null;
        }
        return XMLElementImpl.create((Element)node);
    }

    public XMLElement byId(String id) {
        return this.selectSingleNode("//*[@id='" + id + "']");
    }

    public boolean removeChildById(String id) {
        String xpath = "*[@id='" + id + "']";
        XMLElement p = this.selectSingleNode("//" + xpath + "/..");
        if (p != null) {
            p.removeChildren(xpath);
        }
        return p != null;
    }

    public String getXML() {
        return this.doc.asXML();
    }

    public String toString() {
        return this.getXML();
    }

    public org.w3c.dom.Document getW3CDocument() throws DocumentException {
        return new DOMWriter().write(this.doc);
    }

    @Override
    public void close() {
        this.doc = null;
    }
}

